/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.aspects;

import java.io.CharArrayReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.io.SCXMLParser;
import org.apache.commons.scxml.model.Data;
import org.apache.commons.scxml.model.Datamodel;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.SCXML;
import org.apache.commons.scxml.model.State;
import org.apache.commons.scxml.model.Transition;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Element;
import org.wso2.carbon.governance.registry.extensions.aspects.utils.StatCollection;
import org.wso2.carbon.governance.registry.extensions.aspects.utils.StatWriter;
import org.wso2.carbon.governance.registry.extensions.aspects.utils.Utils;
import org.wso2.carbon.governance.registry.extensions.beans.CheckItemBean;
import org.wso2.carbon.governance.registry.extensions.beans.CustomCodeBean;
import org.wso2.carbon.governance.registry.extensions.beans.PermissionsBean;
import org.wso2.carbon.governance.registry.extensions.beans.ScriptBean;
import org.wso2.carbon.governance.registry.extensions.interfaces.CustomValidations;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.mashup.javascript.hostobjects.registry.CollectionHostObject;
import org.wso2.carbon.mashup.javascript.hostobjects.registry.RegistryHostObject;
import org.wso2.carbon.mashup.javascript.hostobjects.registry.ResourceHostObject;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.UserStoreException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultLifeCycle
extends Aspect {
    private static final Log log = LogFactory.getLog(DefaultLifeCycle.class);
    private String lifecycleProperty = "registry.LC.name";
    private String stateProperty = "registry.lifecycle.SoftwareProjectLifecycle.state";
    private List<String> states;
    private Map<String, List<CheckItemBean>> checkListItems;
    private Map<String, List<CustomCodeBean>> transitionValidations;
    private Map<String, List<CustomCodeBean>> transitionExecution;
    private Map<String, List<PermissionsBean>> transitionPermission;
    private Map<String, List<String>> stateEvents;
    private Map<String, List<ScriptBean>> scriptElements;
    private Map<String, Map<String, String>> transitionUIs;
    private boolean isConfigurationFromResource;
    private String configurationResourcePath;
    private OMElement configurationElement;
    private String aspectName;
    private boolean isAuditEnabled;
    private SCXML scxml;

    public DefaultLifeCycle(OMElement config) throws RegistryException {
        String currentAspectName;
        this.initialize();
        this.aspectName = currentAspectName = config.getAttributeValue(new QName("name"));
        currentAspectName = currentAspectName.replaceAll("\\s", "");
        this.stateProperty = "registry.lifecycle." + currentAspectName + ".state";
        Iterator stateElements = config.getChildElements();
        while (stateElements.hasNext()) {
            String name;
            OMElement stateEl = (OMElement)stateElements.next();
            if (stateEl.getAttribute(new QName("type")) != null) {
                String type = stateEl.getAttributeValue(new QName("type"));
                if (type.equalsIgnoreCase("resource")) {
                    this.isConfigurationFromResource = true;
                    this.configurationResourcePath = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)stateEl.getText());
                    this.clearAll();
                    break;
                }
                if (type.equalsIgnoreCase("literal")) {
                    this.isConfigurationFromResource = false;
                    this.configurationElement = stateEl.getFirstElement();
                    this.clearAll();
                    break;
                }
            }
            if ((name = stateEl.getAttributeValue(new QName("name"))) == null) {
                throw new IllegalArgumentException("Must have a name attribute for each state");
            }
            this.states.add(name);
        }
    }

    private void clearAll() {
        this.states.clear();
        this.checkListItems.clear();
        this.transitionPermission.clear();
        this.transitionValidations.clear();
        this.transitionExecution.clear();
        this.transitionUIs.clear();
    }

    private void initialize() {
        this.states = new ArrayList<String>();
        this.checkListItems = new HashMap<String, List<CheckItemBean>>();
        this.transitionValidations = new HashMap<String, List<CustomCodeBean>>();
        this.transitionExecution = new HashMap<String, List<CustomCodeBean>>();
        this.transitionPermission = new HashMap<String, List<PermissionsBean>>();
        this.stateEvents = new HashMap<String, List<String>>();
        this.scriptElements = new HashMap<String, List<ScriptBean>>();
        this.transitionUIs = new HashMap<String, Map<String, String>>();
        this.isAuditEnabled = true;
    }

    public void associate(Resource resource, Registry registry) throws RegistryException {
        this.clearAll();
        try {
            this.setSCXMLConfiguration(registry);
            if (this.configurationElement == null) {
                return;
            }
            List propertyValues = resource.getPropertyValues(this.lifecycleProperty);
            if (propertyValues != null && propertyValues.size() > 0) {
                return;
            }
            if (this.states.size() == 0) {
                this.populateItems();
            }
            String initialState = this.scxml.getInitial();
            this.AddCheckItems(resource, this.checkListItems.get(initialState), initialState);
            this.addScripts(initialState, resource);
            this.addTransitionUI(resource, initialState);
        }
        catch (Exception e) {
            String message = "Resource does not contain a valid XML configuration: " + e.toString();
            log.error((Object)message);
            return;
        }
        resource.setProperty(this.stateProperty, this.scxml.getInitial().replace(".", " "));
        resource.setProperty(this.lifecycleProperty, this.aspectName);
    }

    private void setSCXMLConfiguration(Registry registry) throws RegistryException, XMLStreamException, IOException, SAXException, ModelException {
        if (this.isConfigurationFromResource) {
            if (registry.resourceExists(this.configurationResourcePath)) {
                try {
                    Resource configurationResource = registry.get(this.configurationResourcePath);
                    String xmlContent = RegistryUtils.decodeBytes((byte[])((byte[])configurationResource.getContent()));
                    this.configurationElement = AXIOMUtil.stringToOM((String)xmlContent);
                }
                catch (Exception e) {
                    String msg = "Invalid lifecycle configuration found at " + this.configurationResourcePath;
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
            } else {
                String msg = "Unable to find the lifecycle configuration from the given path: " + this.configurationResourcePath;
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
        }
        try {
            if (this.configurationElement.getAttributeValue(new QName("audit")) != null) {
                this.isAuditEnabled = Boolean.parseBoolean(this.configurationElement.getAttributeValue(new QName("audit")));
            }
            OMElement scxmlElement = this.configurationElement.getFirstElement();
            this.scxml = SCXMLParser.parse((InputSource)new InputSource(new CharArrayReader(scxmlElement.toString().toCharArray())), null);
        }
        catch (Exception e) {
            String msg = "Invalid SCXML configuration found";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
    }

    private void addTransitionUI(Resource resource, String stateName) {
        Map<String, String> currentStateTransitionUI = this.transitionUIs.get(stateName);
        ArrayList<String> tobeRemoved = new ArrayList<String>();
        Properties properties = resource.getProperties();
        for (Object object : properties.keySet()) {
            if (!object.toString().startsWith("registry.custom_lifecycle.checklist.transition.ui.")) continue;
            tobeRemoved.add(object.toString());
        }
        for (String string : tobeRemoved) {
            resource.removeProperty(string);
        }
        if (currentStateTransitionUI != null) {
            for (Map.Entry entry : currentStateTransitionUI.entrySet()) {
                resource.setProperty("registry.custom_lifecycle.checklist.transition.ui." + (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void AddCheckItems(Resource resource, List<CheckItemBean> currentStateCheckItems, String state) {
        if (currentStateCheckItems != null) {
            int order = 0;
            for (CheckItemBean currentStateCheckItem : currentStateCheckItems) {
                List<PermissionsBean> permissions = currentStateCheckItem.getPermissionsBeans();
                ArrayList<String> allowedRoles = new ArrayList<String>();
                for (PermissionsBean permission : permissions) {
                    allowedRoles.addAll(permission.getRoles());
                }
                ArrayList<String> items = new ArrayList<String>();
                items.add("status:" + state);
                items.add("name:" + currentStateCheckItem.getName());
                items.add("value:false");
                items.add("order:" + order);
                String resourcePropertyNameForItem = "registry.custom_lifecycle.checklist.option." + order + ".item";
                String resourcePropertyNameForItemPermission = "registry.custom_lifecycle.checklist.option." + order + ".item.permission";
                resource.setProperty(resourcePropertyNameForItem, items);
                if (allowedRoles.isEmpty()) {
                    resource.setProperty(resourcePropertyNameForItemPermission, resourcePropertyNameForItemPermission);
                } else {
                    resource.setProperty(resourcePropertyNameForItemPermission, allowedRoles);
                }
                ++order;
            }
        }
    }

    private void addScripts(String state, Resource resource) {
        List<ScriptBean> scriptList = this.scriptElements.get(state);
        if (scriptList != null) {
            for (ScriptBean scriptBean : scriptList) {
                if (!scriptBean.isConsole()) continue;
                ArrayList<String> items = new ArrayList<String>();
                items.add(scriptBean.getScript());
                items.add(scriptBean.getFunctionName());
                String resourcePropertyNameForScript = "registry.custom_lifecycle.checklist.js.script.console." + state + "." + scriptBean.getEventName();
                resource.setProperty(resourcePropertyNameForScript, items);
            }
        }
    }

    public String[] getAvailableActions(RequestContext context) {
        Resource resource = context.getResource();
        if (resource.getProperty(this.stateProperty) == null) {
            return new String[0];
        }
        String currentState = resource.getProperty(this.stateProperty).replace(" ", ".");
        try {
            if (this.states.size() == 0 || !this.states.contains(currentState)) {
                this.clearAll();
                Registry registry = context.getRegistry();
                this.setSCXMLConfiguration(registry);
                this.populateItems();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Resource does not contain a valid XML configuration: " + e.toString());
        }
        ArrayList<String> actions = new ArrayList<String>();
        String user = CurrentSession.getUser();
        State currentExecutionState = (State)this.scxml.getChildren().get(currentState);
        List currentTransitions = currentExecutionState.getTransitionsList();
        try {
            List<PermissionsBean> permissionsBeans = this.transitionPermission.get(currentState);
            String[] roles = CurrentSession.getUserRealm().getUserStoreManager().getRoleListOfUser(user);
            for (Object currentTransition : currentTransitions) {
                Transition t = (Transition)currentTransition;
                String transitionName = t.getEvent();
                List<String> possibleActions = this.getPossibleActions(resource, currentState);
                if (!this.getTransitionPermission(roles, permissionsBeans, transitionName) && permissionsBeans != null || !possibleActions.contains(transitionName)) continue;
                actions.add(transitionName);
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Failed to get the current user role :", (Throwable)e);
            return new String[0];
        }
        return actions.toArray(new String[actions.size()]);
    }

    private boolean getTransitionPermission(String[] roles, List<PermissionsBean> permissionsBeans, String eventName) {
        HashSet<String> premSet = new HashSet<String>(Arrays.asList(roles));
        if (permissionsBeans != null) {
            for (PermissionsBean permission : permissionsBeans) {
                if (!permission.getForEvent().equals(eventName) || permission.getRoles() == null) continue;
                List<String> permRoles = permission.getRoles();
                premSet.retainAll(permRoles);
            }
        }
        return !premSet.isEmpty();
    }

    private boolean doAllCustomValidations(RequestContext context, String currentState, String action) throws RegistryException {
        List<CheckItemBean> currentStateCheckItems = this.checkListItems.get(currentState);
        if (currentStateCheckItems != null) {
            for (CheckItemBean currentStateCheckItem : currentStateCheckItems) {
                try {
                    this.runCustomValidationsCode(context, currentStateCheckItem.getValidationBeans(), action);
                }
                catch (RegistryException registryException) {
                    throw new RegistryException("Validation failed for check item : " + currentStateCheckItem.getName());
                }
            }
        }
        try {
            return this.runCustomValidationsCode(context, this.transitionValidations.get(currentState), action);
        }
        catch (RegistryException e) {
            throw new RegistryException("Validation failed for check item : " + action);
        }
    }

    private boolean runCustomValidationsCode(RequestContext context, List<CustomCodeBean> customCodeBeans, String action) throws RegistryException {
        if (customCodeBeans != null) {
            for (CustomCodeBean customCodeBean : customCodeBeans) {
                if (!customCodeBean.getEventName().equals(action)) continue;
                CustomValidations customValidations = (CustomValidations)customCodeBean.getClassObeject();
                ((StatCollection)context.getProperty("statCollection")).addValidations(customCodeBean.getClass().getName(), null);
                if (customValidations.validate(context)) continue;
                ((StatCollection)context.getProperty("statCollection")).addValidations(customCodeBean.getClass().getName(), Utils.getHistoryInfoElement("validation failed"));
                String userMsg = (String)context.getProperty("validationsMessage");
                String message = "Validation : " + customCodeBean.getClassObeject().getClass().getName() + " failed for action : " + customCodeBean.getEventName();
                if (userMsg != null) {
                    message = message + " Embedded error : " + userMsg;
                }
                throw new RegistryException(message);
            }
        }
        return true;
    }

    private boolean runCustomExecutorsCode(String action, RequestContext context, List<CustomCodeBean> customCodeBeans, String currentState, String nextState) throws RegistryException {
        if (customCodeBeans != null) {
            for (CustomCodeBean customCodeBean : customCodeBeans) {
                if (!customCodeBean.getEventName().equals(action)) continue;
                Execution customExecutor = (Execution)customCodeBean.getClassObeject();
                ((StatCollection)context.getProperty("statCollection")).addExecutors(customExecutor.getClass().getName(), null);
                if (customExecutor.execute(context, currentState, nextState)) continue;
                ((StatCollection)context.getProperty("statCollection")).addExecutors(customExecutor.getClass().getName(), Utils.getHistoryInfoElement("executor failed"));
                String userMsg = (String)context.getProperty("executorMessage");
                String message = "Execution failed for action : " + customCodeBean.getEventName();
                if (userMsg != null) {
                    message = message + " Embedded error : " + userMsg;
                }
                throw new RegistryException(message);
            }
        }
        return true;
    }

    private CustomValidations loadCustomValidators(String className, Map parameterMap) throws Exception {
        CustomValidations customValidations;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> customCodeClass = Class.forName(className, true, loader);
            customValidations = (CustomValidations)customCodeClass.newInstance();
            customValidations.init(parameterMap);
        }
        catch (Exception e) {
            String msg = "Unable to load validations class";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return customValidations;
    }

    private Execution loadCustomExecutors(String className, Map parameterMap) throws Exception {
        Execution customExecutors;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> customCodeClass = Class.forName(className, true, loader);
            customExecutors = (Execution)customCodeClass.newInstance();
            customExecutors.init(parameterMap);
        }
        catch (Exception e) {
            String msg = "Unable to load executions class";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return customExecutors;
    }

    private void handleItemClick(Resource resource, Map<String, String> itemParameterMap, RequestContext context) throws RegistryException {
        for (Map.Entry<String, String> entry : itemParameterMap.entrySet()) {
            List propertyValues = resource.getPropertyValues("registry.custom_lifecycle.checklist.option." + entry.getKey());
            if (propertyValues == null) continue;
            for (String propertyValue : propertyValues) {
                if (!propertyValue.startsWith("value:") || propertyValue.contains(entry.getValue())) continue;
                ArrayList<String> newProps = new ArrayList<String>(propertyValues);
                newProps.remove(propertyValue);
                String replace = propertyValue.replace(Boolean.toString(Boolean.valueOf(entry.getValue()) == false), entry.getValue());
                newProps.add(replace);
                resource.removeProperty("registry.custom_lifecycle.checklist.option." + entry.getKey());
                resource.setProperty("registry.custom_lifecycle.checklist.option." + entry.getKey(), newProps);
                StatCollection statCollection = (StatCollection)context.getProperty("statCollection");
                statCollection.setAction(this.getCheckItemName(propertyValues));
                statCollection.setActionType("itemClick");
                statCollection.setActionValue(replace);
                if (resource.getProperty("registry.lifecycle_history.originalPath") == null) continue;
                statCollection.setOriginalPath(resource.getProperty("registry.lifecycle_history.originalPath"));
            }
        }
    }

    private String getCheckItemName(List<String> propValues) {
        String name = null;
        for (String propValue : propValues) {
            if (!propValue.startsWith("name:")) continue;
            name = propValue.split("name:")[1];
        }
        return name;
    }

    private Map<String, String> extractCheckItemValues(Map<String, String> parameterMap) {
        HashMap<String, String> checkItems = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            if (!entry.getKey().endsWith(".item")) continue;
            checkItems.put(entry.getKey(), entry.getValue());
        }
        return checkItems;
    }

    public void invoke(RequestContext context, String action) throws RegistryException {
        this.invoke(context, action, Collections.<String, String>emptyMap());
    }

    public void invoke(RequestContext requestContext, String action, Map<String, String> parameterMap) throws RegistryException {
        boolean preserveOldResource = !Boolean.toString(false).equals(parameterMap.remove("preserveOriginal"));
        Resource resource = requestContext.getResource();
        String currentState = resource.getProperty(this.stateProperty).replace(" ", ".");
        String resourcePath = requestContext.getResourcePath().getPath();
        String nextState = currentState;
        String user = CurrentSession.getUser();
        State currentExecutionState = (State)this.scxml.getChildren().get(currentState);
        StatCollection statCollection = new StatCollection();
        statCollection.setAction(action);
        statCollection.setRegistry(requestContext.getSystemRegistry());
        statCollection.setState(currentState);
        statCollection.setResourcePath(resourcePath);
        statCollection.setUserName(user);
        statCollection.setOriginalPath(resourcePath);
        requestContext.setProperty("statCollection", (Object)statCollection);
        this.handleItemClick(resource, this.extractCheckItemValues(parameterMap), requestContext);
        List transitions = currentExecutionState.getTransitionsList();
        try {
            String[] roles = CurrentSession.getUserRealm().getUserStoreManager().getRoleListOfUser(user);
            List<String> possibleEvents = this.getPossibleActions(resource, currentState);
            if (possibleEvents.size() > 0) {
                for (Object o : transitions) {
                    String eventName = ((Transition)o).getEvent();
                    if (!possibleEvents.contains(eventName) || !eventName.equals(action) || !this.getTransitionPermission(roles, this.transitionPermission.get(currentState), eventName)) continue;
                    if (this.doAllCustomValidations(requestContext, currentState, eventName)) {
                        statCollection.setActionType("transition");
                        if (resource.getProperty("registry.lifecycle_history.originalPath") != null) {
                            statCollection.setOriginalPath(resource.getProperty("registry.lifecycle_history.originalPath"));
                        }
                        nextState = ((Transition)o).getNext();
                        this.runCustomExecutorsCode(action, requestContext, this.transitionExecution.get(currentState), currentState, nextState);
                        List<ScriptBean> scriptElement = this.scriptElements.get(currentState);
                        try {
                            if (scriptElement == null) break;
                            for (ScriptBean scriptBean : scriptElement) {
                                if (!scriptBean.getEventName().equals(eventName) || scriptBean.isConsole()) continue;
                                this.executeJS(AXIOMUtil.stringToOM((String)scriptBean.getScript()).getText() + "\n" + scriptBean.getFunctionName() + "()");
                            }
                            break;
                        }
                        catch (Exception e) {
                            String msg = "JavaScript execution failed.";
                            log.error((Object)msg);
                            throw new RegistryException(msg);
                        }
                    }
                    String msg = "Transition validations failed.";
                    log.info((Object)msg);
                    throw new RegistryException(msg);
                }
            }
        }
        catch (UserStoreException e) {
            String msg = "Failed to get the current user role :" + e.toString();
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        catch (RegistryException e) {
            log.error((Object)e);
            throw new RegistryException(e.getMessage());
        }
        if (requestContext.getResource() == null) {
            requestContext.setResource(resource);
            requestContext.setProcessingComplete(true);
            return;
        }
        if (!requestContext.getResource().equals(resource)) {
            requestContext.getRegistry().put(resourcePath, resource);
        }
        resource = requestContext.getResource();
        String newResourcePath = requestContext.getResourcePath().getPath();
        if (!currentState.equals(nextState)) {
            State state = (State)this.scxml.getChildren().get(nextState);
            resource.setProperty(this.stateProperty, state.getId().replace(".", " "));
            this.clearCheckItems(resource);
            this.AddCheckItems(resource, this.checkListItems.get(state.getId()), state.getId());
            this.addScripts(state.getId(), resource);
            this.addTransitionUI(resource, state.getId());
            statCollection.setTargetState(nextState);
        }
        if (!preserveOldResource) {
            requestContext.getRegistry().delete(resourcePath);
        }
        requestContext.getRegistry().put(newResourcePath, resource);
        if (this.isAuditEnabled) {
            new StatWriter().writeHistory((StatCollection)requestContext.getProperty("statCollection"));
        }
    }

    private void clearCheckItems(Resource resource) {
        Properties properties = (Properties)resource.getProperties().clone();
        for (Object o : properties.keySet()) {
            String key = (String)o;
            if (!key.startsWith("registry.custom_lifecycle.checklist.option.")) continue;
            resource.removeProperty(key);
        }
    }

    private void populateItems() throws Exception {
        Map stateList = this.scxml.getChildren();
        Iterator i$ = stateList.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry stateObject;
            Map.Entry state = stateObject = i$.next();
            String currentStateName = (String)state.getKey();
            State currentState = (State)state.getValue();
            Datamodel model = currentState.getDatamodel();
            this.states.add(currentStateName);
            if (model != null) {
                List dataList = model.getData();
                for (Object dataObject : dataList) {
                    Data data = (Data)dataObject;
                    OMElement node = XMLUtils.toOM((Element)((Element)data.getNode()));
                    this.populateCheckItems(currentStateName, node);
                    this.populateTransitionValidations(currentStateName, node);
                    this.populateTransitionPermissions(currentStateName, node);
                    this.populateTransitionScripts(currentStateName, node);
                    this.populateTransitionUIs(currentStateName, node);
                    this.populateTransitionExecutors(currentStateName, node);
                }
            }
            ArrayList<String> events = new ArrayList<String>();
            for (Object t : currentState.getTransitionsList()) {
                Transition transition = (Transition)t;
                events.add(transition.getEvent());
            }
            this.stateEvents.put(currentStateName, events);
        }
    }

    private void populateTransitionExecutors(String currentStateName, OMElement node) throws Exception {
        if (!this.transitionExecution.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("transitionExecution")) {
            ArrayList<CustomCodeBean> customCodeBeanList = new ArrayList<CustomCodeBean>();
            Iterator executorsIterator = node.getChildElements();
            while (executorsIterator.hasNext()) {
                OMElement executorChild = (OMElement)executorsIterator.next();
                customCodeBeanList.add(this.createCustomCodeBean(executorChild, "execution"));
            }
            this.transitionExecution.put(currentStateName, customCodeBeanList);
        }
    }

    private void populateTransitionUIs(String currentStateName, OMElement node) {
        if (!this.transitionUIs.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("transitionUI")) {
            HashMap<String, String> uiEventMap = new HashMap<String, String>();
            Iterator uiIterator = node.getChildElements();
            while (uiIterator.hasNext()) {
                OMElement uiElement = (OMElement)uiIterator.next();
                uiEventMap.put(uiElement.getAttributeValue(new QName("forEvent")), uiElement.getAttributeValue(new QName("href")));
            }
            this.transitionUIs.put(currentStateName, uiEventMap);
        }
    }

    private void populateTransitionScripts(String currentStateName, OMElement node) {
        if (!this.scriptElements.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("transitionScripts")) {
            ArrayList<ScriptBean> scriptBeans = new ArrayList<ScriptBean>();
            Iterator scriptIterator = node.getChildElements();
            while (scriptIterator.hasNext()) {
                OMElement script = (OMElement)scriptIterator.next();
                Iterator scriptChildIterator = script.getChildElements();
                while (scriptChildIterator.hasNext()) {
                    OMElement scriptChild = (OMElement)scriptChildIterator.next();
                    scriptBeans.add(new ScriptBean(scriptChild.getQName().getLocalPart().equals("console"), scriptChild.getAttributeValue(new QName("function")), script.getAttributeValue(new QName("forEvent")), scriptChild.getFirstElement().toString()));
                }
            }
            this.scriptElements.put(currentStateName, scriptBeans);
        }
    }

    private void populateTransitionPermissions(String currentStateName, OMElement node) {
        if (!this.transitionPermission.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("transitionPermission")) {
            ArrayList<PermissionsBean> permissionsBeanList = new ArrayList<PermissionsBean>();
            Iterator permissionIterator = node.getChildElements();
            while (permissionIterator.hasNext()) {
                OMElement permChild = (OMElement)permissionIterator.next();
                permissionsBeanList.add(this.createPermissionBean(permChild));
            }
            this.transitionPermission.put(currentStateName, permissionsBeanList);
        }
    }

    private void populateTransitionValidations(String currentStateName, OMElement node) throws Exception {
        if (!this.transitionValidations.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("transitionValidation")) {
            ArrayList<CustomCodeBean> customCodeBeanList = new ArrayList<CustomCodeBean>();
            Iterator validationsIterator = node.getChildElements();
            while (validationsIterator.hasNext()) {
                OMElement validationChild = (OMElement)validationsIterator.next();
                customCodeBeanList.add(this.createCustomCodeBean(validationChild, "validation"));
            }
            this.transitionValidations.put(currentStateName, customCodeBeanList);
        }
    }

    private void populateCheckItems(String currentStateName, OMElement node) throws Exception {
        if (!this.checkListItems.containsKey(currentStateName) && node.getAttributeValue(new QName("name")).equals("checkItems")) {
            ArrayList<CheckItemBean> checkItems = new ArrayList<CheckItemBean>();
            Iterator checkItemIterator = node.getChildElements();
            while (checkItemIterator.hasNext()) {
                CheckItemBean checkItemBean = new CheckItemBean();
                OMElement childElement = (OMElement)checkItemIterator.next();
                checkItemBean.setName(childElement.getAttributeValue(new QName("name")));
                if (childElement.getAttributeValue(new QName("forEvent")) != null) {
                    checkItemBean.setEvents(Arrays.asList(childElement.getAttributeValue(new QName("forEvent")).split(",")));
                }
                Iterator permissionElementIterator = childElement.getChildrenWithName(new QName("permissions"));
                while (permissionElementIterator.hasNext()) {
                    OMElement permissionElement = (OMElement)permissionElementIterator.next();
                    Iterator permissions = permissionElement.getChildElements();
                    ArrayList<PermissionsBean> permBeanList = new ArrayList<PermissionsBean>();
                    while (permissions.hasNext()) {
                        OMElement permChild = (OMElement)permissions.next();
                        permBeanList.add(this.createPermissionBean(permChild));
                    }
                    checkItemBean.setPermissionsBeans(permBeanList);
                }
                Iterator validationsElementIterator = childElement.getChildrenWithName(new QName("validations"));
                while (validationsElementIterator.hasNext()) {
                    ArrayList<CustomCodeBean> customCodeBeanList = new ArrayList<CustomCodeBean>();
                    OMElement validationElement = (OMElement)validationsElementIterator.next();
                    Iterator validations = validationElement.getChildElements();
                    while (validations.hasNext()) {
                        OMElement validationChild = (OMElement)validations.next();
                        customCodeBeanList.add(this.createCustomCodeBean(validationChild, "validation"));
                    }
                    checkItemBean.setValidationBeans(customCodeBeanList);
                }
                checkItems.add(checkItemBean);
            }
            if (checkItems.size() > 0) {
                this.checkListItems.put(currentStateName, checkItems);
            }
        }
    }

    private PermissionsBean createPermissionBean(OMElement permChild) {
        PermissionsBean permBean = new PermissionsBean();
        permBean.setForEvent(permChild.getAttributeValue(new QName("forEvent")));
        if (permChild.getAttributeValue(new QName("roles")) != null) {
            permBean.setRoles(Arrays.asList(permChild.getAttributeValue(new QName("roles")).split(",")));
        }
        return permBean;
    }

    private CustomCodeBean createCustomCodeBean(OMElement customCodeChild, String type) throws Exception {
        CustomCodeBean customCodeBean = new CustomCodeBean();
        HashMap<String, String> paramNameValues = new HashMap<String, String>();
        Iterator parameters = customCodeChild.getChildElements();
        while (parameters.hasNext()) {
            OMElement paramChild = (OMElement)parameters.next();
            paramNameValues.put(paramChild.getAttributeValue(new QName("name")), paramChild.getAttributeValue(new QName("value")));
        }
        if (type.equals("validation")) {
            customCodeBean.setClassObeject(this.loadCustomValidators(customCodeChild.getAttributeValue(new QName("class")), paramNameValues));
        } else if (type.equals("execution")) {
            customCodeBean.setClassObeject(this.loadCustomExecutors(customCodeChild.getAttributeValue(new QName("class")), paramNameValues));
        }
        customCodeBean.setEventName(customCodeChild.getAttributeValue(new QName("forEvent")));
        return customCodeBean;
    }

    private List<String> getPossibleActions(Resource resource, String currentState) {
        Properties propertyNameValues = resource.getProperties();
        Iterator<Map.Entry<Object, Object>> propIterator = propertyNameValues.entrySet().iterator();
        List<CheckItemBean> checkItems = this.checkListItems.get(currentState);
        ArrayList<String> events = new ArrayList<String>((Collection)this.stateEvents.get(currentState));
        if (checkItems != null && checkItems.size() > 0) {
            while (propIterator.hasNext()) {
                Map.Entry<Object, Object> entry = propIterator.next();
                String propertyName = (String)entry.getKey();
                if (!propertyName.startsWith("registry.custom_lifecycle.checklist.option.")) continue;
                List propValues = (List)entry.getValue();
                for (String propValue : propValues) {
                    if (!propValue.startsWith("name:")) continue;
                    for (CheckItemBean checkItem : checkItems) {
                        if (!checkItem.getName().equals(propValue.substring(propValue.indexOf(":") + 1)) || checkItem.getEvents() == null || !propValues.contains("value:false")) continue;
                        events.removeAll(checkItem.getEvents());
                    }
                }
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJS(String script) throws Exception {
        Context cx = Context.enter();
        try {
            ConfigurationContext configurationContext = MessageContext.getCurrentMessageContext().getConfigurationContext();
            cx.putThreadLocal((Object)"axisConfigurationContext", (Object)configurationContext);
            AxisService service = new AxisService();
            service.addParameter("mashupAuthor", (Object)CurrentSession.getUser());
            cx.putThreadLocal((Object)"axisService", (Object)service);
            ScriptableObject scope = cx.initStandardObjects();
            ScriptableObject.defineClass((Scriptable)scope, ResourceHostObject.class);
            ScriptableObject.defineClass((Scriptable)scope, CollectionHostObject.class);
            ScriptableObject.defineClass((Scriptable)scope, RegistryHostObject.class);
            Object result = cx.evaluateString((Scriptable)scope, script, "<cmd>", 1, null);
            if (result != null && log.isInfoEnabled()) {
                log.info((Object)("JavaScript Result: " + Context.toString((Object)result)));
            }
        }
        catch (IllegalAccessException e) {
            String msg = "Unable to defining registry host objects.";
            throw new Exception(msg, e);
        }
        catch (InstantiationException e) {
            String msg = "Unable to instantiate the given registry host object.";
            throw new Exception(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "An exception occurred while creating registry host objects.";
            throw new Exception(msg, e);
        }
        catch (AxisFault e) {
            String msg = "Failed to set user name parameter.";
            throw new Exception(msg, e);
        }
        catch (SecurityException securityException) {
        }
        finally {
            Context.exit();
        }
    }

    public void dissociate(RequestContext requestContext) {
        Resource resource = requestContext.getResource();
        if (resource != null) {
            resource.removeProperty(this.stateProperty);
            resource.removeProperty(this.lifecycleProperty);
        }
    }
}

