/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class CommonUtil {
    public static String[] getAllLifeCycleStates(Registry registry, String lifeCycleName) throws RegistryException {
        boolean isLiteral = true;
        ArrayList<String> stateList = new ArrayList<String>();
        String[] allAspects = registry.getAvailableAspects();
        if (!Arrays.asList(allAspects).contains(lifeCycleName)) {
            String msg = "There are no lifecycles with the given name";
            throw new RegistryException(msg);
        }
        Resource resource = null;
        if (!registry.resourceExists("/_system/config/repository/components/org.wso2.carbon.governance/lifecycles/" + lifeCycleName)) {
            String msg = "The given lifecycle configuration is an static configuration. Unable to read the registry.xml";
            throw new RegistryException(msg);
        }
        resource = registry.get("/_system/config/repository/components/org.wso2.carbon.governance/lifecycles/" + lifeCycleName);
        try {
            Iterator statesElement;
            String xmlContent = RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
            OMElement configurationElement = AXIOMUtil.stringToOM((String)xmlContent);
            if (isLiteral) {
                OMElement typeElement = configurationElement.getFirstElement();
                configurationElement = typeElement.getFirstElement();
            }
            if ((statesElement = configurationElement.getChildrenWithName(new QName("scxml"))).hasNext()) {
                while (statesElement.hasNext()) {
                    OMElement scxmlElement = (OMElement)statesElement.next();
                    Iterator stateElements = scxmlElement.getChildrenWithName(new QName("state"));
                    while (stateElements.hasNext()) {
                        OMElement next = (OMElement)stateElements.next();
                        stateList.add(next.getAttributeValue(new QName("id")));
                    }
                }
            } else {
                Iterator states = configurationElement.getChildElements();
                while (states.hasNext()) {
                    OMElement next = (OMElement)states.next();
                    stateList.add(next.getAttributeValue(new QName("name")));
                }
            }
        }
        catch (XMLStreamException e) {
            throw new RegistryException("", (Throwable)e);
        }
        String[] retArray = new String[stateList.size()];
        return stateList.toArray(retArray);
    }
}

