/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.internal;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileUtil;

public class GovernanceRegistryExtensionsComponent {
    private static final Log log = LogFactory.getLog(GovernanceRegistryExtensionsComponent.class);
    RegistryService registryService = null;
    private static final String RXT_PATH = "/_system/governance/repository/components/org.wso2.carbon.governance/types";
    private static final String RXT_MEDIA_TYPE = "application/vnd.wso2.registry-ext-type+xml";

    protected void activate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"GovernanceRegistryExtensionsComponent activated");
        }
        try {
            this.addRxtConfigs();
        }
        catch (GovernanceException e) {
            log.error((Object)"Failed to add rxt files to registry", (Throwable)e);
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        if (registryService != null && log.isDebugEnabled()) {
            log.debug((Object)"Registry service initialized");
        }
        this.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.registryService = null;
    }

    public RegistryService getRegistryService() throws RegistryException {
        return this.registryService;
    }

    private void addRxtConfigs() throws GovernanceException {
        String[] rxtFilePaths;
        String path = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "rxts";
        File file = new File(path);
        for (String rxtPath : rxtFilePaths = file.list()) {
            String msg;
            try {
                if (!rxtPath.contains(".rxt")) continue;
                String rxt = FileUtil.readFileToString((String)(path + File.separator + rxtPath));
                UserRegistry registry = this.registryService.getRegistry();
                UserRegistry systemRegistry = this.registryService.getRegistry("wso2.system.user");
                Resource resource = registry.newResource();
                resource.setContent((Object)RegistryUtils.encodeString((String)rxt));
                resource.setMediaType(RXT_MEDIA_TYPE);
                String resourcePath = "/_system/governance/repository/components/org.wso2.carbon.governance/types/" + rxtPath;
                if (registry.resourceExists(resourcePath)) continue;
                systemRegistry.put(resourcePath, resource);
            }
            catch (IOException e) {
                msg = "Failed to read rxt files";
                throw new GovernanceException(msg, (Throwable)e);
            }
            catch (RegistryException e) {
                msg = "Failed to add rxt to registry ";
                throw new GovernanceException(msg, (Throwable)e);
            }
        }
    }
}

