/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.handlers.utils;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.jaxen.JaxenException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ResourceProcessor {
    private Registry registry;

    public ResourceProcessor(Registry registry) {
        this.registry = registry;
    }

    public String addResource(OMElement resourceElement, String basePath) throws JaxenException, RegistryException {
        String path = resourceElement.getAttribute(new QName("path")).getAttributeValue();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        UserRegistry governanceSystemRegistry = RegistryCoreServiceComponent.getRegistryService().getGovernanceSystemRegistry();
        GenericArtifactManager genericArtifactManager = new GenericArtifactManager((Registry)governanceSystemRegistry, "wadlresource");
        GenericArtifact resourceArtifact = genericArtifactManager.newGovernanceArtifact(new QName(path));
        resourceArtifact.addAttribute("overview_name", path);
        resourceArtifact.addAttribute("overview_base", basePath);
        Iterator methods = resourceElement.getChildrenWithLocalName("method");
        while (methods.hasNext()) {
            OMElement method = (OMElement)methods.next();
            if (method.getAttribute(new QName("name")) == null || method.getAttribute(new QName("id")) == null) continue;
            resourceArtifact.addAttribute("methods_entry", method.getAttribute(new QName("name")).getAttributeValue() + ":" + method.getAttribute(new QName("id")).getAttributeValue());
        }
        genericArtifactManager.addGenericArtifact(resourceArtifact);
        return GovernanceUtils.getArtifactPath((Registry)governanceSystemRegistry, (String)resourceArtifact.getId());
    }
}

