/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.handlers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.registry.extensions.handlers.utils.WsdlUriProcessor;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.extensions.beans.BusinessServiceInfo;
import org.wso2.carbon.registry.extensions.handlers.utils.UDDIPublisher;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class WsdlUriHandler {
    private static final Log log = LogFactory.getLog(WsdlUriHandler.class);
    private boolean createService = true;
    private boolean disableWSDLValidation = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importResource(RequestContext requestContext, String sourceURL) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            WsdlUriProcessor wsdlUriProcessor;
            Resource metadata = requestContext.getResource();
            if (requestContext.getSourceURL() != null && requestContext.getSourceURL().toLowerCase().startsWith("file:")) {
                String msg = "The source URL must not be file in the server's local file system";
                throw new RegistryException(msg);
            }
            try {
                wsdlUriProcessor = this.buildWsdlUriProcessor(requestContext);
                String wsdlPath = this.processWSDLImport(requestContext, wsdlUriProcessor, metadata, sourceURL);
                ResourcePath resourcePath = requestContext.getResourcePath();
                String path = null;
                if (resourcePath != null) {
                    path = resourcePath.getPath();
                }
                this.onPutCompleted(path, Collections.singletonMap(sourceURL, wsdlPath), Collections.<String>emptyList(), requestContext);
                requestContext.setActualPath(wsdlPath);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            requestContext.setProcessingComplete(true);
            if (wsdlUriProcessor != null && "enable".equals(System.getProperty("uddi"))) {
                BusinessServiceInfo businessServiceInfo = new BusinessServiceInfo();
                businessServiceInfo.setServiceWSDLInfo(wsdlUriProcessor.getMasterWSDLInfo());
                UDDIPublisher publisher = new UDDIPublisher(businessServiceInfo);
                publisher.publishBusinessService();
            }
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    protected String processWSDLImport(RequestContext requestContext, WsdlUriProcessor wsdlUriProcessor, Resource metadata, String sourceURL) throws RegistryException {
        return wsdlUriProcessor.addWSDLToRegistry(requestContext, sourceURL, metadata, false, true, this.disableWSDLValidation);
    }

    protected void onPutCompleted(String path, Map<String, String> addedResources, List<String> otherResources, RequestContext requestContext) throws RegistryException {
    }

    protected WsdlUriProcessor buildWsdlUriProcessor(RequestContext requestContext) {
        WsdlUriProcessor wsdlUriProcessor = new WsdlUriProcessor(requestContext);
        wsdlUriProcessor.setCreateService(this.createService);
        return wsdlUriProcessor;
    }

    public void setDisableWSDLValidation(String disableWSDLValidation) {
        this.disableWSDLValidation = Boolean.toString(true).equals(disableWSDLValidation);
    }

    public void setCreateService(String createService) {
        this.createService = Boolean.valueOf(createService);
    }
}

