/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.handlers;

import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.services.ServiceManager;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.registry.extensions.handlers.utils.ResourceProcessor;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.EndpointUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class WadlMediaTypeHandler
extends Handler {
    private static final Log log = LogFactory.getLog(WadlMediaTypeHandler.class);
    private Registry registry;

    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        String originalWadlPath = null;
        try {
            OMElement wadlElement;
            this.registry = requestContext.getRegistry();
            Resource resource = requestContext.getResource();
            originalWadlPath = requestContext.getResourcePath().getPath();
            this.registry.put(originalWadlPath, resource);
            Object resourceContent = resource.getContent();
            String wadlContent = resourceContent instanceof String ? (String)resourceContent : RegistryUtils.decodeBytes((byte[])((byte[])resourceContent));
            try {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(wadlContent));
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                wadlElement = builder.getDocumentElement();
            }
            catch (XMLStreamException e) {
                String msg = "Error in reading the WADL content of the Process. The requested path to store the Process: " + originalWadlPath + ".";
                log.error((Object)msg);
                throw new RegistryException(msg, (Throwable)e);
            }
            String wadlNamespace = wadlElement.getNamespace().getNamespaceURI();
            UserRegistry governanceSystemRegistry = RegistryCoreServiceComponent.getRegistryService().getGovernanceSystemRegistry();
            String wadlName = RegistryUtils.getResourceName((String)requestContext.getResourcePath().getPath());
            GenericArtifactManager genericArtifactManager = new GenericArtifactManager((Registry)governanceSystemRegistry, "wadl");
            GenericArtifact wadlArtifact = genericArtifactManager.newGovernanceArtifact(new QName(wadlName));
            wadlArtifact.addAttribute("overview_name", wadlName);
            wadlArtifact.addAttribute("overview_namespace", wadlNamespace);
            genericArtifactManager.addGenericArtifact(wadlArtifact);
            AXIOMXPath expression = new AXIOMXPath("/ns:application/ns:resources");
            expression.addNamespace("ns", wadlNamespace);
            List elements = expression.selectNodes((Object)wadlElement);
            for (int i = 0; i < elements.size(); ++i) {
                OMElement element = (OMElement)elements.get(i);
                String base = element.getAttributeValue(new QName("base"));
                String endpointPath = this.saveEndpoint(base);
                ServiceManager serviceManager = new ServiceManager((Registry)governanceSystemRegistry);
                Service service = serviceManager.newService(new QName(wadlNamespace, this.getServiceName(base)));
                serviceManager.addService(service);
                String servicePath = "/_system/governance" + GovernanceUtils.getArtifactPath((Registry)governanceSystemRegistry, (String)service.getId());
                this.addDependency(servicePath, endpointPath);
                String wadlPath = "/_system/governance" + GovernanceUtils.getArtifactPath((Registry)governanceSystemRegistry, (String)wadlArtifact.getId());
                this.addDependency(servicePath, wadlPath);
                this.addDependency(wadlPath, endpointPath);
                this.saveResources(element, wadlPath, base);
            }
            requestContext.setProcessingComplete(true);
        }
        catch (JaxenException e) {
            String msg = "Error while parsing the WADL content of " + RegistryUtils.getResourceName(originalWadlPath);
            throw new RegistryException(msg, (Throwable)e);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    private void addDependency(String source, String target) throws RegistryException {
        this.registry.addAssociation(source, target, "depends");
        this.registry.addAssociation(target, source, "usedBy");
    }

    private String getServiceName(String url) {
        if (url.endsWith("/")) {
            return url.replaceAll(".*/(.*)/$", "$1");
        }
        return url.replaceAll(".*/(.*)$", "$1");
    }

    public void saveResources(OMElement resourcesElement, String wadlPath, String basePath) throws JaxenException, RegistryException {
        Iterator resources = resourcesElement.getChildrenWithLocalName("resource");
        ResourceProcessor processor = new ResourceProcessor(this.registry);
        while (resources.hasNext()) {
            String resourcePath = "/_system/governance" + processor.addResource((OMElement)resources.next(), basePath);
            this.addDependency(wadlPath, resourcePath);
        }
    }

    private String saveEndpoint(String url) throws RegistryException {
        String urlToPath = EndpointUtils.deriveEndpointFromUrl((String)url);
        String endpointAbsoluteBasePath = RegistryUtils.getAbsolutePath((RegistryContext)this.registry.getRegistryContext(), (String)"/_system/governance/trunk/endpoints/");
        if (urlToPath.startsWith("/")) {
            urlToPath = urlToPath.replaceFirst("/", "");
        }
        String endpointAbsolutePath = endpointAbsoluteBasePath + urlToPath;
        return this.saveEndpointValues(url, endpointAbsolutePath);
    }

    private String saveEndpointValues(String url, String endpointAbsolutePath) throws RegistryException {
        if (this.registry.resourceExists(endpointAbsolutePath)) {
            Resource resource = this.registry.get(endpointAbsolutePath);
            if (!url.getBytes().equals(resource.getContent())) {
                throw new RegistryException("Failed to add the endpoint: Found another endpoint in the same location with different content");
            }
            return resource.getPath();
        }
        Resource resource = this.registry.newResource();
        resource.setContent((Object)RegistryUtils.encodeString((String)url));
        resource.setMediaType("application/vnd.wso2.endpoint");
        resource.setUUID(UUID.randomUUID().toString());
        return this.registry.put(endpointAbsolutePath, resource);
    }
}

