/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors.utils;

import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);

    public static String formatPath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static void addNewId(Registry registry, Resource newResource, String newPath) throws RegistryException {
        String artifactID = UUID.randomUUID().toString();
        newResource.setUUID(artifactID);
    }

    public static String getResourceContent(Resource tempResource) throws RegistryException {
        if (tempResource.getContent() instanceof String) {
            return (String)tempResource.getContent();
        }
        if (tempResource.getContent() instanceof byte[]) {
            return RegistryUtils.decodeBytes((byte[])((byte[])tempResource.getContent()));
        }
        return null;
    }

    public static OMElement getServiceOMElement(Resource newResource) {
        try {
            String content = Utils.getResourceContent(newResource);
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(content));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement serviceElement = builder.getDocumentElement();
            serviceElement.build();
            return serviceElement;
        }
        catch (Exception e) {
            log.error((Object)"Error in parsing the resource content");
            return null;
        }
    }

    public static boolean populateParameterMap(RequestContext requestContext, Map<String, String> currentParameterMap) {
        Set parameterMapKeySet = (Set)requestContext.getProperty("parameterNames");
        if (parameterMapKeySet == null) {
            log.warn((Object)"No parameters where found");
            return true;
        }
        for (Object entry : parameterMapKeySet) {
            String key = (String)entry;
            if (key.equals("preserveOriginal")) continue;
            currentParameterMap.put(key, (String)requestContext.getProperty(key));
        }
        return true;
    }

    public static void copyAssociations(Registry registry, String newPath, String path) throws RegistryException {
        Association[] associations;
        for (Association association : associations = registry.getAllAssociations(path)) {
            if (association.getAssociationType().equals("depends")) continue;
            if (association.getSourcePath().equals(path)) {
                registry.addAssociation(newPath, association.getDestinationPath(), association.getAssociationType());
                continue;
            }
            registry.addAssociation(association.getSourcePath(), newPath, association.getAssociationType());
        }
    }

    public static void copyRatings(Registry registry, String newPath, String path) throws RegistryException {
        float averageRating = registry.getAverageRating(path);
        registry.rateResource(newPath, new Float(averageRating).intValue());
    }

    public static void copyTags(Registry registry, String newPath, String path) throws RegistryException {
        Tag[] tags;
        for (Tag tag : tags = registry.getTags(path)) {
            registry.applyTag(newPath, tag.getTagName());
        }
    }

    public static void copyComments(Registry registry, String newPath, String path) throws RegistryException {
        Comment[] comments;
        for (Comment comment : comments = registry.getComments(path)) {
            registry.addComment(newPath, comment);
        }
    }
}

