/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.eventing.handlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.CheckListItemCheckedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.CheckListItemUncheckedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.LifeCycleCreatedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.LifeCycleDeletedEvent;
import org.wso2.carbon.governance.registry.eventing.handlers.utils.events.LifeCycleStateChangedEvent;
import org.wso2.carbon.governance.registry.eventing.internal.Utils;
import org.wso2.carbon.registry.common.eventing.RegistryEvent;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class GovernanceEventingHandler
extends Handler {
    private static final Log log = LogFactory.getLog(GovernanceEventingHandler.class);

    public void init(String defaultNotificationEndpoint) {
        Utils.setDefaultNotificationServiceURL(defaultNotificationEndpoint);
    }

    public GovernanceEventingHandler() {
        try {
            Utils.getRegistryNotificationService().registerEventType("checklist.item.checked", "CheckListItemChecked", "CheckListItemChecked");
            Utils.getRegistryNotificationService().registerEventType("checklist.item.unchecked", "CheckListItemUnchecked", "CheckListItemUnchecked");
            Utils.getRegistryNotificationService().registerEventType("lifecycle.state.changed", "LifeCycleStateChanged", "LifeCycleStateChanged");
            Utils.getRegistryNotificationService().registerEventType("lifecycle.deleted", "LifeCycleDeleted", "LifeCycleDeleted");
            Utils.getRegistryNotificationService().registerEventType("lifecycle.created", "LifeCycleCreated", "LifeCycleCreated");
        }
        catch (Exception e) {
            this.handleException("Unable to register Event Types", e);
        }
    }

    public void put(RequestContext requestContext) throws RegistryException {
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        Resource oldResource = requestContext.getOldResource();
        Resource newResource = requestContext.getResource();
        if (oldResource == null || newResource == null || oldResource.getProperties() == null || newResource.getProperties() == null) {
            return;
        }
        Properties props = oldResource.getProperties();
        Properties newProps = newResource.getProperties();
        String lcName = newResource.getProperty("registry.LC.name");
        String oldLcName = oldResource.getProperty("registry.LC.name");
        if (lcName == null && oldLcName != null) {
            LifeCycleDeletedEvent<String> event = new LifeCycleDeletedEvent<String>("[" + oldLcName + "] The LifeCycle was deleted.");
            event.setResourcePath(relativePath);
            event.setParameter("LifecycleName", oldLcName);
            event.setTenantId(CurrentSession.getCallerTenantId());
            try {
                this.notify(event, requestContext.getRegistry(), relativePath);
            }
            catch (Exception e) {
                this.handleException("Unable to send notification for Put Operation", e);
            }
            return;
        }
        if (lcName != null && oldLcName == null) {
            LifeCycleCreatedEvent<String> event = new LifeCycleCreatedEvent<String>("[" + lcName + "] The LifeCycle was created.");
            event.setResourcePath(relativePath);
            event.setParameter("LifecycleName", lcName);
            event.setTenantId(CurrentSession.getCallerTenantId());
            try {
                this.notify(event, requestContext.getRegistry(), relativePath);
            }
            catch (Exception e) {
                this.handleException("Unable to send notification for Put Operation", e);
            }
            return;
        }
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String propKey = (String)e.getKey();
            if (!propKey.matches("registry\\p{Punct}.*\\p{Punct}checklist\\p{Punct}.*")) continue;
            List propValues = (List)e.getValue();
            List newPropValues = (List)newProps.get(propKey);
            if (propValues == null || newPropValues == null || propValues.size() <= 2 || newPropValues.size() <= 2) continue;
            String oldName = null;
            String oldValue = null;
            String oldLifeCycleState = null;
            String newName = null;
            String newValue = null;
            String newLifeCycleState = null;
            for (String param : propValues) {
                if (param.startsWith("status:")) {
                    oldLifeCycleState = param.substring(7);
                    continue;
                }
                if (param.startsWith("name:")) {
                    oldName = param.substring(5);
                    continue;
                }
                if (!param.startsWith("value:")) continue;
                oldValue = param.substring(6);
            }
            for (String param : newPropValues) {
                if (param.startsWith("status:")) {
                    newLifeCycleState = param.substring(7);
                    continue;
                }
                if (param.startsWith("name:")) {
                    newName = param.substring(5);
                    continue;
                }
                if (!param.startsWith("value:")) continue;
                newValue = param.substring(6);
            }
            if (!oldName.equalsIgnoreCase(newName) || !oldLifeCycleState.equalsIgnoreCase(newLifeCycleState) || oldValue.equalsIgnoreCase(newValue)) continue;
            CheckListItemCheckedEvent<String> event = null;
            if (oldValue.equals(Boolean.toString(Boolean.TRUE)) || oldValue.equals(Boolean.toString(Boolean.FALSE))) {
                Object checkedState = null;
                if (oldValue.equals(Boolean.toString(Boolean.TRUE))) {
                    event = new CheckListItemUncheckedEvent<String>("[" + lcName + "] The CheckList item '" + oldName + "' of LifeCycle State '" + oldLifeCycleState + "' was Unchecked.");
                    ((CheckListItemUncheckedEvent)((Object)event)).setResourcePath(relativePath);
                } else {
                    event = new CheckListItemCheckedEvent<String>("[" + lcName + "] The CheckList item '" + oldName + "' of LifeCycle State '" + oldLifeCycleState + "' was Checked.");
                    event.setResourcePath(relativePath);
                }
            } else {
                event = new CheckListItemCheckedEvent<String>("[" + lcName + "] The State of the CheckList item '" + oldName + "' of LifeCycle State '" + oldLifeCycleState + "' was changed.");
                event.setResourcePath(relativePath);
            }
            event.setParameter("LifecycleName", lcName);
            event.setParameter("LifecycleState", oldLifeCycleState);
            event.setParameter("CheckItem", oldName);
            event.setTenantId(CurrentSession.getCallerTenantId());
            try {
                this.notify(event, requestContext.getRegistry(), relativePath);
            }
            catch (Exception ex) {
                this.handleException("Unable to send notification for Put Operation", ex);
            }
        }
    }

    public void invokeAspect(RequestContext requestContext) throws RegistryException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Resource resource = requestContext.getOldResource();
        String oldPath = resource.getPath();
        String stateKey = null;
        Properties props = resource.getProperties();
        String lcName = resource.getProperty("registry.LC.name");
        boolean isEnvironmentChange = false;
        for (Object key : props.keySet()) {
            String propKey = (String)key;
            if (!propKey.matches("registry\\p{Punct}lifecycle\\p{Punct}.*\\p{Punct}state")) continue;
            stateKey = propKey;
            break;
        }
        if (stateKey == null) {
            return;
        }
        String relativeOldPath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)oldPath);
        String oldState = resource.getProperty(stateKey);
        if (requestContext.getAspect() == null || requestContext.getAction() == null) {
            return;
        }
        if (!requestContext.isProcessingComplete()) {
            Object parameterNames = requestContext.getProperty("parameterNames");
            if (parameterNames != null) {
                for (String key : (Set)parameterNames) {
                    parameters.put(key, (String)requestContext.getProperty(key));
                }
                requestContext.getAspect().invoke(requestContext, requestContext.getAction(), parameters);
            } else {
                requestContext.getAspect().invoke(requestContext, requestContext.getAction());
            }
            requestContext.setProcessingComplete(true);
        }
        String path = requestContext.getResourcePath().getPath();
        String relativePath = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)path);
        resource = requestContext.getRegistry().get(path);
        if (resource.getProperty("registry.is.environment.change.property") != null && !resource.getProperty("registry.is.environment.change.property").isEmpty()) {
            isEnvironmentChange = Boolean.parseBoolean(resource.getProperty("registry.is.environment.change.property"));
            resource.removeProperty("registry.is.environment.change.property");
            requestContext.setResource(resource);
            requestContext.getRegistry().put(path, resource);
        }
        if (resource == null) {
            return;
        }
        String newState = resource.getProperty(stateKey);
        if (oldState != null && oldState.equalsIgnoreCase(newState)) {
            return;
        }
        String extendedMessage = "";
        if (!oldPath.equals(path)) {
            extendedMessage = resource instanceof Collection ? " The collection has moved from: '" + relativeOldPath + "' to: '" + relativePath + "'." : " The resource has moved from: '" + relativeOldPath + "' to: '" + relativePath + "'.";
        }
        LifeCycleStateChangedEvent<String> event = new LifeCycleStateChangedEvent<String>("[" + lcName + "] The LifeCycle State Changed from '" + oldState + "' to '" + newState + "'." + extendedMessage);
        event.setParameter("LifecycleName", lcName);
        event.setParameter("OldLifecycleState", oldState);
        event.setParameter("NewLifecycleState", newState);
        if (isEnvironmentChange) {
            event.setResourcePath(relativeOldPath);
        } else {
            event.setResourcePath(relativePath);
        }
        event.setTenantId(CurrentSession.getCallerTenantId());
        try {
            this.notify(event, requestContext.getRegistry(), relativePath);
        }
        catch (Exception e) {
            this.handleException("Unable to send notification for Aspect Invoke Operation", e);
        }
    }

    protected void notify(RegistryEvent event, Registry registry, String path) throws Exception {
        try {
            if (Utils.getRegistryNotificationService() == null) {
                log.debug((Object)"Eventing service is unavailable.");
                return;
            }
            if (registry == null || registry.getEventingServiceURL(path) == null) {
                Utils.getRegistryNotificationService().notify(event);
                return;
            }
            if (Utils.getDefaultNotificationServiceURL() != null) {
                if (registry.getEventingServiceURL(path).equals(Utils.getDefaultNotificationServiceURL())) {
                    Utils.getRegistryNotificationService().notify(event);
                    return;
                }
                Utils.getRegistryNotificationService().notify(event, registry.getEventingServiceURL(path));
                return;
            }
            log.error((Object)"Governance Eventing Handler is not properly initialized");
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to send notification", (Throwable)e);
        }
        log.error((Object)"Unable to send notification");
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
    }
}

