/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.platform.extensions.handlers;

import java.util.LinkedList;
import java.util.Map;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class ExcludeServicesByStateFromListHandler
extends Handler {
    private String stateName;
    private String lifecycleName;

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public void setLifecycleName(String lifecycleName) {
        this.lifecycleName = lifecycleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection executeQuery(RequestContext requestContext) throws RegistryException {
        if (CommonUtil.isUpdateLockAvailable()) {
            CommonUtil.acquireUpdateLock();
            try {
                Map queryParameters = requestContext.getQueryParameters();
                if (queryParameters != null && queryParameters.values().contains("application/vnd.wso2-service+xml")) {
                    String resourcePath = null;
                    if (requestContext.getResourcePath() != null) {
                        resourcePath = requestContext.getResourcePath().getPath();
                    }
                    Registry registry = requestContext.getRegistry();
                    Collection collection = registry.executeQuery(resourcePath, queryParameters);
                    LinkedList<String> fixedPaths = new LinkedList<String>();
                    for (String path : collection.getChildren()) {
                        try {
                            if (this.stateName.equals(registry.get(path).getProperty("registry.lifecycle." + this.lifecycleName + ".state"))) continue;
                            fixedPaths.add(path);
                        }
                        catch (RegistryException ignored) {
                            // empty catch block
                        }
                    }
                    collection.setChildren(fixedPaths.toArray(new String[fixedPaths.size()]));
                    requestContext.setProcessingComplete(true);
                    Collection collection2 = collection;
                    return collection2;
                }
            }
            finally {
                CommonUtil.releaseUpdateLock();
            }
        }
        return null;
    }
}

