/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.platform.extensions.handlers;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.services.ServiceFilter;
import org.wso2.carbon.governance.api.services.ServiceManager;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.extensions.handlers.ZipWSDLMediaTypeHandler;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.user.core.UserRealm;

public class RESTZipWSDLMediaTypeHandler
extends ZipWSDLMediaTypeHandler {
    private String wsdlExtension = ".wsdl";
    private String xsdExtension = ".xsd";
    private String restExtension = ".cxf";
    private String archiveExtension = ".gar";
    private String tempFilePrefix = "wsdl";
    private int threadPoolSize = 50;
    private static final Log log = LogFactory.getLog(RESTZipWSDLMediaTypeHandler.class);

    public void setWsdlExtension(String wsdlExtension) {
        this.wsdlExtension = wsdlExtension;
        super.setWsdlExtension(wsdlExtension);
    }

    public void setSchemaExtension(String xsdExtension) {
        this.xsdExtension = xsdExtension;
        super.setSchemaExtension(xsdExtension);
    }

    public void setArchiveExtension(String archiveExtension) {
        this.archiveExtension = archiveExtension;
        super.setArchiveExtension(archiveExtension);
    }

    public void setTempFilePrefix(String tempFilePrefix) {
        this.tempFilePrefix = tempFilePrefix;
        super.setTempFilePrefix(tempFilePrefix);
    }

    public void setThreadPoolSize(String threadPoolSize) {
        this.threadPoolSize = Integer.parseInt(threadPoolSize);
        super.setThreadPoolSize(threadPoolSize);
    }

    public void setRestExtension(String restExtension) {
        this.restExtension = restExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            block45: {
                Resource resource = requestContext.getResource();
                String path = requestContext.getResourcePath().getPath();
                try {
                    if (resource == null) break block45;
                    Object resourceContent = resource.getContent();
                    ByteArrayInputStream in = new ByteArrayInputStream((byte[])resourceContent);
                    Stack<File> fileList = new Stack<File>();
                    LinkedList<String> uriList = new LinkedList<String>();
                    LinkedList<Object> tasks = new LinkedList<Object>();
                    int threadPoolSize = this.threadPoolSize;
                    int wsdlPathDepth = Integer.MAX_VALUE;
                    int xsdPathDepth = Integer.MAX_VALUE;
                    File tempFile = File.createTempFile(this.tempFilePrefix, this.archiveExtension);
                    File tempDir = new File(tempFile.getAbsolutePath().substring(0, tempFile.getAbsolutePath().length() - this.archiveExtension.length()));
                    try {
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
                        try {
                            int byteCount;
                            byte[] contentChunk = new byte[1024];
                            while ((byteCount = in.read(contentChunk)) != -1) {
                                out.write(contentChunk, 0, byteCount);
                            }
                            out.flush();
                        }
                        finally {
                            out.close();
                        }
                        this.makeDir(tempDir);
                        LinkedList<String> wsdlUriList = new LinkedList<String>();
                        LinkedList<String> xsdUriList = new LinkedList<String>();
                        ZipInputStream zs = new ZipInputStream(new FileInputStream(tempFile));
                        try {
                            ZipEntry entry = zs.getNextEntry();
                            while (entry != null) {
                                int uriPathDepth;
                                String uri;
                                String entryName = entry.getName();
                                File file = new File(tempFile.getAbsolutePath().substring(0, tempFile.getAbsolutePath().length() - this.archiveExtension.length()) + File.separator + entryName);
                                if (entry.isDirectory()) {
                                    if (!file.exists()) {
                                        this.makeDirs(file);
                                        fileList.push(file);
                                    }
                                    entry = zs.getNextEntry();
                                    continue;
                                }
                                File parentFile = file.getParentFile();
                                if (!parentFile.exists()) {
                                    this.makeDirs(parentFile);
                                }
                                FileOutputStream os = new FileOutputStream(file);
                                try {
                                    int byteCount;
                                    fileList.push(file);
                                    byte[] contentChunk = new byte[1024];
                                    while ((byteCount = zs.read(contentChunk)) != -1) {
                                        os.write(contentChunk, 0, byteCount);
                                    }
                                }
                                finally {
                                    os.close();
                                }
                                zs.closeEntry();
                                entry = zs.getNextEntry();
                                if (entryName != null && entryName.toLowerCase().endsWith(this.wsdlExtension)) {
                                    uri = tempFile.toURI().toString();
                                    if ((uri = uri.substring(0, uri.length() - this.archiveExtension.length()) + "/" + entryName).startsWith("file:")) {
                                        uri = uri.substring(5);
                                    }
                                    while (uri.startsWith("/")) {
                                        uri = uri.substring(1);
                                    }
                                    uri = "file:///" + uri;
                                    if (uri.endsWith("/")) {
                                        uri = uri.substring(0, uri.length() - 1);
                                    }
                                    if ((uriPathDepth = uri.split("/").length) < wsdlPathDepth) {
                                        wsdlPathDepth = uriPathDepth;
                                        wsdlUriList = new LinkedList();
                                    }
                                    if (wsdlPathDepth != uriPathDepth) continue;
                                    wsdlUriList.add(uri);
                                    continue;
                                }
                                if (entryName != null && entryName.toLowerCase().endsWith(this.xsdExtension)) {
                                    uri = tempFile.toURI().toString();
                                    if ((uri = uri.substring(0, uri.length() - this.archiveExtension.length()) + "/" + entryName).startsWith("file:")) {
                                        uri = uri.substring(5);
                                    }
                                    while (uri.startsWith("/")) {
                                        uri = uri.substring(1);
                                    }
                                    uri = "file:///" + uri;
                                    if (uri.endsWith("/")) {
                                        uri = uri.substring(0, uri.length() - 1);
                                    }
                                    if ((uriPathDepth = uri.split("/").length) < xsdPathDepth) {
                                        xsdPathDepth = uriPathDepth;
                                        xsdUriList = new LinkedList();
                                    }
                                    if (xsdPathDepth != uriPathDepth) continue;
                                    xsdUriList.add(uri);
                                    continue;
                                }
                                if (entryName == null) continue;
                                uri = tempFile.toURI().toString();
                                if ((uri = uri.substring(0, uri.length() - this.archiveExtension.length()) + "/" + entryName).startsWith("file:")) {
                                    uri = uri.substring(5);
                                }
                                while (uri.startsWith("/")) {
                                    uri = uri.substring(1);
                                }
                                uri = "file:///" + uri;
                                if (uri.endsWith("/")) {
                                    uri = uri.substring(0, uri.length() - 1);
                                }
                                uriList.add(uri);
                            }
                        }
                        finally {
                            zs.close();
                        }
                        Map<String, String> localPathMap = null;
                        if (CurrentSession.getLocalPathMap() != null) {
                            localPathMap = Collections.unmodifiableMap(CurrentSession.getLocalPathMap());
                        }
                        if (wsdlUriList.isEmpty() && xsdUriList.isEmpty()) {
                            throw new RegistryException("No WSDLs or Schemas found in the given WSDL archive");
                        }
                        if (wsdlPathDepth < Integer.MAX_VALUE) {
                            for (String uri : wsdlUriList) {
                                tasks.add(new ZipWSDLMediaTypeHandler.UploadWSDLTask((ZipWSDLMediaTypeHandler)this, requestContext, uri, CurrentSession.getTenantId(), CurrentSession.getUserRegistry(), CurrentSession.getUserRealm(), CurrentSession.getUser(), CurrentSession.getCallerTenantId(), localPathMap));
                            }
                        }
                        if (xsdPathDepth < Integer.MAX_VALUE) {
                            for (String uri : xsdUriList) {
                                tasks.add(new ZipWSDLMediaTypeHandler.UploadXSDTask((ZipWSDLMediaTypeHandler)this, requestContext, uri, CurrentSession.getTenantId(), CurrentSession.getUserRegistry(), CurrentSession.getUserRealm(), CurrentSession.getUser(), CurrentSession.getCallerTenantId(), localPathMap));
                            }
                        }
                        for (String uri : uriList) {
                            if (!uri.endsWith(this.restExtension)) continue;
                            tasks.add((Object)new UploadRESTModelTask(requestContext, uri, CurrentSession.getTenantId(), CurrentSession.getUserRegistry(), CurrentSession.getUserRealm(), CurrentSession.getUser(), CurrentSession.getCallerTenantId(), localPathMap));
                        }
                        int toAdd = wsdlUriList.size() + xsdUriList.size();
                        if (toAdd < threadPoolSize) {
                            threadPoolSize = toAdd < threadPoolSize / 8 ? 0 : (toAdd < threadPoolSize / 2 ? (threadPoolSize /= 8) : (threadPoolSize /= 4));
                        }
                    }
                    finally {
                        ((InputStream)in).close();
                        resourceContent = null;
                        resource.setContent(null);
                    }
                    this.uploadFiles(tasks, tempFile, fileList, tempDir, threadPoolSize, path, uriList, requestContext);
                }
                catch (IOException e) {
                    throw new RegistryException("Error occurred while unpacking Governance Archive", (Throwable)e);
                }
            }
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    protected class UploadRESTModelTask
    extends ZipWSDLMediaTypeHandler.UploadTask {
        public UploadRESTModelTask(RequestContext requestContext, String uri, int tenantId, UserRegistry userRegistry, UserRealm userRealm, String userId, int callerTenantId, Map<String, String> localPathMap) {
            super(requestContext, uri, tenantId, userRegistry, userRealm, userId, callerTenantId, localPathMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doProcessing(RequestContext requestContext, String uri) throws RegistryException {
            UserRegistry governanceSystemRegistry = RegistryCoreServiceComponent.getRegistryService().getGovernanceSystemRegistry();
            ServiceManager manager = new ServiceManager((Registry)governanceSystemRegistry);
            try {
                FileInputStream stream = new FileInputStream(new File(uri.substring("file:///".length() - 1)));
                try {
                    OMElement payload = new StAXOMBuilder((InputStream)stream).getDocumentElement();
                    AXIOMXPath xpath = new AXIOMXPath("//ns:resource/@name");
                    String namespace = payload.getNamespace().getNamespaceURI();
                    xpath.addNamespace("ns", namespace);
                    List services = (List)xpath.evaluate((Object)payload);
                    for (OMAttribute service : services) {
                        String serviceName = service.getAttributeValue();
                        final Service restService = manager.newService(new QName(namespace, serviceName));
                        AXIOMXPath xpath2 = new AXIOMXPath("//ns:resource[@name = \"" + serviceName + "\"]/ns:operation/@name");
                        xpath2.addNamespace("ns", namespace);
                        List operations = (List)xpath2.evaluate((Object)payload);
                        for (OMAttribute operation : operations) {
                            restService.addAttribute("endpoints_entry", ":/" + serviceName + "/" + operation.getAttributeValue());
                        }
                        restService.setAttribute("overview_version", "1.0.0-SNAPSHOT");
                        boolean updateLockAvailable = CommonUtil.isUpdateLockAvailable();
                        if (!updateLockAvailable) {
                            CommonUtil.releaseUpdateLock();
                        }
                        try {
                            Service[] existingServices = manager.findServices(new ServiceFilter(){

                                public boolean matches(Service service) throws GovernanceException {
                                    return service.getQName().getLocalPart().equals(restService.getQName().getLocalPart()) && service.getQName().getNamespaceURI().equals(restService.getQName().getNamespaceURI());
                                }
                            });
                            if (existingServices != null && existingServices.length > 0) continue;
                            manager.addService(restService);
                        }
                        finally {
                            if (updateLockAvailable) continue;
                            CommonUtil.acquireUpdateLock();
                        }
                    }
                }
                finally {
                    ((InputStream)stream).close();
                }
            }
            catch (JaxenException e) {
                log.error((Object)"An error occurred while performing XPath evaluation", (Throwable)e);
            }
            catch (XMLStreamException e) {
                log.error((Object)"Unable to parse file contents", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Error occurred while reading file", (Throwable)e);
            }
        }
    }
}

