/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.platform.extensions.handlers;

import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.services.ServiceFilter;
import org.wso2.carbon.governance.api.services.ServiceManager;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.platform.extensions.util.Utils;
import org.wso2.carbon.registry.app.RemoteRegistry;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class PolicyEnforcementHandler
extends Handler {
    private static final Log log = LogFactory.getLog(PolicyEnforcementHandler.class);
    private String sequencePath = null;
    private String registryURL = "https://localhost:9443/registry";
    private String username = null;
    private String password = null;
    private String enforcedPoliciesParameter = "security_enforcedPolicies";
    private String associationType = "depends";
    private String xacmlPolicyKey = "registry.xacml.policy";

    public void setXacmlPolicyKey(String xacmlPolicyKey) {
        this.xacmlPolicyKey = xacmlPolicyKey;
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public void setRegistryURL(String registryURL) {
        this.registryURL = registryURL;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEnforcedPoliciesParameter(String enforcedPoliciesParameter) {
        this.enforcedPoliciesParameter = enforcedPoliciesParameter;
    }

    public void setSequencePath(String sequencePath) {
        this.sequencePath = sequencePath;
    }

    public void put(RequestContext requestContext) throws RegistryException {
        Service[] services;
        RemoteRegistry registry;
        if (this.username == null || this.password == null) {
            throw new RegistryException("This handler configuration requires that you specify the username and password.");
        }
        if (this.sequencePath == null) {
            throw new RegistryException("The sequence path has not been defined");
        }
        OMElement proxyContent = Utils.extractPayload(requestContext.getResource());
        OMNamespace namespace = proxyContent.getNamespace();
        String namespaceURI = namespace.getNamespaceURI();
        OMElement target = proxyContent.getFirstChildWithName(new QName(namespaceURI, "target"));
        OMElement inSequence = target.getFirstChildWithName(new QName(namespaceURI, "inSequence"));
        Iterator sequenceIterator = inSequence.getChildrenWithName(new QName(namespaceURI, "sequence"));
        boolean hasEntitlementPolicies = false;
        while (sequenceIterator.hasNext()) {
            String sequenceNSURI;
            Resource resource;
            OMElement sequenceContent;
            OMElement sequence = (OMElement)sequenceIterator.next();
            String key = sequence.getAttributeValue(new QName("key"));
            Registry registry2 = requestContext.getRegistry();
            String location = this.sequencePath + "/" + key;
            if (key == null || !registry2.resourceExists(location) || (sequenceContent = Utils.extractPayload(resource = registry2.get(location))).getFirstChildWithName(new QName(sequenceNSURI = sequenceContent.getNamespace().getNamespaceURI(), "entitlementService")) == null) continue;
            hasEntitlementPolicies = true;
            break;
        }
        final String serviceName = proxyContent.getAttributeValue(new QName("name"));
        Iterator parameters = proxyContent.getChildrenWithName(new QName(namespaceURI, "parameter"));
        LinkedList<String> policyNames = new LinkedList<String>();
        while (parameters.hasNext()) {
            OMElement parameter = (OMElement)parameters.next();
            if (!parameter.getAttributeValue(new QName("name")).equals("secPolicyRegistryPath")) continue;
            String[] split = parameter.getText().split(":");
            String policyName = RegistryUtils.getResourceName((String)split[split.length - 1]);
            policyNames.add(policyName);
        }
        try {
            registry = new RemoteRegistry(this.registryURL, this.username, this.password);
        }
        catch (MalformedURLException e) {
            String msg = "Unable to create connection to remote registry server";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        Registry governanceRegistry = GovernanceUtils.getGovernanceUserRegistry((Registry)registry, (String)this.username);
        ServiceManager manager = new ServiceManager(governanceRegistry);
        for (Service service : services = manager.findServices(new ServiceFilter(){

            public boolean matches(Service service) throws GovernanceException {
                return service.getQName().getLocalPart().equals(serviceName);
            }
        })) {
            Association[] dependencies;
            String path = service.getPath();
            String enforcedPolicies = "";
            StringBuilder enforcedPoliciesBuilder = new StringBuilder();
            for (Association dependency : dependencies = governanceRegistry.getAssociations(path, this.associationType)) {
                if (!dependency.getSourcePath().equals(path)) continue;
                String destinationPath = dependency.getDestinationPath();
                String destinationName = RegistryUtils.getResourceName((String)destinationPath);
                boolean doContinue = false;
                for (String policyName : policyNames) {
                    if (!destinationName.equals(policyName)) continue;
                    enforcedPoliciesBuilder.append(destinationName).append(";");
                    doContinue = true;
                }
                if (doContinue || !hasEntitlementPolicies || !Boolean.toString(true).equals(governanceRegistry.get(destinationPath).getProperty(this.xacmlPolicyKey))) continue;
                enforcedPoliciesBuilder.append(destinationName).append(";");
            }
            enforcedPolicies = enforcedPoliciesBuilder.toString();
            if (enforcedPolicies.length() <= 0) continue;
            service.setAttribute(this.enforcedPoliciesParameter, enforcedPolicies.substring(0, enforcedPolicies.length() - 1));
            manager.updateService(service);
        }
    }
}

