/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.platform.extensions.handlers;

import java.util.Properties;
import java.util.regex.Pattern;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class InheritLifecycleFromParentHandler
extends Handler {
    private static final Pattern REGISTRY_LC_PROPERTY_REG_EX = Pattern.compile("^registry[.]([d]?lc[m]?|.*lifecycle|aspects).*$");
    private String basePath = "/";

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void put(RequestContext requestContext) throws RegistryException {
        String parentPath = requestContext.getResourcePath().getPath();
        Registry registry = requestContext.getRegistry();
        Resource parent = null;
        while (!parentPath.equals(this.basePath)) {
            if (registry.resourceExists(parentPath = RegistryUtils.getParentPath((String)parentPath))) {
                parent = registry.get(parentPath);
                break;
            }
            registry.put(parentPath, (Resource)registry.newCollection());
        }
        if (parent != null) {
            Resource resource = requestContext.getResource();
            Properties properties = parent.getProperties();
            for (Object key : properties.keySet()) {
                String keyStr = (String)key;
                if (!REGISTRY_LC_PROPERTY_REG_EX.matcher(keyStr.toLowerCase()).matches()) continue;
                resource.setProperty(keyStr, parent.getPropertyValues(keyStr));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String copy(RequestContext requestContext) throws RegistryException {
        String output = null;
        if (!CommonUtil.isUpdateLockAvailable()) {
            return output;
        }
        CommonUtil.acquireUpdateLock();
        try {
            String sourcePath = requestContext.getSourcePath();
            String targetPath = requestContext.getTargetPath();
            Registry registry = requestContext.getRegistry();
            output = registry.copy(sourcePath, targetPath);
            this.recursivePut(registry, targetPath);
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String move(RequestContext requestContext) throws RegistryException {
        String output = null;
        if (!CommonUtil.isUpdateLockAvailable()) {
            return output;
        }
        CommonUtil.acquireUpdateLock();
        try {
            String sourcePath = requestContext.getSourcePath();
            String targetPath = requestContext.getTargetPath();
            Registry registry = requestContext.getRegistry();
            output = registry.move(sourcePath, targetPath);
            this.recursivePut(registry, targetPath);
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
        return output;
    }

    public void recursivePut(Registry registry, String path) throws RegistryException {
        Collection collection;
        String[] children;
        if (!registry.resourceExists(path)) {
            return;
        }
        Resource resource = registry.get(path);
        registry.put(path, resource);
        if (resource instanceof Collection && (children = (collection = (Collection)resource).getChildren()) != null) {
            for (String child : children) {
                this.recursivePut(registry, child);
            }
        }
    }
}

