/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.platform.extensions.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.governance.platform.extensions.util.Utils;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class ExtractRelationshipsFromXMLHandler
extends Handler {
    private static final Log log = LogFactory.getLog(ExtractRelationshipsFromXMLHandler.class);
    private static final String CONFIG_REGISTRY_PREFIX = "conf";
    private static final String GOVERNANCE_REGISTRY_PREFIX = "gov";
    private List<Relationship> relationshipList = new LinkedList<Relationship>();
    private Set<String> types = new HashSet<String>();
    private boolean testExistence = true;

    public void setTestExistence(String testExistence) {
        this.testExistence = Boolean.toString(true).equals(testExistence);
    }

    public void setConfiguration(OMElement configuration) {
        Iterator relationships = configuration.getChildrenWithName(new QName("relationship"));
        while (relationships.hasNext()) {
            OMElement element = (OMElement)relationships.next();
            String type = element.getAttributeValue(new QName("type"));
            if (type == null) {
                type = "depends";
            }
            this.types.add(type);
            String[] xpath = element.getAttributeValue(new QName("xpath")).split(",");
            LinkedList<QName> namespaceList = new LinkedList<QName>();
            Iterator namespaces = element.getChildrenWithName(new QName("namespace"));
            while (namespaces.hasNext()) {
                OMElement namespace = (OMElement)namespaces.next();
                namespaceList.add(new QName(namespace.getAttributeValue(new QName("uri")), "dummy", namespace.getAttributeValue(new QName("prefix"))));
            }
            LinkedList<AXIOMXPath> xpathList = new LinkedList<AXIOMXPath>();
            if (xpath != null) {
                for (String temp : xpath) {
                    if ((temp = temp.trim()).endsWith("/")) {
                        temp = temp.substring(0, temp.length() - 1);
                    }
                    try {
                        AXIOMXPath expression = new AXIOMXPath(temp);
                        for (QName namespace : namespaceList) {
                            expression.addNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                        }
                        xpathList.add(expression);
                    }
                    catch (JaxenException e) {
                        log.error((Object)"Unable to compile xpath for expression", (Throwable)e);
                    }
                }
            }
            String[] destination = element.getAttributeValue(new QName("destination")).split(",");
            LinkedList<String> destinationList = new LinkedList<String>();
            if (destination != null) {
                for (String temp : destination) {
                    destinationList.add(temp.trim());
                }
            }
            this.relationshipList.add(new Relationship(xpathList.toArray(new AXIOMXPath[xpathList.size()]), destinationList.toArray(new String[destinationList.size()]), type));
        }
    }

    public void put(RequestContext requestContext) throws RegistryException {
        String source = requestContext.getResourcePath().getPath();
        Registry registry = requestContext.getRegistry();
        Association[] associations = registry.getAllAssociations(source);
        if (associations != null) {
            for (Association association : associations) {
                String sourcePath = association.getSourcePath();
                String destinationPath = association.getDestinationPath();
                String associationType = association.getAssociationType();
                if (!sourcePath.equals(source) || !this.types.contains(associationType)) continue;
                registry.removeAssociation(sourcePath, destinationPath, associationType);
            }
        }
        OMElement content = Utils.extractPayload(requestContext.getResource());
        for (Relationship relationship : this.relationshipList) {
            LinkedList<String> destinations = new LinkedList<String>();
            for (AXIOMXPath xpath : relationship.getXpathExpressions()) {
                try {
                    Object results = xpath.evaluate((Object)content);
                    if (results == null) continue;
                    for (Object result : (ArrayList)results) {
                        if (result instanceof OMAttribute) {
                            destinations.add(((OMAttribute)result).getAttributeValue());
                            continue;
                        }
                        if (!(result instanceof OMElement)) continue;
                        destinations.add(((OMElement)result).getText());
                    }
                }
                catch (JaxenException ignored) {
                }
                catch (ClassCastException ignored) {
                }
            }
            if (destinations.size() <= 0) continue;
            LinkedList<String> paths = new LinkedList<String>();
            for (String parent : relationship.getDestinations()) {
                for (String child : destinations) {
                    paths.add(this.computePath(parent, child));
                }
            }
            String type = relationship.getType();
            for (String target : paths) {
                if (this.testExistence && !registry.resourceExists(target)) continue;
                registry.addAssociation(source, target, type);
            }
        }
    }

    private String computePath(String parent, String child) {
        if (child.indexOf(":") > 0) {
            String[] temp = child.split(":");
            if (CONFIG_REGISTRY_PREFIX.equals(temp[0])) {
                parent = "/_system/config";
            } else if (GOVERNANCE_REGISTRY_PREFIX.equals(temp[0])) {
                parent = "/_system/governance";
            }
            return parent + temp[1];
        }
        return parent + "/" + child;
    }

    private static class Relationship {
        private AXIOMXPath[] xpathExpressions;
        private String[] destinations;
        private String type;

        private Relationship(AXIOMXPath[] xpathExpressions, String[] destinations, String type) {
            this.xpathExpressions = xpathExpressions;
            this.destinations = destinations;
            this.type = type;
        }

        public List<AXIOMXPath> getXpathExpressions() {
            return Arrays.asList(this.xpathExpressions);
        }

        public List<String> getDestinations() {
            return Arrays.asList(this.destinations);
        }

        public String getType() {
            return this.type;
        }
    }
}

