/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.notifications.ui.worklist;

import java.rmi.RemoteException;
import java.util.LinkedList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.databinding.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.notifications.ui.worklist.WorkItem;
import org.wso2.carbon.governance.notifications.worklist.stub.WorkListServiceStub;
import org.wso2.carbon.humantask.stub.ui.task.client.api.HumanTaskClientAPIAdminStub;
import org.wso2.carbon.humantask.stub.ui.task.client.api.IllegalAccessFault;
import org.wso2.carbon.humantask.stub.ui.task.client.api.IllegalArgumentFault;
import org.wso2.carbon.humantask.stub.ui.task.client.api.IllegalOperationFault;
import org.wso2.carbon.humantask.stub.ui.task.client.api.IllegalStateFault;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TSimpleQueryCategory;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TSimpleQueryInput;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskSimpleQueryResultRow;
import org.wso2.carbon.humantask.stub.ui.task.client.api.types.TTaskSimpleQueryResultSet;
import org.wso2.carbon.registry.common.eventing.WorkListConfig;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.user.mgt.stub.GetAllRolesNamesUserAdminExceptionException;
import org.wso2.carbon.user.mgt.stub.GetRolesOfCurrentUserUserAdminExceptionException;
import org.wso2.carbon.user.mgt.stub.GetUserStoreInfoUserAdminExceptionException;
import org.wso2.carbon.user.mgt.stub.UserAdminStub;
import org.wso2.carbon.user.mgt.stub.types.carbon.FlaggedName;
import org.wso2.carbon.utils.CarbonUtils;

public class HumanTaskClient {
    private static final Log log = LogFactory.getLog(HumanTaskClient.class);
    private HumanTaskClientAPIAdminStub htStub;
    private UserAdminStub umStub;
    private WorkListServiceStub wlStub;
    private static WorkListConfig workListConfig = new WorkListConfig();

    public HumanTaskClient(ServletConfig config, HttpSession session) throws AxisFault {
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String backendServerURL = workListConfig.getServerURL() != null ? workListConfig.getServerURL() : CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        this.htStub = new HumanTaskClientAPIAdminStub(configContext, backendServerURL + "HumanTaskClientAPIAdmin");
        this.configureServiceClient((Stub)this.htStub, session);
        this.umStub = new UserAdminStub(configContext, backendServerURL + "UserAdmin");
        this.configureServiceClient((Stub)this.umStub, session);
        this.wlStub = new WorkListServiceStub(configContext, backendServerURL + "WorkListService");
        this.configureServiceClient((Stub)this.wlStub, session);
    }

    private void configureServiceClient(Stub stub, HttpSession session) {
        ServiceClient client = stub._getServiceClient();
        Options options = client.getOptions();
        if (workListConfig.getUsername() != null && workListConfig.getPassword() != null) {
            CarbonUtils.setBasicAccessSecurityHeaders((String)workListConfig.getUsername(), (String)workListConfig.getPassword(), (ServiceClient)client);
        } else {
            options.setProperty("Cookie", session.getAttribute("wso2carbon.admin.service.cookie"));
        }
        options.setManageSession(true);
    }

    public WorkItem[] getWorkItems(HttpServletRequest request) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault, RemoteException {
        if (!CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)"/permission/admin/manage/resources/notifications")) {
            return new WorkItem[0];
        }
        TSimpleQueryInput queryInput = new TSimpleQueryInput();
        queryInput.setPageNumber(0);
        queryInput.setSimpleQueryCategory(TSimpleQueryCategory.ASSIGNED_TO_ME);
        TTaskSimpleQueryResultSet resultSet = this.htStub.simpleQuery(queryInput);
        if (resultSet == null || resultSet.getRow() == null || resultSet.getRow().length == 0) {
            return new WorkItem[0];
        }
        LinkedList<WorkItem> workItems = new LinkedList<WorkItem>();
        for (TTaskSimpleQueryResultRow row : resultSet.getRow()) {
            URI id = row.getId();
            workItems.add(new WorkItem(id, row.getPresentationSubject(), row.getPresentationName(), row.getPriority(), row.getStatus(), row.getCreatedTime(), this.htStub.loadTask(id).getActualOwner().getTUser()));
        }
        return workItems.toArray(new WorkItem[workItems.size()]);
    }

    public String[] getRoles(HttpSession session) throws RemoteException, GetAllRolesNamesUserAdminExceptionException, GetUserStoreInfoUserAdminExceptionException, GetRolesOfCurrentUserUserAdminExceptionException {
        FlaggedName[] allRolesNames = this.umStub.getRolesOfCurrentUser();
        String adminRole = this.umStub.getUserStoreInfo().getAdminRole();
        for (FlaggedName role : allRolesNames) {
            String name = role.getItemName();
            if (!name.equals(adminRole)) continue;
            allRolesNames = this.umStub.getAllRolesNames();
            break;
        }
        String everyOneRole = this.umStub.getUserStoreInfo().getEveryOneRole();
        LinkedList<String> roles = new LinkedList<String>();
        for (FlaggedName role : allRolesNames) {
            String name = role.getItemName();
            if (name.equals("wso2.anonymous.role") || name.equals(everyOneRole)) continue;
            roles.add(name);
        }
        return roles.toArray(new String[roles.size()]);
    }

    public void createTask(String role, String description, String priority) throws RemoteException {
        this.wlStub.addTask(role, description, Integer.parseInt(priority));
    }

    public void completeTask(String id) throws RemoteException, IllegalArgumentFault, IllegalOperationFault, IllegalAccessFault, IllegalStateFault {
        try {
            this.htStub.complete(new URI(id), "<WorkResponse>true</WorkResponse>");
        }
        catch (URI.MalformedURIException e) {
            log.error((Object)"Invalid task identifier", (Throwable)e);
        }
    }
}

