/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.generic.stub.ManageGenericArtifactServiceStub;
import org.wso2.carbon.governance.generic.stub.beans.xsd.ArtifactsBean;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ManageGenericArtifactServiceClient {
    private static final Log log = LogFactory.getLog(ManageGenericArtifactServiceClient.class);
    private ManageGenericArtifactServiceStub stub;
    private String epr;

    public ManageGenericArtifactServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "ManageGenericArtifactService";
        try {
            this.stub = new ManageGenericArtifactServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate ManageGenericArtifactServiceClient. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ManageGenericArtifactServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "ManageGenericArtifactService";
        try {
            this.stub = new ManageGenericArtifactServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate ManageGenericArtifactServiceClient. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public String addArtifact(String key, String path, String lifecycleAttribute) throws Exception {
        return this.stub.addArtifact(key, path, lifecycleAttribute);
    }

    public String editArtifact(String key, String path, String lifecycleAttribute) throws Exception {
        return this.stub.editArtifact(key, path, lifecycleAttribute);
    }

    public ArtifactsBean listArtifacts(String key, String criteria) throws Exception {
        return this.stub.listArtifacts(key, criteria);
    }

    public String getArtifactContent(String path) throws Exception {
        return this.stub.getArtifactContent(path);
    }

    public String getArtifactUIConfiguration(String key) throws Exception {
        return this.stub.getArtifactUIConfiguration(key);
    }

    public boolean setArtifactUIConfiguration(String key, String content) throws Exception {
        return this.stub.setArtifactUIConfiguration(key, content);
    }

    public boolean canChange(String path) throws Exception {
        return this.stub.canChange(path);
    }
}

