/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.wsdl.ui;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.wso2.carbon.registry.common.ui.utils.TreeNode;
import org.wso2.carbon.registry.common.ui.utils.TreeNodeBuilderUtil;
import org.wso2.carbon.registry.common.ui.utils.UIUtil;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class TreeNodeBuilder {
    private OMElement wsdlElement;
    private String wsdlPath;
    private String actualWsdlPath;

    public TreeNodeBuilder(String wsdlPath, String wsdlContent) throws Exception {
        this.wsdlElement = UIUtil.buildOMElement((String)wsdlContent);
        this.wsdlPath = wsdlPath;
    }

    public TreeNode buildTree() throws Exception {
        String documentationText;
        OMNode wsdlDocChild;
        String wsdlName = RegistryUtils.getResourceName((String)this.wsdlPath);
        TreeNode root = new TreeNode(TreeNodeBuilderUtil.generateKeyName((String)"Wsdl", (String)wsdlName));
        OMElement wsdlDocElement = TreeNodeBuilderUtil.evaluateXPathToElement((String)"/wsdl:definitions/wsdl:documentation", (OMElement)this.wsdlElement);
        if (wsdlDocElement != null && (wsdlDocChild = wsdlDocElement.getFirstOMChild()) instanceof OMText && (documentationText = ((OMText)wsdlDocChild).getText()) != null) {
            documentationText = documentationText.replace('\n', ' ').trim();
            root.addChild((Object)new TreeNode("Documentation", documentationText));
        }
        String wsdlVersion = TreeNodeBuilder.getWSDLVersion(this.wsdlElement);
        root.addChild((Object)new TreeNode("Version", wsdlVersion));
        if (wsdlVersion.equals("1.1")) {
            this.buildWSDL11Services(root);
            List wsdlImports = TreeNodeBuilderUtil.evaluateXPathToValues((String)"//wsdl:import/@location", (OMElement)this.wsdlElement);
            if (wsdlImports.size() != 0) {
                TreeNode wsdlImportNode = new TreeNode("WSDL Import(s)");
                root.addChild((Object)wsdlImportNode);
                for (String wsdlImport : wsdlImports) {
                    String wsdImportAbsolutePath = this.actualWsdlPath != null ? TreeNodeBuilderUtil.calculateAbsolutePath((String)this.actualWsdlPath, (String)wsdlImport) : TreeNodeBuilderUtil.calculateAbsolutePath((String)this.wsdlPath, (String)wsdlImport);
                    String wsdlImportEntry = "<a href='resource.jsp?path=" + wsdImportAbsolutePath + "'>" + wsdlImport + "</a>";
                    wsdlImportNode.addChild((Object)wsdlImportEntry);
                }
            }
        } else {
            String msg = "Unknown WSDL Version.";
            throw new Exception(msg);
        }
        List schemaImports = TreeNodeBuilderUtil.evaluateXPathToValues((String)"//xsd:import/@schemaLocation", (OMElement)this.wsdlElement);
        if (schemaImports.size() != 0) {
            TreeNode schemaImportsNode = new TreeNode("Schema Import(s)");
            root.addChild((Object)schemaImportsNode);
            for (String schemaImport : schemaImports) {
                if (schemaImport.indexOf(";version:") > 0) {
                    schemaImport = schemaImport.substring(0, schemaImport.lastIndexOf(";version:"));
                }
                String schemaImportAbsolutePath = this.actualWsdlPath != null ? TreeNodeBuilderUtil.calculateAbsolutePath((String)this.actualWsdlPath, (String)schemaImport) : TreeNodeBuilderUtil.calculateAbsolutePath((String)this.wsdlPath, (String)schemaImport);
                String schemaImportEntry = "<a href='resource.jsp?path=" + schemaImportAbsolutePath + "'>" + schemaImport + "</a>";
                schemaImportsNode.addChild((Object)schemaImportEntry);
            }
        }
        return root;
    }

    private void buildWSDL11Services(TreeNode root) throws Exception {
        boolean servicesFound = false;
        List serviceElements = TreeNodeBuilderUtil.evaluateXPathToElements((String)"/wsdl:definitions/wsdl:service", (OMElement)this.wsdlElement);
        for (OMElement serviceElement : serviceElements) {
            String serviceName = serviceElement.getAttributeValue(new QName("name"));
            String serviceNamespace = TreeNodeBuilderUtil.evaluateXPathToValue((String)"ancestor::*/@targetNamespace", (OMElement)serviceElement);
            TreeNode serviceNode = new TreeNode(TreeNodeBuilderUtil.generateKeyName((String)"Service", (String)TreeNodeBuilderUtil.convertQNameToString((String)serviceName, (String)serviceNamespace)));
            root.addChild((Object)serviceNode);
            if (!this.buildPorts(serviceNode, serviceElement)) continue;
            servicesFound = true;
        }
        if (!servicesFound) {
            boolean bindingsFound = false;
            List bindingElements = TreeNodeBuilderUtil.evaluateXPathToElements((String)"/wsdl:definitions/wsdl:binding", (OMElement)this.wsdlElement);
            for (OMElement bindingElement : bindingElements) {
                bindingsFound = true;
                String bindingName = bindingElement.getAttributeValue(new QName("name"));
                String bindingNamespace = TreeNodeBuilderUtil.evaluateXPathToValue((String)"ancestor::*/@targetNamespace", (OMElement)bindingElement);
                TreeNode bindingNode = new TreeNode(TreeNodeBuilderUtil.generateKeyName((String)"Binding", (String)TreeNodeBuilderUtil.convertQNameToString((String)bindingName, (String)bindingNamespace)));
                root.addChild((Object)bindingNode);
                this.fillBinding(bindingNode, bindingElement);
            }
            if (!bindingsFound) {
                List portTypeElements = TreeNodeBuilderUtil.evaluateXPathToElements((String)"/wsdl:definitions/wsdl:portType", (OMElement)this.wsdlElement);
                for (OMElement portTypeElement : portTypeElements) {
                    String portTypeName = portTypeElement.getAttributeValue(new QName("name"));
                    String portTypeNamespace = TreeNodeBuilderUtil.evaluateXPathToValue((String)"ancestor::*/@targetNamespace", (OMElement)portTypeElement);
                    TreeNode portTypeNode = new TreeNode(TreeNodeBuilderUtil.generateKeyName((String)"Port Type", (String)TreeNodeBuilderUtil.convertQNameToString((String)portTypeName, (String)portTypeNamespace)));
                    root.addChild((Object)portTypeNode);
                    this.fillPortType(portTypeNode, portTypeElement);
                }
            }
        }
    }

    private boolean buildPorts(TreeNode serviceNode, OMElement serviceElement) throws Exception {
        List portElements = TreeNodeBuilderUtil.evaluateXPathToElements((String)"wsdl:port", (OMElement)serviceElement);
        boolean portTypesFound = false;
        for (OMElement portElement : portElements) {
            String portName = portElement.getAttributeValue(new QName("name"));
            String portNamespace = TreeNodeBuilderUtil.evaluateXPathToValue((String)"ancestor::*/@targetNamespace", (OMElement)portElement);
            TreeNode portNode = new TreeNode(TreeNodeBuilderUtil.generateKeyName((String)"Port", (String)TreeNodeBuilderUtil.convertQNameToString((String)portName, (String)portNamespace)));
            serviceNode.addChild((Object)portNode);
            String bindingName = portElement.getAttributeValue(new QName("binding"));
            if (bindingName == null) continue;
            String bindingNamespace = TreeNodeBuilderUtil.getNamespaceURI((String)bindingName, (OMElement)portElement);
            String bindingLocalName = TreeNodeBuilderUtil.getLocalName((String)bindingName);
            String bindingExpression = "/wsdl:definitions/wsdl:binding[@name='" + bindingLocalName + "' and ancestor::*[@targetNamespace='" + bindingNamespace + "']]";
            OMElement bindingElement = TreeNodeBuilderUtil.evaluateXPathToElement((String)bindingExpression, (OMElement)this.wsdlElement);
            if (bindingElement != null) {
                String endpoint;
                portTypesFound = true;
                OMElement bindingProtocolElement = TreeNodeBuilderUtil.evaluateXPathToElement((String)"soap:binding", (OMElement)bindingElement);
                if (bindingProtocolElement != null) {
                    endpoint = TreeNodeBuilderUtil.evaluateXPathToValue((String)"soap:address/@location", (OMElement)portElement);
                    portNode.addChild((Object)new TreeNode("Address", endpoint));
                    portNode.addChild((Object)new TreeNode("SOAP Version", "SOAP 1.1"));
                } else {
                    bindingProtocolElement = TreeNodeBuilderUtil.evaluateXPathToElement((String)"soap12:binding", (OMElement)bindingElement);
                    if (bindingProtocolElement != null) {
                        endpoint = TreeNodeBuilderUtil.evaluateXPathToValue((String)"soap12:address/@location", (OMElement)portElement);
                        portNode.addChild((Object)new TreeNode("Address", endpoint));
                        portNode.addChild((Object)new TreeNode("SOAP Version", "SOAP 1.2"));
                    }
                }
                if (bindingProtocolElement != null) {
                    String style = TreeNodeBuilderUtil.evaluateXPathToValue((String)"//@style", (OMElement)bindingProtocolElement);
                    portNode.addChild((Object)new TreeNode("Style", style));
                    String transport = bindingProtocolElement.getAttributeValue(new QName("transport"));
                    if (transport.equals("http://schemas.xmlsoap.org/soap/http")) {
                        portNode.addChild((Object)new TreeNode("Transport", "Http"));
                    } else {
                        portNode.addChild((Object)new TreeNode("Transport", "Non Http"));
                    }
                }
                if (bindingProtocolElement == null && (bindingProtocolElement = TreeNodeBuilderUtil.evaluateXPathToElement((String)"http:binding", (OMElement)bindingElement)) != null) {
                    endpoint = TreeNodeBuilderUtil.evaluateXPathToValue((String)"http:address/@location", (OMElement)portElement);
                    portNode.addChild((Object)new TreeNode("Address", endpoint));
                    portNode.addChild((Object)new TreeNode("Http Binding", "True"));
                    String verb = bindingProtocolElement.getAttributeValue(new QName("verb"));
                    portNode.addChild((Object)new TreeNode("Verb", verb));
                }
                this.fillBinding(portNode, bindingElement);
            } else {
                String endpoint = TreeNodeBuilderUtil.evaluateXPathToValue((String)"soap:address/@location", (OMElement)portElement);
                if (endpoint != null) {
                    portNode.addChild((Object)new TreeNode("Address", endpoint));
                    portNode.addChild((Object)new TreeNode("SOAP Version", "SOAP 1.1"));
                } else {
                    endpoint = TreeNodeBuilderUtil.evaluateXPathToValue((String)"soap12:address/@location", (OMElement)portElement);
                    if (endpoint != null) {
                        portNode.addChild((Object)new TreeNode("Address", endpoint));
                        portNode.addChild((Object)new TreeNode("SOAP Version", "SOAP 1.2"));
                    }
                }
                if (endpoint == null && (endpoint = TreeNodeBuilderUtil.evaluateXPathToValue((String)"http:address/@location", (OMElement)portElement)) != null) {
                    portNode.addChild((Object)new TreeNode("Address", endpoint));
                    portNode.addChild((Object)new TreeNode("Http Binding", "True"));
                }
            }
            portNode.addChild((Object)new TreeNode("Binding", TreeNodeBuilderUtil.convertQNameToString((String)bindingLocalName, (String)bindingNamespace)));
        }
        return portTypesFound;
    }

    private void fillBinding(TreeNode bindingNode, OMElement bindingElement) throws Exception {
        String typeName = bindingElement.getAttributeValue(new QName("type"));
        if (typeName != null) {
            String typeNamespace = TreeNodeBuilderUtil.getNamespaceURI((String)typeName, (OMElement)bindingElement);
            String typeLocalName = TreeNodeBuilderUtil.getLocalName((String)typeName);
            TreeNode typeNode = new TreeNode(TreeNodeBuilderUtil.generateKeyName((String)"Port Type", (String)TreeNodeBuilderUtil.convertQNameToString((String)typeLocalName, (String)typeNamespace)));
            bindingNode.addChild((Object)typeNode);
            String typeExpression = "/wsdl:definitions/wsdl:portType[@name='" + typeLocalName + "' and ancestor::*[@targetNamespace='" + typeNamespace + "']]";
            OMElement typeElement = TreeNodeBuilderUtil.evaluateXPathToElement((String)typeExpression, (OMElement)this.wsdlElement);
            if (typeElement != null) {
                this.fillPortType(typeNode, typeElement);
            }
        }
    }

    private void fillPortType(TreeNode typeNode, OMElement typeElement) throws Exception {
        TreeNode operationsNode = new TreeNode("Operation(s)");
        typeNode.addChild((Object)operationsNode);
        List operations = TreeNodeBuilderUtil.evaluateXPathToValues((String)"wsdl:operation/@name", (OMElement)typeElement);
        for (String operation : operations) {
            operationsNode.addChild((Object)operation);
        }
    }

    private static String getWSDLVersion(OMElement wsdlElement) throws Exception {
        QName wsdl11RootQName = new QName("http://schemas.xmlsoap.org/wsdl/", "definitions");
        QName wsdl2RootQName = new QName("http://www.w3.org/ns/wsdl", "description");
        String wsdlVersion = wsdl11RootQName.equals(wsdlElement.getQName()) ? "1.1" : (wsdl2RootQName.equals(wsdlElement.getQName()) ? "2.0" : "Unknown");
        return wsdlVersion;
    }

    public void setActualWsdlPath(String actualWsdlPath) {
        this.actualWsdlPath = actualWsdlPath;
    }
}

