/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.services.ui.utils;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.services.ui.utils.AddServicesUtil;
import org.wso2.carbon.governance.services.ui.utils.DropDownDataPopulator;
import org.wso2.carbon.ui.CarbonUIUtil;

public class AddServiceUIGenerator {
    private static final Log log = LogFactory.getLog(AddServiceUIGenerator.class);
    private String dataElement;
    private String dataNamespace;

    public AddServiceUIGenerator() {
        this("serviceMetaData", "http://www.wso2.org/governance/metadata");
    }

    public AddServiceUIGenerator(String dataElement, String dataNamespace) {
        this.dataElement = dataElement;
        this.dataNamespace = dataNamespace;
    }

    public OMElement getUIConfiguration(String content, HttpServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        OMElement omElement = null;
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(content));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            omElement = builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            log.error((Object)"Unable to parse the UI configuration.", (Throwable)e);
        }
        return omElement;
    }

    public String printWidgetWithValues(OMElement widget, OMElement data, boolean isFilterOperation, HttpServletRequest request, ServletConfig config) {
        return this.printWidgetWithValues(widget, data, isFilterOperation, true, true, request, config);
    }

    public String printWidgetWithValues(OMElement widget, OMElement data, boolean isFilterOperation, boolean markReadonly, boolean hasValue, HttpServletRequest request, ServletConfig config) {
        if (isFilterOperation && Boolean.toString(false).equals(widget.getAttributeValue(new QName(null, "filter")))) {
            return "";
        }
        int columns = 2;
        String widgetName = widget.getAttributeValue(new QName(null, "name"));
        boolean collapsed = true;
        String widgetCollapse = widget.getAttributeValue(new QName(null, "collapsed"));
        if (widgetCollapse != null) {
            collapsed = Boolean.valueOf(widgetCollapse);
        }
        String divId = "_collapse_id_" + widgetName.replaceAll(" ", "");
        OMElement dataHead = null;
        if (data != null) {
            dataHead = AddServicesUtil.getChildWithName(data, widgetName, this.dataNamespace);
        }
        if (widget.getAttributeValue(new QName(null, "columns")) != null) {
            columns = Integer.parseInt(widget.getAttributeValue(new QName(null, "columns")));
        }
        Iterator subHeadingIt = widget.getChildrenWithName(new QName(null, "subheading"));
        StringBuilder table = new StringBuilder();
        table.append("<div id=\"" + divId + "\"  " + "onmouseover='title=\"\"' onmouseout='title=\"" + String.valueOf(collapsed) + "\"'" + " title=\"" + String.valueOf(collapsed) + "\"><table class=\"normal-nopadding\" cellspacing=\"0\">");
        ArrayList<String> subList = new ArrayList<String>();
        OMElement sub = null;
        if (subHeadingIt != null && subHeadingIt.hasNext()) {
            sub = (OMElement)subHeadingIt.next();
        }
        if (sub != null && "subheading".equals(sub.getLocalName())) {
            Iterator headingList = sub.getChildrenWithLocalName("heading");
            while (headingList.hasNext()) {
                OMElement subheading = (OMElement)headingList.next();
                subList.add(subheading.getText());
            }
            if (subList.size() > columns) {
                return "";
            }
        }
        table.append(this.printMainHeader(widgetName, columns));
        if (subList.size() > 2) {
            table.append(this.printSubHeaders(subList.toArray(new String[subList.size()])));
        }
        Iterator arguments = widget.getChildrenWithLocalName("field");
        int columnCount = 0;
        int rowCount = 0;
        OMElement inner = null;
        while (arguments.hasNext()) {
            OMElement firstChildWithName;
            OMElement arg = (OMElement)arguments.next();
            String maxOccurs = "";
            if (!"field".equals(arg.getLocalName()) || isFilterOperation && Boolean.toString(false).equals(arg.getAttributeValue(new QName(null, "filter")))) continue;
            ++rowCount;
            String elementType = arg.getAttributeValue(new QName(null, "type"));
            maxOccurs = arg.getAttributeValue(new QName(null, "maxoccurs"));
            if (maxOccurs != null) {
                if (!"bounded".equals(maxOccurs) && !"unbounded".equals(maxOccurs)) {
                    return "";
                }
                if (!"unbounded".equals(maxOccurs) && rowCount == 1) {
                    table.append(this.printSubHeaders(subList.toArray(new String[subList.size()])));
                }
            } else if (subList.size() == 2 && rowCount == 1) {
                table.append(this.printSubHeaders(subList.toArray(new String[subList.size()])));
            }
            if (dataHead != null) {
                inner = AddServicesUtil.getChildWithName(dataHead, arg.getFirstChildWithName(new QName(null, "name")).getText().replaceAll(" ", "-"), this.dataNamespace);
            }
            String value = null;
            String optionValue = null;
            if ("text".equals(elementType)) {
                String mandat = arg.getAttributeValue(new QName(null, "required"));
                boolean isReadOnly = false;
                if (markReadonly && "true".equals(arg.getAttributeValue(new QName(null, "readonly")))) {
                    isReadOnly = true;
                }
                if (isFilterOperation) {
                    mandat = "false";
                }
                boolean isURL = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "url")));
                String urlTemplate = arg.getAttributeValue(new QName(null, "template"));
                boolean isPath = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "path")));
                value = inner != null ? inner.getText() : arg.getAttributeValue(new QName(null, "default"));
                if (columns > 2) {
                    if (columnCount == 0) {
                        table.append("<tr>");
                    }
                    if (value != null) {
                        table.append(this.printTextSkipName(arg.getFirstChildWithName(new QName(null, "name")).getText(), widgetName, value, isURL, urlTemplate, isPath, isReadOnly, hasValue, request));
                    } else {
                        table.append(this.printTextSkipName(arg.getFirstChildWithName(new QName(null, "name")).getText(), widgetName, isPath, isReadOnly, request));
                    }
                    if (++columnCount != columns) continue;
                    table.append("</tr>");
                    columnCount = 0;
                    continue;
                }
                OMElement firstChildWithName2 = arg.getFirstChildWithName(new QName(null, "name"));
                String name = firstChildWithName2.getText();
                String label = firstChildWithName2.getAttributeValue(new QName("label"));
                if (label == null) {
                    label = name;
                }
                if (value != null) {
                    table.append(this.printTextField(label, name, mandat, widgetName, value, isURL, urlTemplate, isPath, isReadOnly, hasValue, request));
                    continue;
                }
                table.append(this.printTextField(label, name, mandat, widgetName, isPath, isReadOnly, request));
                continue;
            }
            if ("options".equals(elementType)) {
                firstChildWithName = arg.getFirstChildWithName(new QName(null, "name"));
                String name = firstChildWithName.getText();
                String label = firstChildWithName.getAttributeValue(new QName("label"));
                if (label == null) {
                    label = name;
                }
                if (inner != null) {
                    optionValue = inner.getText();
                }
                List<String> optionValues = this.getOptionValues(arg, request, config);
                if (isFilterOperation) {
                    optionValues.add(0, "");
                }
                if (columns > 2) {
                    if (columnCount == 0) {
                        table.append("<tr>");
                    }
                    if (optionValue != null) {
                        table.append(this.printDropDownSkipName(name, optionValues.toArray(new String[optionValues.size()]), widgetName, optionValue));
                    } else {
                        table.append(this.printDropDownSkipName(name, optionValues.toArray(new String[optionValues.size()]), widgetName));
                    }
                    if (++columnCount != columns) continue;
                    table.append("</tr>");
                    columnCount = 0;
                    continue;
                }
                if (optionValue != null) {
                    table.append(this.printDropDown(label, name, optionValues.toArray(new String[optionValues.size()]), widgetName, optionValue));
                    continue;
                }
                table.append(this.printDropDown(label, name, optionValues.toArray(new String[optionValues.size()]), widgetName));
                continue;
            }
            if ("checkbox".equals(elementType)) {
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                if (inner != null) {
                    optionValue = inner.getText();
                }
                if (columns > 2) {
                    if (columnCount == 0) {
                        table.append("<tr>");
                    }
                    table.append(this.printCheckboxSkipName(name, widgetName, optionValue));
                    if (++columnCount != columns) continue;
                    table.append("</tr>");
                    columnCount = 0;
                    continue;
                }
                table.append(this.printCheckbox(name, widgetName, optionValue));
                continue;
            }
            if ("text-area".equals(elementType)) {
                String widthString;
                String mandet = arg.getAttributeValue(new QName(null, "required"));
                String richText = arg.getAttributeValue(new QName(null, "isRichText"));
                boolean isReadOnly = false;
                if (markReadonly && "true".equals(arg.getAttributeValue(new QName(null, "readonly")))) {
                    isReadOnly = true;
                }
                boolean isRichText = false;
                if (richText != null) {
                    isRichText = Boolean.valueOf(richText);
                }
                if (isFilterOperation) {
                    mandet = "false";
                }
                if (inner != null) {
                    value = inner.getText();
                }
                int height = -1;
                int width = -1;
                String heightString = arg.getAttributeValue(new QName(null, "height"));
                if (heightString != null) {
                    try {
                        height = Integer.parseInt(heightString);
                    }
                    catch (NumberFormatException ignored) {
                        // empty catch block
                    }
                }
                if ((widthString = arg.getAttributeValue(new QName(null, "width"))) != null) {
                    try {
                        width = Integer.parseInt(widthString);
                    }
                    catch (NumberFormatException ignored) {
                        // empty catch block
                    }
                }
                if (columns > 2) {
                    if (columnCount == 0) {
                        table.append("<tr>");
                    }
                    if (value != null) {
                        table.append(this.printTextAreaSkipName(arg.getFirstChildWithName(new QName(null, "name")).getText(), widgetName, value, height, width, isReadOnly));
                    } else {
                        table.append(this.printTextAreaSkipName(arg.getFirstChildWithName(new QName(null, "name")).getText(), widgetName, height, width, isReadOnly));
                    }
                    if (++columnCount != columns) continue;
                    table.append("</tr>");
                    columnCount = 0;
                    continue;
                }
                OMElement firstChildWithName3 = arg.getFirstChildWithName(new QName(null, "name"));
                String name = firstChildWithName3.getText();
                String label = firstChildWithName3.getAttributeValue(new QName("label"));
                if (label == null) {
                    label = name;
                }
                if (value != null) {
                    table.append(this.printTextArea(label, name, mandet, widgetName, value, height, width, isReadOnly, isRichText));
                    continue;
                }
                table.append(this.printTextArea(label, name, mandet, widgetName, height, width, isReadOnly, isRichText));
                continue;
            }
            if (!"option-text".equals(elementType)) continue;
            if ("unbounded".equals(maxOccurs)) {
                firstChildWithName = arg.getFirstChildWithName(new QName(null, "name"));
                String name = firstChildWithName.getText();
                String label = firstChildWithName.getAttributeValue(new QName("label"));
                if (label == null) {
                    label = name;
                }
                boolean isURL = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "url")));
                String urlTemplate = arg.getAttributeValue(new QName(null, "template"));
                boolean isPath = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "path")));
                ArrayList<String> addedOptionValues = new ArrayList<String>();
                ArrayList<String> addedValues = new ArrayList<String>();
                int addedItemsCount = 0;
                if (dataHead != null) {
                    Iterator itemChildIt = dataHead.getChildElements();
                    int i = 0;
                    while (itemChildIt.hasNext()) {
                        OMElement itemChildEle;
                        Object itemChildObj = itemChildIt.next();
                        if (!(itemChildObj instanceof OMElement) || !(itemChildEle = (OMElement)itemChildObj).getQName().equals(new QName(this.dataNamespace, "entry"))) continue;
                        String entryText = itemChildEle.getText();
                        String entryKey = null;
                        int colonIndex = entryText.indexOf(":");
                        if (colonIndex < entryText.length() - 1) {
                            entryKey = entryText.substring(0, colonIndex);
                            entryText = entryText.substring(colonIndex + 1);
                        }
                        String entryVal = entryText;
                        if (entryKey != null && !entryKey.equals("")) {
                            addedOptionValues.add(entryKey);
                        } else {
                            addedOptionValues.add("0");
                        }
                        if (entryVal != null) {
                            addedValues.add(entryVal);
                        }
                        ++i;
                    }
                    addedItemsCount = i;
                }
                if (addedItemsCount == 0) {
                    table.append(this.printAddLink(label, name, "../admin/images/add.gif", widgetName, subList.toArray(new String[subList.size() + 1]), isPath));
                } else if (addedItemsCount > 0) {
                    table.append(this.printAddLinkWithDisplay(label, name, "../admin/images/add.gif", widgetName, subList.toArray(new String[subList.size() + 1]), isPath));
                }
                List<String> optionValues = this.getOptionValues(arg, request, config);
                if (addedItemsCount > 0) {
                    for (int i = 0; i < addedItemsCount; ++i) {
                        String addedOptionValue = (String)addedOptionValues.get(i);
                        String addedValue = (String)addedValues.get(i);
                        if (addedOptionValue == null || addedValue == null) continue;
                        table.append(this.printOptionTextWithId(name, i + 1, optionValues.toArray(new String[optionValues.size()]), widgetName, addedOptionValue, addedValue, isURL, urlTemplate, isPath, request));
                    }
                }
                table.append(this.printCloseAddLink(name, addedItemsCount));
                continue;
            }
            firstChildWithName = arg.getFirstChildWithName(new QName(null, "name"));
            String name = firstChildWithName.getText();
            String label = firstChildWithName.getAttributeValue(new QName("label"));
            if (label == null) {
                label = name;
            }
            boolean isURL = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "url")));
            String urlTemplate = arg.getAttributeValue(new QName(null, "template"));
            boolean isPath = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "path")));
            if (dataHead != null) {
                OMElement optionValueElement;
                inner = AddServicesUtil.getChildWithName(dataHead, "text" + arg.getFirstChildWithName(new QName(null, "name")).getText(), this.dataNamespace);
                if (inner != null) {
                    value = inner.getText();
                }
                if ((optionValueElement = AddServicesUtil.getChildWithName(dataHead, arg.getFirstChildWithName(new QName(null, "name")).getText(), this.dataNamespace)) != null) {
                    optionValue = optionValueElement.getText();
                }
            }
            List<String> optionValues = this.getOptionValues(arg, request, config);
            if (optionValue != null && value != null) {
                table.append(this.printOptionText(label, name, optionValues.toArray(new String[optionValues.size()]), widgetName, optionValue, value, isURL, urlTemplate, isPath, request));
                continue;
            }
            table.append(this.printOptionText(label, name, optionValues.toArray(new String[optionValues.size()]), widgetName, isPath, request));
        }
        table.append("</table></div>");
        return table.toString();
    }

    public String printMainHeader(String header, int columns) {
        StringBuilder head = new StringBuilder();
        head.append("<thead><tr><th style=\"border-right:0\" colspan=\"" + columns + "\">");
        head.append(header);
        head.append("</th></tr></thead>");
        return head.toString();
    }

    public String printSubHeaders(String[] headers) {
        StringBuilder subHeaders = new StringBuilder();
        subHeaders.append("<tr>");
        for (String header : headers) {
            subHeaders.append("<td class=\"sub-header\">");
            subHeaders.append(header == null ? "" : header);
            subHeaders.append("</td>");
        }
        subHeaders.append("<td class=\"sub-header\"></td>");
        subHeaders.append("</tr>");
        return subHeaders.toString();
    }

    public String printTextField(String label, String name, String mandatory, String widget, boolean isPath, boolean isReadOnly, HttpServletRequest request) {
        StringBuilder element = new StringBuilder();
        String selectResource = "";
        String id = "id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-");
        if (isPath) {
            selectResource = " <input type=\"button\" class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" onclick=\"showGovernanceResourceTree('" + id + "');\"/>";
        }
        if ("true".equals(mandatory)) {
            element.append("<tr><td class=\"leftCol-big\">" + label + "<span class=\"required\">*</span></td>\n" + " <td><input type=\"text\" name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" id=\"" + id + "\" style=\"width:" + "400" + "px\"" + (isReadOnly ? " readonly" : "") + "/>" + (isPath ? selectResource : "") + "</td></tr>");
        } else {
            element.append("<tr><td class=\"leftCol-big\">" + label + "</td>\n" + " <td><input type=\"text\" name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" id=\"" + id + "\" style=\"width:" + "400" + "px\"" + (isReadOnly ? " readonly" : "") + "/>" + (isPath ? selectResource : "") + "</td></tr>");
        }
        return element.toString();
    }

    public String printDropDown(String label, String name, String[] values, String widget) {
        StringBuilder dropDown = new StringBuilder();
        dropDown.append("<tr><td class=\"leftCol-big\">" + label + "</td>\n" + "<td><select name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\">");
        for (int i = 0; i < values.length; ++i) {
            dropDown.append("<option value=\"" + values[i] + "\">");
            dropDown.append(values[i]);
            dropDown.append("</option>");
        }
        dropDown.append("</select></td></tr>");
        return dropDown.toString();
    }

    public String printTextArea(String label, String name, String mandatory, String widget, int height, int width, boolean isReadOnly, boolean isRichText) {
        StringBuilder element = new StringBuilder();
        StringBuilder size = new StringBuilder("style=\"");
        if (height > 0) {
            size.append("height:").append(height).append("px;");
        }
        if (width > 0) {
            size.append("width:").append(width).append("px\"");
        } else {
            size.append("width:").append("400").append("px\"");
        }
        if ("true".equals(mandatory)) {
            if (isRichText) {
                element.append("<tr><td class=\"leftCol-big\">" + label + "<span class=\"required\">*</span></td>\n" + " <td  style=\"font-size:8px\" class=\"yui-skin-sam\"><textarea  name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" id=\"id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" " + size + (isReadOnly ? " readonly" : "") + " ></textarea>");
                element = this.appendRichTextScript(element, width, height, widget, name);
                element.append("</td></tr>");
            } else {
                element.append("<tr><td class=\"leftCol-big\">" + label + "<span class=\"required\">*</span></td>\n" + " <td><textarea  name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" id=\"id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" " + size + (isReadOnly ? " readonly" : "") + " ></textarea></td></tr>");
                element = this.appendEmptyScript(element, widget, name);
                element.append("</td></tr>");
            }
        } else if (isRichText) {
            element.append("<tr><td class=\"leftCol-big\">" + label + "</td>\n" + " <td  style=\"font-size:8px\" class=\"yui-skin-sam\"><textarea  name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" id=\"id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" " + size + (isReadOnly ? " readonly" : "") + " ></textarea>");
            element = this.appendRichTextScript(element, width, height, widget, name);
            element.append("</td></tr>");
        } else {
            element.append("<tr><td class=\"leftCol-big\">" + label + "</td>\n" + " <td><textarea  name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" id=\"id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" " + size + (isReadOnly ? " readonly" : "") + " ></textarea></td></tr>");
            element = this.appendEmptyScript(element, widget, name);
            element.append("</td></tr>");
        }
        return element.toString();
    }

    public String printTextAreaSkipName(String name, String widget, int height, int width, boolean isReadOnly) {
        StringBuilder element = new StringBuilder();
        StringBuilder size = new StringBuilder();
        if (height > 0 || width > 0) {
            size = size.append("");
            if (height > 0) {
                size.append("height:").append(height).append("px;");
            }
            if (width > 0) {
                size.append("width:").append(width).append("px\"");
            }
            size.append("\"");
        }
        element.append("<td><textarea  name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" " + "id=\"id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" " + size + (isReadOnly ? " readonly" : "") + " ></textarea></td>");
        return element.toString();
    }

    public String printTextSkipName(String name, String widget, boolean isPath, boolean isReadOnly, HttpServletRequest request) {
        StringBuilder element = new StringBuilder();
        String id = "id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-");
        String selectResource = "";
        if (isPath) {
            selectResource = " <input type=\"button\" class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" onclick=\"showGovernanceResourceTree('" + id + "');\"/>";
        }
        element.append("<td><input type=\"text\" name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" id=\"" + id + "\"" + (isReadOnly ? " readonly" : "") + " />" + (isPath ? selectResource : "") + "</td>");
        return element.toString();
    }

    public String printDropDownSkipName(String name, String[] values, String widget) {
        StringBuilder dropDown = new StringBuilder();
        dropDown.append("<td><select name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\">");
        for (int i = 0; i < values.length; ++i) {
            dropDown.append("<option value=\"" + values[i] + "\">");
            dropDown.append(values[i]);
            dropDown.append("</option>");
        }
        dropDown.append("</select></td>");
        return dropDown.toString();
    }

    public String printOptionText(String label, String name, String[] values, String widget, boolean isPath, HttpServletRequest request) {
        StringBuilder dropDown = new StringBuilder();
        dropDown.append("<tr><td class=\"leftCol-big\"><select name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\">");
        for (int i = 0; i < values.length; ++i) {
            dropDown.append("<option value=\"" + values[i] + "\">");
            dropDown.append(values[i]);
            dropDown.append("</option>");
        }
        dropDown.append("</select></td>");
        String id = "id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-");
        String selectResource = "";
        if (isPath) {
            selectResource = " <input type=\"button\" class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" onclick=\"showGovernanceResourceTree('" + id + "');\"/>";
        }
        dropDown.append("<td width=500px><input type=\"text\" name=\"" + widget.replaceAll(" ", "_") + "text" + "_" + name.replaceAll(" ", "-") + "\" id=\"" + id + "\" style=\"width:" + "400" + "px\"/>" + (isPath ? selectResource : "") + "</td>");
        dropDown.append("<td><a class=\"icon-link\" title=\"delete\" onclick=\"delete" + name.replaceAll(" ", "-") + "_" + widget.replaceAll(" ", "_") + "(this.parentNode.parentNode.rowIndex)\" style=\"background-image:url(../admin/images/delete.gif);\">Delete</a></td>");
        dropDown.append("</tr>");
        return dropDown.toString();
    }

    public String printTextField(String label, String name, String mandatory, String widget, String value, boolean isURL, String urlTemplate, boolean isPath, boolean isReadOnly, boolean hasValue, HttpServletRequest request) {
        StringBuilder element = new StringBuilder();
        String id = "id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-");
        String selectResource = "";
        String selectResourceButton = "$('" + id + "_button').style.display='';";
        if (isPath) {
            selectResource = " <input id=\"" + id + "_button\" type=\"button\" class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" onclick=\"showGovernanceResourceTree('" + id + "');\"/>";
        }
        String div = "<div id=\"" + id + "_link\"><a target=\"_blank\" href=\"" + (isPath ? "../resources/resource.jsp?region=region3&item=resource_browser_menu&path=/_system/governance" : "") + (urlTemplate != null ? urlTemplate.replace("@{value}", value) : value) + "\">" + value + "</a>" + "&nbsp;<a onclick=\"$('" + id + "_link').style.display='none';$('" + id + "')." + "style.display='';" + (isPath ? selectResourceButton : "") + "\" title=\"" + CarbonUIUtil.geti18nString((String)"edit", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" " + "class=\"icon-link\" style=\"background-image: url('../admin/images/edit.gif');float: none\"></a></div>";
        if ("true".equals(mandatory)) {
            element.append("<tr><td class=\"leftCol-big\">" + label + "<span class=\"required\">*</span></td>\n" + " <td>" + (isURL ? div : "") + "<input" + (isURL ? " style=\"display:none\"" : "") + " type=\"text\" name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\"" + (hasValue ? "value=\"" + value + "\"" : "") + " id=\"" + id + "\" style=\"width:" + "400" + "px\"" + (isReadOnly ? " readonly" : "") + "/>" + (isPath ? selectResource : "") + "</td></tr>");
        } else {
            element.append("<tr><td class=\"leftCol-big\">" + label + "</td>\n" + " <td>" + (isURL ? div : "") + "<input" + (isURL ? " style=\"display:none\"" : "") + " type=\"text\" name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\"" + (hasValue ? "value=\"" + value + "\"" : "") + " id=\"" + id + "\" style=\"width:" + "400" + "px\"" + (isReadOnly ? " readonly" : "") + "/>" + (isPath ? selectResource : "") + "</td></tr>");
        }
        return element.toString();
    }

    public String printDropDown(String label, String name, String[] values, String widget, String value) {
        StringBuilder dropDown = new StringBuilder();
        dropDown.append("<tr><td class=\"leftCol-big\">" + label + "</td>\n" + "<td><select name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\">");
        for (int i = 0; i < values.length; ++i) {
            dropDown.append("<option value=\"" + values[i] + "\"");
            if (values[i].equals(value)) {
                dropDown.append(" selected>");
            } else {
                dropDown.append(">");
            }
            dropDown.append(values[i]);
            dropDown.append("</option>");
        }
        dropDown.append("</select></td></tr>");
        return dropDown.toString();
    }

    public String printCheckbox(String name, String widget, String value) {
        if (Boolean.toString(true).equals(value)) {
            return "<tr><td class=\"leftCol-big\">" + name + "</td>\n" + "<td><input type=\"checkbox\" checked=\"checked\" name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" value=\"true\" /></td>";
        }
        return "<tr><td class=\"leftCol-big\">" + name + "</td>\n" + "<td><input type=\"checkbox\" name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" value=\"true\" /></td>";
    }

    public String printTextArea(String label, String name, String mandatory, String widget, String value, int height, int width, boolean isReadOnly, boolean isRichText) {
        StringBuilder element = new StringBuilder();
        StringBuilder size = new StringBuilder("style=\"");
        if (height > 0) {
            size.append("height:").append(height).append("px;");
        }
        if (width > 0) {
            size.append("width:").append(width).append("px\"");
        } else {
            size.append("width:").append("400").append("px\"");
        }
        if ("true".equals(mandatory)) {
            if (isRichText) {
                element.append("<tr><td class=\"leftCol-big\">" + label + "<span class=\"required\">*</span></td>\n" + " <td  style=\"font-size:8px\" class=\"yui-skin-sam\"><textarea  name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" id=\"id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" " + size + (isReadOnly ? " readonly" : "") + " >" + value + "</textarea>");
                element = this.appendRichTextScript(element, width, height, widget, name);
                element.append("</td></tr>");
            } else {
                element.append("<tr><td class=\"leftCol-big\">" + label + "<span class=\"required\">*</span></td>\n" + " <td><textarea  name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" id=\"id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" " + size + (isReadOnly ? " readonly" : "") + " >" + value + "</textarea>");
                element = this.appendEmptyScript(element, widget, name);
                element.append("</td></tr>");
            }
        } else if (isRichText) {
            element.append("<tr><td class=\"leftCol-big\">" + label + "<span class=\"required\">*</span></td>\n" + " <td  style=\"font-size:8px\" class=\"yui-skin-sam\"><textarea  name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" id=\"id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" " + size + (isReadOnly ? " readonly" : "") + " >" + value + "</textarea>");
            element = this.appendRichTextScript(element, width, height, widget, name);
            element.append("</td></tr>");
        } else {
            element.append("<tr><td class=\"leftCol-big\">" + label + "</td>\n" + " <td><textarea  name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" id=\"id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" " + size + (isReadOnly ? " readonly" : "") + " >" + value + "</textarea>");
            element = this.appendEmptyScript(element, widget, name);
            element.append("</td></tr>");
        }
        return element.toString();
    }

    private StringBuilder appendEmptyScript(StringBuilder element, String widget, String name) {
        String eleName = "id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-");
        String fun_name = "set_" + eleName;
        element.append("<script>\n");
        element.append("function " + fun_name + "(){}");
        element.append("</script>");
        return element;
    }

    private StringBuilder appendRichTextScript(StringBuilder element, int width, int height, String widget, String name) {
        String attrName = widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-");
        String eleName = "id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-");
        String ele_id = "_id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-");
        String fun_name = "set_" + eleName;
        String richTextAttrName = "yui_txt_" + eleName;
        element.append("<script>\n\nvar " + richTextAttrName + ";\n" + "(function() {\n" + "    var Dom = YAHOO.util.Dom,\n" + "        Event = YAHOO.util.Event;\n" + "    \n" + "    var myConfig = {\n" + "        height: '" + "120" + "px',\n" + "        width: '" + "400" + "px',\n" + "        dompath: true,\n" + "        focusAtStart: true\n" + "    };\n" + "\n" + "    YAHOO.log('Create the Editor..', 'info', 'example');\n" + "    " + richTextAttrName + " = new YAHOO.widget.SimpleEditor('" + eleName + "', myConfig);\n" + "    " + richTextAttrName + ".render();\n" + "\n" + "})();\n");
        element.append("function " + fun_name + "(){\n" + "        var form1 = document.getElementById('CustomUIForm');\n" + "        var newInput = document.createElement('input');\n" + "        newInput.setAttribute('type','hidden');\n" + "        newInput.setAttribute('name','" + attrName + "');\n" + "        newInput.setAttribute('id','" + ele_id + "');\n" + "        form1.appendChild(newInput);" + "    var contentText=\"\";\n" + "    " + richTextAttrName + ".saveHTML();\n" + "    contentText = " + richTextAttrName + ".get('textarea').value;\n" + "    document.getElementById(\"" + ele_id + "\").value = contentText;\n" + "}");
        element.append("</script>");
        return element;
    }

    public String printTextAreaSkipName(String name, String widget, String value, int height, int width, boolean isReadOnly) {
        StringBuilder element = new StringBuilder();
        StringBuilder size = new StringBuilder();
        if (height > 0 || width > 0) {
            size = size.append("");
            if (height > 0) {
                size.append("height:").append(height).append("px;");
            }
            if (width > 0) {
                size.append("width:").append(width).append("px\"");
            }
            size.append("\"");
        }
        element.append("<td><textarea  name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" " + "id=\"id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" " + size + (isReadOnly ? " readonly" : "") + " >" + value + "</textarea></td>");
        return element.toString();
    }

    public String printTextSkipName(String name, String widget, String value, boolean isURL, String urlTemplate, boolean isPath, boolean isReadOnly, boolean hasValue, HttpServletRequest request) {
        StringBuilder element = new StringBuilder();
        String id = "id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-");
        if (isURL) {
            String selectResource = "";
            String selectResourceButton = "$('" + id + "_button').style.display='';";
            if (isPath) {
                selectResource = " <inputid=\"" + id + "_button\" type=\"button\" class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" onclick=\"showGovernanceResourceTree('" + id + "');\"/>";
            }
            String div = "<div id=\"" + id + "_link\"><a target=\"_blank\" href=\"" + (isPath ? "../resources/resource.jsp?region=region3&item=resource_browser_menu&path=/_system/governance" : "") + (urlTemplate != null ? urlTemplate.replace("@{value}", value) : value) + "\">" + value + "</a>" + "&nbsp;<a onclick=\"$('" + id + "_link').style.display='none';$('" + id + "')." + "style.display='';" + (isPath ? selectResourceButton : "") + "\" title=\"" + CarbonUIUtil.geti18nString((String)"edit", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" " + "class=\"icon-link\" style=\"background-image: url('../admin/images/edit.gif');float: none\"></a></div>";
            element.append("<td>" + div + "<input style=\"display:none\" type=\"text\" name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\"" + (hasValue ? "value=\"" + value + "\"" : "") + " id=\"" + id + "\"" + (isReadOnly ? " readonly" : "") + " />" + (isPath ? selectResource : "") + "</td>");
        } else {
            String selectResource = "";
            if (isPath) {
                selectResource = " <input type=\"button\" class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" onclick=\"showGovernanceResourceTree('" + id + "');\"/>";
            }
            element.append("<td><input type=\"text\" name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\"" + (hasValue ? "value=\"" + value + "\"" : "") + " id=\"" + id + "\"" + (isReadOnly ? " readonly" : "") + " />" + (isPath ? selectResource : "") + "</td>");
        }
        return element.toString();
    }

    public String printDropDownSkipName(String name, String[] values, String widget, String value) {
        StringBuilder dropDown = new StringBuilder();
        dropDown.append("<td><select name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\">");
        for (int i = 0; i < values.length; ++i) {
            dropDown.append("<option value=\"" + values[i] + "\"");
            if (values[i].equals(value)) {
                dropDown.append(" selected>");
            } else {
                dropDown.append(">");
            }
            dropDown.append(values[i]);
            dropDown.append("</option>");
        }
        dropDown.append("</select></td>");
        return dropDown.toString();
    }

    public String printCheckboxSkipName(String name, String widget, String value) {
        if (Boolean.toString(true).equals(value)) {
            return "<td><input type=\"checkbox\" checked=\"checked\" name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" value=\"true\" /></td>";
        }
        return "<td><input type=\"checkbox\" name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\" value=\"true\" /></td>";
    }

    public String printOptionText(String label, String name, String[] values, String widget, String option, String text, boolean isURL, String urlTemplate, boolean isPath, HttpServletRequest request) {
        StringBuilder dropDown = new StringBuilder();
        dropDown.append("<tr><td class=\"leftCol\"><select name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\">");
        for (int i = 0; i < values.length; ++i) {
            dropDown.append("<option value=\"" + values[i] + "\"");
            if (values[i].equals(option)) {
                dropDown.append(" selected>");
            } else {
                dropDown.append(">");
            }
            dropDown.append(values[i]);
            dropDown.append("</option>");
        }
        dropDown.append("</select></td>");
        String id = "id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-");
        if (isURL) {
            String selectResource = "";
            String selectResourceButton = "$('" + id + "_button').style.display='';";
            if (isPath) {
                selectResource = " <input style=\"display:none\" id=\"" + id + "_button\" type=\"button\" class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" onclick=\"showGovernanceResourceTree('" + id + "');\"/>";
            }
            String div = "<div id=\"" + id + "_link\"><a target=\"_blank\" href=\"" + (isPath ? "../resources/resource.jsp?region=region3&item=resource_browser_menu&path=/_system/governance" : "") + (urlTemplate != null ? urlTemplate.replace("@{value}", text) : text) + "\">" + text + "</a>" + "&nbsp;<a onclick=\"$('" + id + "_link').style.display='none';$('" + id + "')." + "style.display='';" + (isPath ? selectResourceButton : "") + "\" title=\"" + CarbonUIUtil.geti18nString((String)"edit", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" " + "class=\"icon-link\" style=\"background-image: url('../admin/images/edit.gif');float: none\"></a></div>";
            dropDown.append("<td>" + div + "<input style=\"display:none\" type=\"text\" name=\"" + widget.replaceAll(" ", "_") + "text" + "_" + name.replaceAll(" ", "-") + "\" value=\"" + text + "\" id=\"" + id + "\" style=\"width:400px\"/>" + (isPath ? selectResource : "") + "</td>");
        } else {
            String selectResource = "";
            if (isPath) {
                selectResource = " <input type=\"button\" class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" onclick=\"showGovernanceResourceTree('" + id + "');\"/>";
            }
            dropDown.append("<td width=500px><input type=\"text\" name=\"" + widget.replaceAll(" ", "_") + "text" + "_" + name.replaceAll(" ", "-") + "\" value=\"" + text + "\" id=\"" + id + "\" style=\"width:" + "400" + "px\"/>" + (isPath ? selectResource : "") + "</td>");
        }
        dropDown.append("<td><a class=\"icon-link\" title=\"delete\" onclick=\"delete" + name.replaceAll(" ", "-") + "_" + widget.replaceAll(" ", "_") + "(this.parentNode.parentNode.rowIndex)\" style=\"background-image:url(../admin/images/delete.gif);\">Delete</a></td>");
        dropDown.append("</tr>");
        return dropDown.toString();
    }

    public String printOptionTextWithId(String originalName, int index, String[] values, String widget, String option, String text, boolean isURL, String urlTemplate, boolean isPath, HttpServletRequest request) {
        String name = originalName + index;
        StringBuilder dropDown = new StringBuilder();
        dropDown.append("<tr><td class=\"leftCol\"><select name=\"" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + "\">");
        String id = "id_" + widget.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-");
        for (int i = 0; i < values.length; ++i) {
            dropDown.append("<option value=\"" + values[i] + "\"");
            if (values[i].equals(option)) {
                dropDown.append(" selected>");
            } else {
                dropDown.append(">");
            }
            dropDown.append(values[i]);
            dropDown.append("</option>");
        }
        dropDown.append("</select></td>");
        if (isURL) {
            String selectResource = "";
            String selectResourceButton = "$('" + id + "_button').style.display='';";
            if (isPath) {
                selectResource = " <input style=\"display:none\" id=\"" + id + "_button\" type=\"button\" class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" onclick=\"showGovernanceResourceTree('" + id + "');\"/>";
            }
            String div = "<div id=\"" + id + "_link\"><a target=\"_blank\" href=\"" + (isPath ? "../resources/resource.jsp?region=region3&item=resource_browser_menu&path=/_system/governance" : "") + (urlTemplate != null ? urlTemplate.replace("@{value}", text) : text) + "\">" + text + "</a>" + "&nbsp;<a onclick=\"$('" + id + "_link').style.display='none';$('" + id + "')." + "style.display='';" + (isPath ? selectResourceButton : "") + "\" title=\"" + CarbonUIUtil.geti18nString((String)"edit", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" " + "class=\"icon-link\" style=\"background-image: url('../admin/images/edit.gif');float: none\"></a></div>";
            dropDown.append("<td>" + div + "<input style=\"display:none\" type=\"text\" name=\"" + widget.replaceAll(" ", "_") + "text" + "_" + name.replaceAll(" ", "-") + "\" value=\"" + text + "\" id=\"" + id + "\" style=\"width:400px\"/>" + (isPath ? selectResource : "") + "</td>");
        } else {
            String selectResource = "";
            if (isPath) {
                selectResource = " <input type=\"button\" class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" onclick=\"showGovernanceResourceTree('" + id + "');\"/>";
            }
            dropDown.append("<td width=500px><input type=\"text\" name=\"" + widget.replaceAll(" ", "_") + "text" + "_" + name.replaceAll(" ", "-") + "\" value=\"" + text + "\" id=\"" + id + "\" style=\"width:400px\"/>" + (isPath ? selectResource : "") + "</td>");
        }
        dropDown.append("<td><a class=\"icon-link\" title=\"delete\" onclick=\"delete" + originalName.replaceAll(" ", "-") + "_" + widget.replaceAll(" ", "_") + "(this.parentNode.parentNode.rowIndex)\" style=\"background-image:url(../admin/images/delete.gif);\">Delete</a></td>");
        dropDown.append("</tr>");
        return dropDown.toString();
    }

    public String printAddLink(String label, String name, String addIconPath, String widget, String[] subList, boolean isPath) {
        StringBuilder link = new StringBuilder();
        link.append("<tr><td colspan=\"3\"><a class=\"icon-link\" style=\"background-image: url(");
        link.append(addIconPath);
        link.append(");\" onclick=\"");
        link.append("add" + name.replaceAll(" ", "-") + "_" + widget.replaceAll(" ", "_") + "(" + (isPath ? "'path'" : "") + ")\">");
        link.append("Add " + label.replaceAll(" ", "-"));
        link.append("</a></td></tr>");
        link.append("<tr><td colspan=\"3\">");
        link.append("<table class=\"styledLeft\" style=\"display:none;border: 1px solid rgb(204, 204, 204) ! important;\"><thead>" + this.printSubHeaders(subList) + "</thead><tbody id=\"" + name.replaceAll(" ", "-") + "Mgt\">");
        return link.toString();
    }

    public String printAddLinkWithDisplay(String label, String name, String addIconPath, String widget, String[] subList, boolean isPath) {
        StringBuilder link = new StringBuilder();
        link.append("<tr><td colspan=\"3\"><a class=\"icon-link\" style=\"background-image: url(");
        link.append(addIconPath);
        link.append(");\" onclick=\"");
        link.append("add" + name.replaceAll(" ", "-") + "_" + widget.replaceAll(" ", "_") + "(" + (isPath ? "'path'" : "") + ")\">");
        link.append("Add " + label.replaceAll(" ", "-"));
        link.append("</a></td></tr>");
        link.append("<tr><td colspan=\"3\">");
        link.append("<table class=\"styledLeft\" style=\"border: 1px solid rgb(204, 204, 204) ! important;\"><thead>" + this.printSubHeaders(subList) + "</thead><tbody id=\"" + name.replaceAll(" ", "-") + "Mgt\">");
        return link.toString();
    }

    public String printCloseAddLink(String name, int count) {
        StringBuilder link = new StringBuilder();
        link.append("</tbody></table>");
        link.append("<input id=\"" + name.replaceAll(" ", "-") + "CountTaker\" type=\"hidden\" value=\"" + count + "\" name=\"");
        link.append(name.replaceAll(" ", "-") + "Count" + "\"/>\n");
        link.append("</td></tr>");
        return link.toString();
    }

    public OMElement getDataFromUI(OMElement head, HttpServletRequest request) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace namespace = fac.createOMNamespace(this.dataNamespace, "");
        OMElement data = fac.createOMElement(this.dataElement, namespace);
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            String widgetName = widget.getAttributeValue(new QName(null, "name"));
            OMElement widgetData = fac.createOMElement(AddServicesUtil.getDataElementName(widgetName), namespace);
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                String input;
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName())) continue;
                String elementType = arg.getAttributeValue(new QName(null, "type"));
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                if ("option-text".equals(elementType)) {
                    String inputOption;
                    if ("unbounded".equals(arg.getAttributeValue(new QName(null, "maxoccurs")))) {
                        String count = request.getParameter(name.replaceAll(" ", "-") + "Count");
                        for (int i = 0; i < Integer.parseInt(count); ++i) {
                            String entryValue = "";
                            String input2 = request.getParameter(widgetName.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-") + (i + 1));
                            if (input2 != null && !"".equals(input2) && !"None".equals(input2)) {
                                entryValue = entryValue + input2;
                            }
                            entryValue = entryValue + ":";
                            String inputTextValue = request.getParameter(widgetName.replaceAll(" ", "_") + "text" + "_" + name.replaceAll(" ", "-") + (i + 1));
                            if (inputTextValue != null && !"".equals(inputTextValue)) {
                                entryValue = entryValue + inputTextValue;
                            }
                            if (":".equals(entryValue)) continue;
                            OMElement entryElement = fac.createOMElement("entry", namespace);
                            entryElement.setText(entryValue);
                            widgetData.addChild((OMNode)entryElement);
                        }
                        continue;
                    }
                    input = request.getParameter(widgetName.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-"));
                    if (input != null && !"".equals(input) && !"None".equals(input)) {
                        OMElement text = fac.createOMElement(AddServicesUtil.getDataElementName(name), namespace);
                        text.setText(input);
                        widgetData.addChild((OMNode)text);
                    }
                    if ((inputOption = request.getParameter(widgetName.replaceAll(" ", "_") + "text" + "_" + name.replaceAll(" ", "-"))) == null || "".equals(inputOption)) continue;
                    OMElement value = fac.createOMElement(AddServicesUtil.getDataElementName("text" + name), namespace);
                    value.setText(inputOption);
                    widgetData.addChild((OMNode)value);
                    continue;
                }
                input = request.getParameter(widgetName.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-"));
                OMElement text = null;
                if (input != null && !"".equals(input) && !"None".equals(input)) {
                    text = fac.createOMElement(AddServicesUtil.getDataElementName(name), namespace);
                    text.setText(input);
                    widgetData.addChild((OMNode)text);
                    continue;
                }
                if (!name.equals("Name")) continue;
                text = fac.createOMElement(AddServicesUtil.getDataElementName(name), namespace);
                text.setText("C0E6D4A8-C446-4f01-99DB-70E212685A40");
                widgetData.addChild((OMNode)text);
            }
            data.addChild((OMNode)widgetData);
        }
        return AddServicesUtil.addExtraElements(data, request);
    }

    public String[] getMandatoryIdList(OMElement head) {
        ArrayList<String> id = new ArrayList<String>();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            String widgetName = widget.getAttributeValue(new QName(null, "name"));
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName())) continue;
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                if (arg.getAttributeValue(new QName(null, "required")) == null) continue;
                id.add("id_" + widgetName.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-"));
            }
        }
        return id.toArray(new String[id.size()]);
    }

    public String[] getMandatoryNameList(OMElement head) {
        ArrayList<String> name = new ArrayList<String>();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName())) continue;
                String name_element = arg.getFirstChildWithName(new QName(null, "name")).getText();
                if (arg.getAttributeValue(new QName(null, "required")) == null) continue;
                name.add(name_element);
            }
        }
        return name.toArray(new String[name.size()]);
    }

    public String[] getUnboundedNameList(OMElement head) {
        ArrayList<String> name = new ArrayList<String>();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName()) || !"option-text".equals(arg.getAttributeValue(new QName(null, "type"))) || !"unbounded".equals(arg.getAttributeValue(new QName(null, "maxoccurs")))) continue;
                name.add(arg.getFirstChildWithName(new QName(null, "name")).getText());
            }
        }
        return name.toArray(new String[name.size()]);
    }

    public String[] getUnboundedWidgetList(OMElement head) {
        ArrayList<String> widgetList = new ArrayList<String>();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName()) || !"option-text".equals(arg.getAttributeValue(new QName(null, "type"))) || !"unbounded".equals(arg.getAttributeValue(new QName(null, "maxoccurs")))) continue;
                widgetList.add(widget.getAttributeValue(new QName(null, "name")));
            }
        }
        return widgetList.toArray(new String[widgetList.size()]);
    }

    public String[][] getUnboundedValues(OMElement head, HttpServletRequest request, ServletConfig config) {
        ArrayList<String[]> values = new ArrayList<String[]>();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName()) || !"option-text".equals(arg.getAttributeValue(new QName(null, "type"))) || !"unbounded".equals(arg.getAttributeValue(new QName(null, "maxoccurs")))) continue;
                List<String> inner = this.getOptionValues(arg, request, config);
                values.add(inner.toArray(new String[inner.size()]));
            }
        }
        return (String[][])values.toArray((T[])new String[0][0]);
    }

    private List<String> getOptionValues(OMElement arg, HttpServletRequest request, ServletConfig config) {
        OMElement values = arg.getFirstChildWithName(new QName(null, "values"));
        Iterator iterator = values.getChildrenWithLocalName("value");
        ArrayList<String> inner = new ArrayList<String>();
        if (iterator != null && iterator.hasNext()) {
            while (iterator.hasNext()) {
                inner.add(((OMElement)iterator.next()).getText());
            }
            return inner;
        }
        try {
            String className = values.getAttributeValue(new QName(null, "class"));
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> populatorClass = Class.forName(className, true, loader);
            DropDownDataPopulator populator = (DropDownDataPopulator)populatorClass.newInstance();
            String[] list = populator.getList(request, config);
            return new ArrayList<String>(Arrays.asList(list));
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Unable to load populator class", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)"Unable to load populator class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Unable to load populator class", (Throwable)e);
        }
        return inner;
    }
}

