/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.services.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.services.stub.AddServicesServiceStub;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class AddServicesServiceClient {
    private static final Log log = LogFactory.getLog(AddServicesServiceClient.class);
    private AddServicesServiceStub stub;
    private String epr;

    public AddServicesServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "AddServicesService";
        try {
            this.stub = new AddServicesServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate AddServices service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public AddServicesServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "AddServicesService";
        try {
            this.stub = new AddServicesServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate Add Services service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public String editService(String path) throws Exception {
        return this.stub.editService(path);
    }

    public String addService(String serviceContent) throws Exception {
        return this.stub.addService(serviceContent);
    }

    public String getServiceConfiguration() throws Exception {
        return this.stub.getServiceConfiguration();
    }

    public boolean saveServiceConfiguration(String content) throws Exception {
        return this.stub.saveServiceConfiguration(content);
    }

    public String getServicePath() throws Exception {
        return this.stub.getServicePath();
    }

    public boolean canChange(String path) throws Exception {
        return this.stub.canChange(path);
    }

    public String[] getAvailableAspects() throws Exception {
        return this.stub.getAvailableAspects();
    }

    public boolean validateXMLConfigOnSchema(String xml, String schema) throws Exception {
        return this.stub.validateXMLConfigOnSchema(xml, schema);
    }
}

