/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.services.ui.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.services.ui.clients.AddServicesServiceClient;
import org.wso2.carbon.governance.services.ui.utils.AddServiceUIGenerator;
import org.wso2.carbon.registry.common.ui.UIException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.resource.stub.beans.xsd.CollectionContentBean;
import org.wso2.carbon.registry.resource.ui.Utils;
import org.wso2.carbon.registry.resource.ui.clients.ResourceServiceClient;
import org.wso2.carbon.ui.CarbonUIUtil;

public class AddServicesUtil {
    private static final Log log = LogFactory.getLog(AddServicesUtil.class);

    public static String addServiceContent(OMElement info, HttpServletRequest request, ServletConfig config, HttpSession session) throws UIException {
        try {
            AddServicesServiceClient serviceClient = new AddServicesServiceClient(config, session);
            OMElement filledService = new AddServiceUIGenerator().getDataFromUI(info, request);
            String newServicePath = request.getParameter("path");
            if (newServicePath != null) {
                filledService.build();
                OMFactory fac = OMAbstractFactory.getOMFactory();
                Iterator it = filledService.getChildrenWithLocalName("newServicePath");
                if (it.hasNext()) {
                    if (it.hasNext()) {
                        OMElement next = (OMElement)it.next();
                        next.setText(newServicePath);
                    }
                } else {
                    OMElement operation = fac.createOMElement("newServicePath", filledService.getNamespace(), (OMContainer)filledService);
                    operation.setText(newServicePath);
                }
            }
            return serviceClient.addService(filledService.toString());
        }
        catch (Exception e) {
            String msg = "Failed to get service details. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static String getServicePath(ServletConfig config, HttpSession session) throws Exception {
        AddServicesServiceClient serviceClient = new AddServicesServiceClient(config, session);
        return serviceClient.getServicePath();
    }

    public static String getGreatestChildVersion(ServletConfig config, HttpSession session, String path) throws Exception {
        String[] nodes = Utils.getSortedChildNodes((CollectionContentBean)new ResourceServiceClient(config, session).getCollectionContent(path));
        String last = "";
        for (String node : nodes) {
            String name = RegistryUtils.getResourceName((String)node);
            try {
                Integer.parseInt(name);
                last = name;
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return last;
    }

    public static int[] getAdjacentVersions(ServletConfig config, HttpSession session, String path, int current) throws Exception {
        String[] nodes = Utils.getSortedChildNodes((CollectionContentBean)new ResourceServiceClient(config, session).getCollectionContent(path));
        int[] versions = new int[]{-1, -1};
        int previous = -1;
        for (String node : nodes) {
            String name = RegistryUtils.getResourceName((String)node);
            try {
                int temp = Integer.parseInt(name);
                if (previous == current) {
                    versions[1] = temp;
                    break;
                }
                if (temp == current) {
                    versions[0] = previous;
                }
                previous = temp;
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return versions;
    }

    public static String getUniqueNameForNamespaceToRedirect(String commonSchemaLocation, String targetNamespace1) {
        String targetNamespace = targetNamespace1.replaceAll("\\s+$", "");
        targetNamespace = targetNamespace.replace("://", "/");
        targetNamespace = targetNamespace.replace(".", "/");
        String resourcePath = commonSchemaLocation.endsWith("/") ? commonSchemaLocation + targetNamespace : commonSchemaLocation + "/" + targetNamespace;
        if (!targetNamespace.endsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        return resourcePath;
    }

    public static String getServiceConfiguration(HttpSession session, ServletConfig config) throws Exception {
        AddServicesServiceClient serviceClient = new AddServicesServiceClient(config, session);
        return serviceClient.getServiceConfiguration();
    }

    public static String getNamespaceFromContent(OMElement head) {
        OMElement overview = head.getFirstChildWithName(new QName("Overview"));
        if (overview != null) {
            return overview.getFirstChildWithName(new QName("Namespace")).getText();
        }
        overview = head.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "namespace")).getText();
        }
        return null;
    }

    public static String getNameFromContent(OMElement head) {
        OMElement overview = head.getFirstChildWithName(new QName("Overview"));
        if (overview != null) {
            return overview.getFirstChildWithName(new QName("Name")).getText();
        }
        overview = head.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview"));
        if (overview != null) {
            return overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "name")).getText();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMElement getUIConfiguration(String filePath) {
        InputStream stream = AddServiceUIGenerator.class.getResourceAsStream(filePath);
        try {
            StAXOMBuilder builder = null;
            OMElement omElement = null;
            try {
                builder = new StAXOMBuilder(stream);
                omElement = builder.getDocumentElement();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            OMElement oMElement = omElement;
            return oMElement;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ignore) {}
        }
    }

    public static OMElement addExtraElements(OMElement data, HttpServletRequest request) {
        String namespace;
        String name;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement operation = fac.createOMElement("operation", null);
        OMElement currentName = fac.createOMElement("currentName", null);
        OMElement currentNamespace = fac.createOMElement("currentNamespace", null);
        String operationValue = request.getParameter("operation");
        if (operationValue != null) {
            operation.setText(operationValue);
            data.addChild((OMNode)operation);
        }
        if ((name = request.getParameter("currentname")) != null) {
            currentName.setText(name);
            data.addChild((OMNode)currentName);
        }
        if ((namespace = request.getParameter("currentnamespace")) != null) {
            currentNamespace.setText(namespace);
            data.addChild((OMNode)currentNamespace);
        }
        return data;
    }

    public static OMElement loadAddedServiceContent(String xmlContent) throws Exception {
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xmlContent));
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        return builder.getDocumentElement();
    }

    public static String getDataElementName(String widgetName) {
        if (widgetName == null || widgetName.length() == 0) {
            return null;
        }
        String[] nameParts = widgetName.split("_");
        String convertedName = null;
        for (String namePart : nameParts) {
            char c;
            int i;
            for (i = 0; i < namePart.length() && Character.isLetter(c = namePart.charAt(i)) && !Character.isLowerCase(c); ++i) {
            }
            namePart = namePart.substring(0, i).toLowerCase() + namePart.substring(i);
            convertedName = convertedName == null ? namePart : convertedName + "_" + namePart;
        }
        if (convertedName == null) {
            return null;
        }
        return convertedName.replaceAll(" ", "").replaceAll("-", "");
    }

    public static OMElement getChildWithName(OMElement head, String widgetName, String namespace) {
        String adjustedName = AddServicesUtil.getDataElementName(widgetName);
        if (adjustedName == null) {
            return null;
        }
        OMElement child = head.getFirstChildWithName(new QName(namespace, adjustedName));
        if (child == null) {
            child = head.getFirstChildWithName(new QName(null, widgetName.replaceAll(" ", "-")));
        }
        return child;
    }

    public static String decorateVersionElement(String version, String basicVersionElement, String path, String type, String append, String screenWidth, ServletConfig config, HttpSession session, HttpServletRequest request) {
        String hrefPrefix = "../resources/resource.jsp?region=region3&item=resource_browser_menu&path=";
        String hrefPostfix = screenWidth != null ? "&screenWidth=" + screenWidth : "";
        String patchPath = RegistryUtils.getParentPath((String)path);
        String minorPath = RegistryUtils.getParentPath((String)patchPath);
        String majorPath = RegistryUtils.getParentPath((String)minorPath);
        String servicePath = RegistryUtils.getParentPath((String)majorPath);
        String[] versions = version.split("[.]");
        StringBuffer sb = new StringBuffer("$1type=\"hidden\"$2");
        if (type.equals("collection")) {
            sb.append("<a href=\"").append(hrefPrefix).append(majorPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[0]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"").append(hrefPrefix).append(minorPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[1]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"").append(hrefPrefix).append(patchPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[2]).append("</a>");
            sb.append(append);
        } else if (type.equals("patch")) {
            sb.append("<a href=\"").append(hrefPrefix).append(majorPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[0]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"").append(hrefPrefix).append(minorPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[1]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"javascript:void(0)\">").append(versions[2]).append("</a>");
            sb.append(append);
            try {
                int[] adjacentVersions = AddServicesUtil.getAdjacentVersions(config, session, minorPath, Integer.parseInt(versions[2]));
                sb.append("&nbsp;");
                if (adjacentVersions[0] > -1) {
                    sb.append("<a class=\"icon-link\" style=\"background-image: ").append("url(../resources/images/arrow-up.gif);float:none !important;").append("margin-bottom:0px !important;margin-top:0px !important;").append("margin-left:0px !important\" href=\"").append(hrefPrefix).append(minorPath.replaceAll("&", "%26")).append(hrefPostfix).append("/").append(adjacentVersions[0]).append("\" title=\"").append(CarbonUIUtil.geti18nString((String)"previous.version", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale())).append(": ").append(versions[0]).append(".").append(versions[1]).append(".").append(adjacentVersions[0]).append("\"/>");
                }
                if (adjacentVersions[1] > -1) {
                    sb.append("<a class=\"icon-link\" style=\"background-image: ").append("url(../resources/images/arrow-right.gif);float:none !important;").append("margin-bottom:0px !important;margin-top:0px !important;").append("margin-left:0px !important\" href=\"").append(hrefPrefix).append(minorPath.replaceAll("&", "%26")).append(hrefPostfix).append("/").append(adjacentVersions[1]).append("\" title=\"").append(CarbonUIUtil.geti18nString((String)"next.version", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale())).append(": ").append(versions[0]).append(".").append(versions[1]).append(".").append(adjacentVersions[1]).append("\"/>");
                }
            }
            catch (Exception ignore) {}
        } else if (type.equals("minor")) {
            sb.append("<a href=\"").append(hrefPrefix).append(majorPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[0]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"javascript:void(0)\">").append(versions[1]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"").append(hrefPrefix).append(patchPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[2]).append("</a>");
            sb.append(append);
            try {
                String latestPatch;
                int[] adjacentVersions = AddServicesUtil.getAdjacentVersions(config, session, majorPath, Integer.parseInt(versions[1]));
                sb.append("&nbsp;");
                if (adjacentVersions[0] > -1) {
                    latestPatch = AddServicesUtil.getGreatestChildVersion(config, session, majorPath + "/" + adjacentVersions[0]);
                    sb.append("<a class=\"icon-link\" style=\"background-image: ").append("url(../resources/images/arrow-up.gif);float:none !important;").append("margin-bottom:0px !important;margin-top:0px !important;").append("margin-left:0px !important\" href=\"").append(hrefPrefix).append(majorPath.replaceAll("&", "%26")).append(hrefPostfix).append("/").append(adjacentVersions[0]).append("\" title=\"").append(CarbonUIUtil.geti18nString((String)"previous.version", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale())).append(": ").append(versions[0]).append(".").append(adjacentVersions[0]).append(".").append(latestPatch).append("\"/>");
                }
                if (adjacentVersions[1] > -1) {
                    latestPatch = AddServicesUtil.getGreatestChildVersion(config, session, majorPath + "/" + adjacentVersions[1]);
                    sb.append("<a class=\"icon-link\" style=\"background-image: ").append("url(../resources/images/arrow-right.gif);float:none !important;").append("margin-bottom:0px !important;margin-top:0px !important;").append("margin-left:0px !important\" href=\"").append(hrefPrefix).append(majorPath.replaceAll("&", "%26")).append(hrefPostfix).append("/").append(adjacentVersions[1]).append("\" title=\"").append(CarbonUIUtil.geti18nString((String)"next.version", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale())).append(": ").append(versions[0]).append(".").append(adjacentVersions[1]).append(".").append(latestPatch).append("\"/>");
                }
            }
            catch (Exception ignore) {}
        } else if (type.equals("major")) {
            sb.append("<a href=\"javascript:void(0)\">").append(versions[0]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"").append(hrefPrefix).append(minorPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[1]).append("</a>");
            sb.append(".");
            sb.append("<a href=\"").append(hrefPrefix).append(patchPath.replaceAll("&", "%26")).append(hrefPostfix).append("\">").append(versions[2]).append("</a>");
            sb.append(append);
            try {
                String latestPatch;
                String latestMinor;
                int[] adjacentVersions = AddServicesUtil.getAdjacentVersions(config, session, servicePath, Integer.parseInt(versions[0]));
                sb.append("&nbsp;");
                if (adjacentVersions[0] > -1) {
                    latestMinor = AddServicesUtil.getGreatestChildVersion(config, session, servicePath + "/" + adjacentVersions[0]);
                    latestPatch = AddServicesUtil.getGreatestChildVersion(config, session, servicePath + "/" + adjacentVersions[0] + "/" + latestMinor);
                    sb.append("<a class=\"icon-link\" style=\"background-image: ").append("url(../resources/images/arrow-up.gif);float:none !important;").append("margin-bottom:0px !important;margin-top:0px !important;").append("margin-left:0px !important\" href=\"").append(hrefPrefix).append(servicePath.replaceAll("&", "%26")).append(hrefPostfix).append("/").append(adjacentVersions[0]).append("\" title=\"").append(CarbonUIUtil.geti18nString((String)"previous.version", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale())).append(": ").append(adjacentVersions[0]).append(".").append(latestMinor).append(".").append(latestPatch).append("\"/>");
                }
                if (adjacentVersions[1] > -1) {
                    latestMinor = AddServicesUtil.getGreatestChildVersion(config, session, servicePath + "/" + adjacentVersions[1]);
                    latestPatch = AddServicesUtil.getGreatestChildVersion(config, session, servicePath + "/" + adjacentVersions[1] + "/" + latestMinor);
                    sb.append("<a class=\"icon-link\" style=\"background-image: ").append("url(../resources/images/arrow-right.gif);float:none !important;").append("margin-bottom:0px !important;margin-top:0px !important;").append("margin-left:0px !important\" href=\"").append(hrefPrefix).append(servicePath.replaceAll("&", "%26")).append(hrefPostfix).append("/").append(adjacentVersions[1]).append("\" title=\"").append(CarbonUIUtil.geti18nString((String)"next.version", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale())).append(": ").append(adjacentVersions[1]).append(".").append(latestMinor).append(".").append(latestPatch).append("\"/>");
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return basicVersionElement.replaceAll("(<input[^>]*)type=\"text\"([^>]*id=\"id_Overview_Version\"[^>]*>)", sb.toString());
    }
}

