/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.services.services;

import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.services.ServiceFilter;
import org.wso2.carbon.governance.api.services.ServiceManager;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.services.util.Util;
import org.wso2.carbon.registry.admin.api.governance.IManageServicesService;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class AddServicesService
extends RegistryAbstractAdmin
implements IManageServicesService {
    private static final Log log = LogFactory.getLog(AddServicesService.class);
    private static Map<String, Boolean> lifecycleAspects = new HashMap<String, Boolean>();
    private static final String TRUNK = "trunk";

    public String addService(String info) throws RegistryException {
        RegistryUtils.recordStatistics((Object[])new Object[]{info});
        Registry registry = this.getGovernanceRegistry();
        String currentPath = "";
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return currentPath;
        }
        try {
            String currentNamespace;
            String currentName;
            String operation;
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(info));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement serviceElement = builder.getDocumentElement();
            OMElement operationElement = serviceElement.getFirstChildWithName(new QName("operation"));
            if (operationElement != null) {
                operation = operationElement.getText();
                operationElement.detach();
            } else {
                operation = "Add";
            }
            OMElement currentNameElement = serviceElement.getFirstChildWithName(new QName("currentName"));
            if (currentNameElement != null && !(currentName = currentNameElement.getText()).equals("")) {
                currentNameElement.detach();
            } else {
                currentName = CommonUtil.getServiceName((OMElement)serviceElement);
            }
            OMElement currentNamespaceElement = serviceElement.getFirstChildWithName(new QName("currentNamespace"));
            if (currentNamespaceElement != null && !(currentNamespace = currentNamespaceElement.getText()).equals("")) {
                currentNamespaceElement.detach();
            } else {
                currentNamespace = CommonUtil.getServiceNamespace((OMElement)serviceElement);
            }
            ServiceManager serviceManager = new ServiceManager(registry);
            Service service = serviceManager.newService(serviceElement);
            if ("Edit".equals(operation)) {
                if (serviceElement.getChildrenWithLocalName("newServicePath").hasNext()) {
                    Iterator OmElementIterator = serviceElement.getChildrenWithLocalName("newServicePath");
                    if (OmElementIterator.hasNext()) {
                        OMElement next = (OMElement)OmElementIterator.next();
                        currentPath = next.getText();
                    }
                } else {
                    currentPath = registry.getRegistryContext().getServicePath() + CommonUtil.derivePathFragmentFromNamespace((String)currentNamespace) + currentName;
                }
                currentPath = RegistryUtils.getRelativePathToOriginal((String)currentPath, (String)"/_system/governance");
                if (registry.resourceExists(currentPath)) {
                    GovernanceArtifact oldArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath((Registry)registry, (String)currentPath);
                    Resource oldResource = registry.get(currentPath);
                    if (!(oldArtifact instanceof Service)) {
                        String msg = "The updated path is occupied by a non-service. path: " + currentPath + ".";
                        log.error((Object)msg);
                        throw new Exception(msg);
                    }
                    String id = oldArtifact.getId();
                    service.setId(id);
                    serviceManager.updateService(service);
                    Resource newResource = registry.get(currentPath);
                    Properties properties = oldResource.getProperties();
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        if (newResource.getProperty((String)entry.getKey()) != null) continue;
                        if (entry.getValue() instanceof List) {
                            newResource.setProperty((String)entry.getKey(), (List)entry.getValue());
                            continue;
                        }
                        newResource.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                    newResource.setDescription(oldResource.getDescription());
                    registry.put(service.getPath(), newResource);
                    return currentPath;
                }
            }
            currentPath = registry.getRegistryContext().getServicePath() + CommonUtil.derivePathFragmentFromNamespace((String)currentNamespace) + currentName;
            currentPath = RegistryUtils.getRelativePathToOriginal((String)currentPath, (String)"/_system/governance");
            final String ref_overview_name = service.getAttribute("overview_name");
            final String ref_overview_version = service.getAttribute("overview_version");
            final String ref_overview_namespace = service.getAttribute("overview_namespace");
            Service[] result_services = serviceManager.findServices(new ServiceFilter(){

                public boolean matches(Service _service) throws GovernanceException {
                    String _overview_name = _service.getAttribute("overview_name");
                    String _overview_version = _service.getAttribute("overview_version");
                    String _overview_namespace = _service.getAttribute("overview_namespace");
                    return _overview_name != null && _overview_name.equals(ref_overview_name) && _overview_version != null && _overview_version.equals(ref_overview_version) && _overview_namespace != null && _overview_namespace.equals(ref_overview_namespace);
                }
            });
            if (registry.resourceExists(currentPath)) {
                String msg = "A resource with the given name and namespace exists";
                log.warn((Object)msg);
                return msg;
            }
            if (result_services.length > 0) {
                String msg = "A resource with the given name and namespace exists";
                log.warn((Object)msg);
                return msg;
            }
            serviceManager.addService(service);
        }
        catch (Exception e) {
            String msg = "Unable to add service. ";
            if (e instanceof RegistryException) {
                throw (RegistryException)e;
            }
            if (e instanceof OMException) {
                msg = msg + "Unexpected character found in input-field name.";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
            throw new RegistryException(msg + (e.getCause() instanceof SQLException ? "" : e.getCause().getMessage()), (Throwable)e);
        }
        return currentPath;
    }

    public String editService(String servicename) throws RegistryException {
        String path;
        Registry registry = this.getGovernanceRegistry();
        if (!registry.resourceExists(new ResourcePath(path = servicename).getPath())) {
            if (Boolean.parseBoolean(this.getRootRegistry().get(servicename).getProperty("registry.link"))) {
                return RegistryUtils.decodeBytes((byte[])((byte[])this.getRootRegistry().get(servicename).getContent()));
            }
            throw new RegistryException("Resource does not exist path : " + path);
        }
        Resource resource = registry.get(path);
        return RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
    }

    public String getServiceConfiguration() throws RegistryException {
        try {
            Registry registry = this.getConfigSystemRegistry();
            return Util.getServiceConfig(registry);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean saveServiceConfiguration(String update) throws RegistryException {
        Registry registry = this.getConfigSystemRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        try {
            Util.validateOMContent(Util.buildOMElement(update));
            Resource resource = registry.get("/repository/components/org.wso2.carbon.governance/configuration/services/service");
            resource.setContent((Object)update);
            registry.put("/repository/components/org.wso2.carbon.governance/configuration/services/service", resource);
            return true;
        }
        catch (Exception RegistryException2) {
            return false;
        }
    }

    public String getServicePath() throws RegistryException {
        try {
            Registry registry = this.getGovernanceRegistry();
            return registry.getRegistryContext().getServicePath();
        }
        catch (Exception RegistryException2) {
            return null;
        }
    }

    public boolean canChange(String path) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (registry.getUserName() != null && registry.getUserRealm() != null && registry.getUserRealm().getAuthorizationManager().isUserAuthorized(registry.getUserName(), path, "http://www.wso2.org/projects/registry/actions/add")) {
            Resource resource = registry.get(path);
            String property = resource.getProperty("registry.retention.writeLocked");
            return property == null || !Boolean.parseBoolean(property) || registry.getUserName().equals(resource.getProperty("registry.retention.user.name"));
        }
        return false;
    }

    public String[] getAvailableAspects() throws Exception {
        UserRegistry registry = (UserRegistry)this.getGovernanceRegistry();
        Registry systemRegistry = this.getConfigSystemRegistry();
        String[] aspectsToAdd = registry.getAvailableAspects();
        if (aspectsToAdd == null) {
            return new String[0];
        }
        LinkedList<String> lifecycleAspectsToAdd = new LinkedList<String>();
        boolean isTransactionStarted = false;
        String tempResourcePath = "/governance/lcm/" + UUIDGenerator.generateUUID();
        for (String aspectToAdd : aspectsToAdd) {
            if (systemRegistry.getRegistryContext().isReadOnly()) {
                lifecycleAspectsToAdd.add(aspectToAdd);
                continue;
            }
            Boolean isLifecycleAspect = lifecycleAspects.get(aspectToAdd);
            if (isLifecycleAspect == null) {
                if (!isTransactionStarted) {
                    registry.beginTransaction();
                    isTransactionStarted = true;
                }
                systemRegistry.put(tempResourcePath, systemRegistry.newResource());
                systemRegistry.associateAspect(tempResourcePath, aspectToAdd);
                Resource r = systemRegistry.get(tempResourcePath);
                Properties props = r.getProperties();
                Set<Object> keys = props.keySet();
                for (Object key : keys) {
                    String propKey = (String)key;
                    if (!propKey.startsWith("registry.lifecycle.") && !propKey.startsWith("registry.custom_lifecycle.checklist.")) continue;
                    isLifecycleAspect = Boolean.TRUE;
                    break;
                }
                if (isLifecycleAspect == null) {
                    isLifecycleAspect = Boolean.FALSE;
                }
                lifecycleAspects.put(aspectToAdd, isLifecycleAspect);
            }
            if (!isLifecycleAspect.booleanValue()) continue;
            lifecycleAspectsToAdd.add(aspectToAdd);
        }
        if (isTransactionStarted) {
            systemRegistry.delete(tempResourcePath);
            systemRegistry.rollbackTransaction();
        }
        return lifecycleAspectsToAdd.toArray(new String[lifecycleAspectsToAdd.size()]);
    }

    private void removeAspect(Registry registry, String path, String aspect) throws Exception {
        try {
            Resource resource = registry.get(path);
            Properties props = resource.getProperties();
            Iterator<Object> iKeys = props.keySet().iterator();
            ArrayList<String> propertiesToRemove = new ArrayList<String>();
            while (iKeys.hasNext()) {
                String propKey = (String)iKeys.next();
                if (!propKey.startsWith("registry.custom_lifecycle.checklist.") && !propKey.startsWith("registry.LC.name") && !propKey.startsWith("registry.lifecycle.") && !propKey.startsWith("registry.Aspects")) continue;
                propertiesToRemove.add(propKey);
            }
            for (String propertyName : propertiesToRemove) {
                resource.removeProperty(propertyName);
            }
            registry.put(path, resource);
        }
        catch (RegistryException e) {
            String msg = "Failed to remove aspect " + aspect + " on resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

