/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.services.ServiceFilter;
import org.wso2.carbon.governance.api.services.ServiceManager;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.list.beans.ServiceBean;
import org.wso2.carbon.governance.list.util.CommonUtil;
import org.wso2.carbon.governance.list.util.GovernanceArtifactFilter;
import org.wso2.carbon.governance.list.util.PreFetcher;
import org.wso2.carbon.governance.list.util.StringComparatorUtil;
import org.wso2.carbon.governance.list.util.beans.ArtifactInfoBean;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.ServiceUtils;
import org.wso2.carbon.user.core.UserStoreException;

public class ListServiceUtil {
    private static final Log log = LogFactory.getLog(ListServiceUtil.class);
    private static final String REGISTRY_LC_NAME = "registry.LC.name";
    private static int poolSize = 10;
    private static ExecutorService preFetcher;
    private static final Map<String, ArtifactInfoBean> serviceListMap;

    public static Map<String, ArtifactInfoBean> getServiceListMap() {
        return serviceListMap;
    }

    public static String[] filterServices(String criteria, Registry governanceRegistry) throws RegistryException {
        try {
            ServiceManager serviceManger = new ServiceManager(governanceRegistry);
            if (criteria != null) {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(criteria));
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                OMElement referenceServiceElement = builder.getDocumentElement();
                final Service referenceService = serviceManger.newService(referenceServiceElement);
                ServiceFilter listServiceFilter = new ServiceFilter(){
                    GovernanceArtifactFilter filter;
                    {
                        this.filter = new GovernanceArtifactFilter((GovernanceArtifact)referenceService);
                    }

                    public boolean matches(Service service) throws GovernanceException {
                        return this.filter.matches((GovernanceArtifact)service);
                    }
                };
                Service[] services = serviceManger.findServices(listServiceFilter);
                ArrayList<String> servicePaths = new ArrayList<String>();
                if (services != null) {
                    GovernanceUtils.setTenantGovernanceSystemRegistry((int)CarbonContext.getCurrentContext().getTenantId());
                    for (Service service : services) {
                        String path = service.getPath();
                        if (path == null) continue;
                        servicePaths.add(path);
                    }
                    GovernanceUtils.unsetTenantGovernanceSystemRegistry();
                }
                return servicePaths.toArray(new String[servicePaths.size()]);
            }
            return serviceManger.getAllServicePaths();
        }
        catch (Exception ignore) {
            String msg = "Error in filtering the services. " + ignore.getMessage();
            throw new RegistryException(msg);
        }
    }

    public static void startArtifactFetcher(Registry userRegistry) {
        try {
            if (preFetcher == null) {
                preFetcher = Executors.newFixedThreadPool(poolSize);
                Registry governanceRegistry = GovernanceUtils.getGovernanceSystemRegistry((Registry)userRegistry);
                String[] paths = ListServiceUtil.filterServices(null, governanceRegistry);
                int chunkSize = paths.length / poolSize;
                int mod = paths.length % poolSize;
                for (int i = 0; i < poolSize; ++i) {
                    int start = i * chunkSize;
                    int end = start + chunkSize + mod;
                    if (end > paths.length) {
                        end = paths.length;
                    }
                    PreFetcher fetcher = new PreFetcher();
                    fetcher.setGovernanceRegistry(governanceRegistry);
                    fetcher.setPaths(Arrays.copyOfRange(paths, start, end));
                    preFetcher.execute(fetcher);
                }
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to get the list of services from the registry", (Throwable)e);
        }
    }

    public static void stopArtifactFetcher() {
        if (preFetcher != null) {
            preFetcher.shutdown();
        }
    }

    public static void populateServiceInfoMap(Registry governanceRegistry, String[] paths, Map<String, ArtifactInfoBean> listMap) {
        try {
            for (String path : paths) {
                if (listMap.containsKey(path) || !governanceRegistry.resourceExists(path)) continue;
                ArtifactInfoBean bean = new ArtifactInfoBean();
                Resource resource = governanceRegistry.get(path);
                String version = CommonUtil.getVersionFromContent(CommonUtil.buildServiceOMElement(resource));
                bean.setName(CommonUtil.getServiceName(resource));
                bean.setNameSpace(CommonUtil.getServiceNamespace(resource));
                bean.setVersion(version);
                if (resource.getProperty(REGISTRY_LC_NAME) != null) {
                    String lcName = resource.getProperty(REGISTRY_LC_NAME);
                    bean.setLifecycleName(lcName);
                    bean.setLifecycleState(resource.getProperty("registry.lifecycle." + lcName + ".state"));
                }
                listMap.put(path, bean);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to get the resource from the registry", (Throwable)e);
        }
    }

    public static ServiceBean fillServiceBean(UserRegistry registry, String criteria) throws RegistryException {
        String[] path;
        ServiceBean bean = new ServiceBean();
        List modifiedList = ServiceUtils.getModifiedList();
        String defaultServicePath = RegistryUtils.getRelativePathToOriginal((String)registry.getRegistryContext().getServicePath(), (String)"/_system/governance");
        try {
            path = ListServiceUtil.filterServices(criteria, (Registry)registry);
        }
        catch (RegistryException e) {
            log.error((Object)"An error occurred while obtaining the list of services.", (Throwable)e);
            path = new String[]{};
        }
        String[] name = new String[path.length];
        String[] namespace = new String[path.length];
        String[] LCName = new String[path.length];
        String[] LCState = new String[path.length];
        String[] version = new String[path.length];
        boolean[] canDelete = new boolean[path.length];
        for (int i = 0; i < path.length; ++i) {
            ArtifactInfoBean artifactInfoBean;
            bean.increment();
            if (registry.getUserRealm() != null && registry.getUserName() != null) {
                try {
                    canDelete[i] = registry.getUserRealm().getAuthorizationManager().isUserAuthorized(registry.getUserName(), "/_system/governance" + path[i], "http://www.wso2.org/projects/registry/actions/delete");
                }
                catch (UserStoreException e) {
                    canDelete[i] = false;
                }
            } else {
                canDelete[i] = false;
            }
            if (serviceListMap.containsKey(path[i])) {
                if (!modifiedList.contains(path[i])) {
                    artifactInfoBean = serviceListMap.get(path[i]);
                    name[i] = artifactInfoBean.getName();
                    namespace[i] = artifactInfoBean.getNameSpace();
                    version[i] = artifactInfoBean.getVersion();
                    LCName[i] = artifactInfoBean.getLifecycleName() == null ? "" : artifactInfoBean.getLifecycleName();
                    LCState[i] = artifactInfoBean.getLifecycleState() == null ? "" : artifactInfoBean.getLifecycleState();
                    continue;
                }
                modifiedList.remove(path[i]);
            }
            Resource resource = registry.get(path[i]);
            version[i] = CommonUtil.getVersionFromContent(CommonUtil.buildServiceOMElement(resource));
            name[i] = CommonUtil.getServiceName(resource);
            namespace[i] = CommonUtil.getServiceNamespace(resource);
            LCName[i] = CommonUtil.getLifeCycleName(resource);
            LCState[i] = CommonUtil.getLifeCycleState(resource);
            artifactInfoBean = new ArtifactInfoBean();
            artifactInfoBean.setName(name[i]);
            artifactInfoBean.setNameSpace(namespace[i]);
            artifactInfoBean.setLifecycleName(LCName[i]);
            artifactInfoBean.setLifecycleState(LCState[i]);
            artifactInfoBean.setVersion(version[i]);
            serviceListMap.put(path[i], artifactInfoBean);
        }
        bean.setDefaultServicePath(defaultServicePath);
        bean.setNames(name);
        bean.setNamespace(namespace);
        bean.setPath(path);
        bean.setLCName(LCName);
        bean.setLCState(LCState);
        bean.setCanDelete(canDelete);
        bean.setVersion(version);
        ListServiceUtil.sortServicesByName(bean);
        return bean;
    }

    private static void sortServicesByName(ServiceBean bean) {
        int i;
        ArrayList<ServiceEntry> serviceEntryList = new ArrayList<ServiceEntry>();
        for (i = 0; i < bean.getPath().length; ++i) {
            serviceEntryList.add(new ServiceEntry(bean.getPath()[i], bean.getNames()[i], bean.getNamespace()[i], bean.getLCName()[i], bean.getLCState()[i], bean.getVersion()[i], bean.getCanDelete()[i]));
        }
        Collections.sort(serviceEntryList, new Comparator<ServiceEntry>(){

            @Override
            public int compare(ServiceEntry se1, ServiceEntry se2) {
                int res = StringComparatorUtil.compare(se2.name, se1.name);
                if (res != 0) {
                    return res;
                }
                return StringComparatorUtil.compare(se1.version, se2.version);
            }
        });
        i = 0;
        for (ServiceEntry se : serviceEntryList) {
            bean.getPath()[i] = se.path;
            bean.getNames()[i] = se.name;
            bean.getNamespace()[i] = se.namespace;
            bean.getLCName()[i] = se.lcname;
            bean.getLCState()[i] = se.lcstate;
            bean.getCanDelete()[i] = se.canDelete;
            bean.getVersion()[i] = se.version;
            ++i;
        }
    }

    static {
        serviceListMap = Collections.synchronizedMap(new HashMap());
    }

    private static class ServiceEntry {
        private String path;
        private String name;
        private String namespace;
        private String lcname;
        private String lcstate;
        private String version;
        private boolean canDelete;

        ServiceEntry(String path, String name, String namespace, String lcname, String lcstate, String version, boolean canDelete) {
            this.path = path;
            this.name = name;
            this.namespace = namespace;
            this.lcname = lcname;
            this.lcstate = lcstate;
            this.canDelete = canDelete;
            this.version = version;
        }
    }
}

