/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.StringReader;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.utils.CarbonUtils;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);
    private static RegistryService registryService;
    private static ConfigurationContext configurationContext;

    public static synchronized void setRegistryService(RegistryService service) {
        if (registryService == null) {
            registryService = service;
        }
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static ConfigurationContext getConfigurationContext() {
        return configurationContext;
    }

    public static void setConfigurationContext(ConfigurationContext configurationContext) {
        CommonUtil.configurationContext = configurationContext;
    }

    public static String getServiceName(Resource resource) throws RegistryException {
        String serviceInfo = CommonUtil.convertContentToString(resource);
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(serviceInfo));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement serviceInfoElement = builder.getDocumentElement();
            return CommonUtil.getNameFromContent(serviceInfoElement);
        }
        catch (Exception e) {
            String msg = "Error in getting the service name. service path: " + resource.getPath() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public static String getServiceNamespace(Resource resource) throws RegistryException {
        String serviceInfo = CommonUtil.convertContentToString(resource);
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(serviceInfo));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement serviceInfoElement = builder.getDocumentElement();
            return CommonUtil.getNamespaceFromContent(serviceInfoElement);
        }
        catch (Exception e) {
            String msg = "Error in getting the service namespace. service path: " + resource.getPath() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public static String getLifeCycleName(Resource resource) {
        String lifeCycleName = "";
        if (resource.getProperties() != null && resource.getProperty("registry.LC.name") != null) {
            lifeCycleName = resource.getProperty("registry.LC.name");
        }
        return lifeCycleName;
    }

    public static String getLifeCycleState(Resource resource) {
        String LCStatePropertyName;
        String lifeCycleState = "";
        if (resource.getProperties() != null && !CommonUtil.getLifeCycleName(resource).equals("") && resource.getProperty(LCStatePropertyName = "registry.lifecycle." + CommonUtil.getLifeCycleName(resource) + ".state") != null) {
            lifeCycleState = resource.getProperty(LCStatePropertyName);
        }
        return lifeCycleState;
    }

    public static String getResourceName(String path) {
        String[] temp = path.split("/");
        return temp[temp.length - 1];
    }

    public static String getNamespaceFromContent(OMElement head) {
        OMElement overview = head.getFirstChildWithName(new QName("Overview"));
        if (overview != null) {
            return overview.getFirstChildWithName(new QName("Namespace")).getText();
        }
        return head.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview")).getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "namespace")).getText();
    }

    public static String getNameFromContent(OMElement head) {
        OMElement overview = head.getFirstChildWithName(new QName("Overview"));
        if (overview != null) {
            return overview.getFirstChildWithName(new QName("Name")).getText();
        }
        return head.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "overview")).getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "name")).getText();
    }

    public static OMElement buildServiceOMElement(Resource resource) throws RegistryException {
        String serviceInfo = CommonUtil.convertContentToString(resource);
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(serviceInfo));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            return builder.getDocumentElement();
        }
        catch (Exception e) {
            log.error((Object)"Unable to build service OMElement", (Throwable)e);
            return null;
        }
    }

    private static String convertContentToString(Resource resource) throws RegistryException {
        if (resource.getContent() instanceof String) {
            return RegistryUtils.decodeBytes((byte[])((String)resource.getContent()).getBytes());
        }
        if (resource.getContent() instanceof byte[]) {
            return RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
        }
        return RegistryUtils.decodeBytes((byte[])"".getBytes());
    }

    public static String getVersionFromContent(OMElement content) {
        try {
            AXIOMXPath xPath = new AXIOMXPath("//pre:version");
            SimpleNamespaceContext context = new SimpleNamespaceContext();
            context.addNamespace("pre", content.getNamespace().getNamespaceURI());
            xPath.setNamespaceContext((NamespaceContext)context);
            List versionElements = xPath.selectNodes((Object)content);
            if (versionElements != null) {
                for (Object versionElement : versionElements) {
                    OMElement version = (OMElement)versionElement;
                    if (!((OMElement)version.getParent()).getLocalName().equals("overview")) continue;
                    return version.getText();
                }
            }
        }
        catch (JaxenException e) {
            log.error((Object)"Unable to get the version of the service", (Throwable)e);
        }
        return "";
    }

    public static boolean validateXMLConfigOnSchema(String xml, String schema) throws RegistryException {
        String serviceConfPath = "";
        if ("rxt-ui-config".equalsIgnoreCase(schema)) {
            serviceConfPath = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "conf" + File.separator + "rxt.xsd";
        } else if ("lifecycle-config".equalsIgnoreCase(schema)) {
            serviceConfPath = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "conf" + File.separator + "lifecycle-config.xsd";
        }
        return CommonUtil.validateRXTContent(xml, serviceConfPath);
    }

    private static boolean validateRXTContent(String rxtContent, String xsdPath) throws RegistryException {
        try {
            OMElement rxt = CommonUtil.getRXTContentOMElement(rxtContent);
            AXIOMXPath xpath = new AXIOMXPath("//artifactType");
            OMElement c1 = (OMElement)xpath.selectSingleNode((Object)rxt);
            ByteArrayInputStream is = new ByteArrayInputStream(c1.toString().getBytes());
            StreamSource xmlFile = new StreamSource(is);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new File(xsdPath));
            Validator validator = schema.newValidator();
            validator.validate(xmlFile);
        }
        catch (Exception e) {
            log.error((Object)("RXT validation fails due to: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public static OMElement getRXTContentOMElement(String xml) throws RegistryException {
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(xml.getBytes("utf-8")));
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            return builder.getDocumentElement();
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage());
        }
    }
}

