/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.operations;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.list.operations.AbstractOperation;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class GetAllArtifactIDsOperation
extends AbstractOperation {
    private Log log = LogFactory.getLog(GetAllArtifactIDsOperation.class);
    private String[] artifactIDs;

    public GetAllArtifactIDsOperation(QName name, Registry governanceSystemRegistry, String mediatype, String namespace) {
        super(name, governanceSystemRegistry, mediatype, namespace);
    }

    @Override
    public void setPayload(OMElement bodyContent) throws XMLStreamException {
        OMFactory factory = bodyContent.getOMFactory();
        for (String artifactId : this.artifactIDs) {
            OMElement returnElement = factory.createOMElement(new QName(bodyContent.getNamespace().getPrefix() + ":return"));
            returnElement.setText(artifactId);
            bodyContent.addChild((OMNode)returnElement);
        }
    }

    @Override
    public String getRequestName() {
        return "";
    }

    @Override
    public String getRequestType() {
        return "";
    }

    @Override
    public String getResponseType() {
        return "xs:string";
    }

    @Override
    public String getResponseMaxOccurs() {
        return "unbounded";
    }

    @Override
    public MessageContext process(MessageContext requestMessageContext) throws AxisFault {
        try {
            GenericArtifactManager artifactManager = new GenericArtifactManager(this.governanceSystemRegistry, this.rxtKey);
            this.artifactIDs = artifactManager.getAllGenericArtifactIds();
        }
        catch (RegistryException e) {
            String msg = "Error occured while retrieving artifacts";
            this.log.error((Object)msg);
            throw new AxisFault(msg, (Throwable)e);
        }
        return this.getAbstractResponseMessageContext(requestMessageContext);
    }
}

