/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.operations;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.list.operations.AbstractOperation;
import org.wso2.carbon.governance.list.operations.util.OperationUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class CreateOperation
extends AbstractOperation {
    private Log log = LogFactory.getLog(CreateOperation.class);
    private String artifactId;

    public CreateOperation(QName name, Registry governanceSystemRegistry, String mediatype, String namespace) {
        super(name, governanceSystemRegistry, mediatype, namespace);
    }

    @Override
    public void setPayload(OMElement bodyContent) throws XMLStreamException {
        OMFactory factory = bodyContent.getOMFactory();
        OMElement returnElement = factory.createOMElement(new QName(bodyContent.getNamespace().getPrefix() + ":return"));
        returnElement.setText(this.artifactId);
        bodyContent.addChild((OMNode)returnElement);
    }

    @Override
    public String getRequestName() {
        return "info";
    }

    @Override
    public String getRequestType() {
        return "xs:string";
    }

    @Override
    public String getResponseType() {
        return "xs:string";
    }

    @Override
    public String getResponseMaxOccurs() {
        return "1";
    }

    @Override
    public MessageContext process(MessageContext requestMessageContext) throws AxisFault {
        String msg;
        OMElement content = null;
        try {
            content = AXIOMUtil.stringToOM((String)requestMessageContext.getEnvelope().getBody().getFirstElement().getFirstChildWithName(new QName(this.namespace, "info")).getText());
            if (content == null) {
                String msg2 = "Content of the resource should be in correct format";
                this.log.error((Object)msg2);
                OperationUtil.handleException(msg2);
            }
        }
        catch (XMLStreamException e) {
            msg = "Error occured while reading the content of the SOAP message";
            this.log.error((Object)msg);
            OperationUtil.handleException(msg, e);
        }
        try {
            GenericArtifactManager artifactManager = new GenericArtifactManager(this.governanceSystemRegistry, this.rxtKey);
            GenericArtifact artifact = artifactManager.newGovernanceArtifact(content);
            artifactManager.addGenericArtifact(artifact);
            this.artifactId = artifact.getId();
        }
        catch (RegistryException e) {
            msg = "Error occured while adding the content " + content;
            this.log.error((Object)msg);
            OperationUtil.handleException(msg, (Exception)((Object)e));
        }
        return this.getAbstractResponseMessageContext(requestMessageContext);
    }
}

