/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.internal;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.list.operations.AbstractOperation;
import org.wso2.carbon.governance.list.operations.CreateOperation;
import org.wso2.carbon.governance.list.operations.DeleteOperation;
import org.wso2.carbon.governance.list.operations.GetAllArtifactIDsOperation;
import org.wso2.carbon.governance.list.operations.GetDependenciesOperation;
import org.wso2.carbon.governance.list.operations.RXTMessageReceiver;
import org.wso2.carbon.governance.list.operations.ReadOperation;
import org.wso2.carbon.governance.list.operations.UpdateOperation;
import org.wso2.carbon.governance.list.util.CommonUtil;
import org.wso2.carbon.governance.list.util.ListServiceUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.HandlerManager;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.MediaTypeMatcher;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.component.xml.config.ManagementPermission;

public class GovernanceMgtUIListMetadataServiceComponent {
    private static Log log = LogFactory.getLog(GovernanceMgtUIListMetadataServiceComponent.class);
    private ServiceRegistration serviceRegistration;

    protected void activate(ComponentContext context) {
        final RegistryService registryService = CommonUtil.getRegistryService();
        try {
            UserRegistry registry = registryService.getRegistry("wso2.system.user");
            this.configureGovernanceArtifacts((Registry)registry, CommonUtil.getConfigurationContext().getAxisConfiguration());
            AbstractAxis2ConfigurationContextObserver observer = new AbstractAxis2ConfigurationContextObserver(){

                public void createdConfigurationContext(ConfigurationContext context) {
                    try {
                        int tenantId = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)context).getTenantId();
                        GovernanceMgtUIListMetadataServiceComponent.this.configureGovernanceArtifacts((Registry)registryService.getRegistry("wso2.system.user", tenantId), context.getAxisConfiguration());
                    }
                    catch (RegistryException e) {
                        log.error((Object)"Unable to load governance artifacts.", (Throwable)e);
                    }
                }
            };
            this.serviceRegistration = context.getBundleContext().registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)observer, null);
            HandlerManager handlerManager = registry.getRegistryContext().getHandlerManager();
            if (handlerManager != null) {
                handlerManager.addHandler(null, (Filter)new MediaTypeMatcher("application/vnd.wso2.registry-ext-type+xml"), new Handler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void put(RequestContext requestContext) throws RegistryException {
                        if (!org.wso2.carbon.registry.extensions.utils.CommonUtil.isUpdateLockAvailable()) {
                            return;
                        }
                        org.wso2.carbon.registry.extensions.utils.CommonUtil.acquireUpdateLock();
                        try {
                            if (!CommonUtil.validateXMLConfigOnSchema(RegistryUtils.decodeBytes((byte[])((byte[])requestContext.getResource().getContent())), "rxt-ui-config")) {
                                throw new RegistryException("Violation of RXT definition in configuration file, follow the schema correctly..!!");
                            }
                            Registry userRegistry = requestContext.getRegistry();
                            userRegistry.put(requestContext.getResourcePath().getPath(), requestContext.getResource());
                            Registry systemRegistry = requestContext.getSystemRegistry();
                            GovernanceMgtUIListMetadataServiceComponent.this.configureGovernanceArtifacts(systemRegistry, CommonUtil.getConfigurationContext().getAxisConfiguration());
                            requestContext.setProcessingComplete(true);
                        }
                        finally {
                            org.wso2.carbon.registry.extensions.utils.CommonUtil.releaseUpdateLock();
                        }
                    }

                    public void delete(RequestContext requestContext) throws RegistryException {
                        Resource resource = requestContext.getResource();
                        Object content = resource.getContent();
                        String elementString = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
                        GovernanceArtifactConfiguration artifactConfiguration = GovernanceUtils.getGovernanceArtifactConfiguration((String)elementString);
                        String needToDelete = artifactConfiguration.getKey();
                        UserRegistry systemRegistry = registryService.getRegistry("wso2.system.user");
                        if (systemRegistry.resourceExists("/_system/config/repository/components/org.wso2.carbon.governance/configuration/" + needToDelete)) {
                            systemRegistry.delete("/_system/config/repository/components/org.wso2.carbon.governance/configuration/" + needToDelete);
                        }
                        GovernanceUtils.loadGovernanceArtifacts((UserRegistry)systemRegistry);
                        List configurations = GovernanceUtils.findGovernanceArtifactConfigurations((Registry)systemRegistry);
                        for (GovernanceArtifactConfiguration configuration : configurations) {
                            for (ManagementPermission uiPermission : configuration.getUIPermissions()) {
                                String resourceId = "/_system/governance" + uiPermission.getResourceId();
                                if (!systemRegistry.resourceExists(resourceId) || !needToDelete.equals(configuration.getKey())) continue;
                                systemRegistry.delete(resourceId);
                            }
                        }
                        GovernanceMgtUIListMetadataServiceComponent.this.unDeployCRUDService(artifactConfiguration, CommonUtil.getConfigurationContext().getAxisConfiguration());
                    }
                });
                handlerManager.addHandler(null, (Filter)new MediaTypeMatcher(){

                    public boolean handlePut(RequestContext requestContext) throws RegistryException {
                        Resource resource = requestContext.getResource();
                        if (resource == null) {
                            return false;
                        }
                        String mType = resource.getMediaType();
                        return mType != null && this.invert != (mType.matches("application/vnd\\.[a-zA-Z0-9.-]+\\+xml") & !mType.matches("application/vnd.wso2-service\\+xml"));
                    }

                    public boolean handleCreateLink(RequestContext requestContext) throws RegistryException {
                        String targetPath = requestContext.getTargetPath();
                        if (!requestContext.getRegistry().resourceExists(targetPath)) {
                            return false;
                        }
                        Resource targetResource = requestContext.getRegistry().get(targetPath);
                        String mType = targetResource.getMediaType();
                        return mType != null && this.invert != (mType.matches("application/vnd\\.[a-zA-Z0-9.-]+\\+xml") & !mType.matches("application/vnd.wso2-service\\+xml"));
                    }
                }, new Handler(){

                    public void createLink(RequestContext requestContext) throws RegistryException {
                        String symlinkPath = requestContext.getResourcePath().getPath();
                        if (!symlinkPath.startsWith("/_system/governance")) {
                            throw new RegistryException("symlink creation is not allowed for artifact " + requestContext.getTargetPath());
                        }
                    }
                });
            }
            ListServiceUtil.startArtifactFetcher((Registry)registry);
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to load governance artifacts.", (Throwable)e);
        }
        log.debug((Object)"******* Governance List Metadata bundle is activated ******* ");
    }

    private void configureGovernanceArtifacts(Registry systemRegistry, AxisConfiguration axisConfig) throws RegistryException {
        GovernanceUtils.loadGovernanceArtifacts((UserRegistry)((UserRegistry)systemRegistry));
        List configurations = GovernanceUtils.findGovernanceArtifactConfigurations((Registry)systemRegistry);
        Registry governanceSystemRegistry = GovernanceUtils.getGovernanceSystemRegistry((Registry)systemRegistry);
        for (GovernanceArtifactConfiguration configuration : configurations) {
            for (ManagementPermission uiPermission : configuration.getUIPermissions()) {
                String resourceId = "/_system/governance" + uiPermission.getResourceId();
                if (systemRegistry.resourceExists(resourceId)) continue;
                Collection collection = systemRegistry.newCollection();
                collection.setProperty("name", uiPermission.getDisplayName());
                systemRegistry.put(resourceId, (Resource)collection);
            }
            RXTMessageReceiver receiver = new RXTMessageReceiver();
            if (axisConfig == null) continue;
            try {
                String singularLabel = configuration.getSingularLabel().replaceAll("\\s", "");
                String pluralLabel = configuration.getPluralLabel().replaceAll("\\s", "");
                String key = configuration.getKey();
                String mediaType = configuration.getMediaType();
                if (axisConfig.getService(singularLabel) != null) continue;
                AxisService service = new AxisService(singularLabel);
                Parameter param1 = new Parameter("AuthorizationAction", (Object)"/permission/admin/login");
                param1.setLocked(true);
                service.addParameter(param1);
                Parameter param2 = new Parameter("adminService", (Object)"true");
                param2.setLocked(true);
                service.addParameter(param2);
                Parameter param3 = new Parameter("hiddenService", (Object)"true");
                param3.setLocked(true);
                service.addParameter(param3);
                Parameter param4 = new Parameter("enableMTOM", (Object)"true");
                param4.setLocked(true);
                service.addParameter(param4);
                XmlSchemaCollection schemaCol = new XmlSchemaCollection();
                ArrayList<XmlSchema> schemaList = new ArrayList<XmlSchema>();
                AbstractOperation create = new CreateOperation(new QName("add" + singularLabel), governanceSystemRegistry, mediaType, "http://services.add." + key + ".governance.carbon.wso2.org").init(key, receiver);
                Parameter authorizationActionCreate = new Parameter("AuthorizationAction", (Object)("/permission/admin/manage/resources/govern/" + pluralLabel + "/add"));
                authorizationActionCreate.setLocked(true);
                create.addParameter(authorizationActionCreate);
                service.addOperation((AxisOperation)create);
                schemaList.addAll(Arrays.asList(create.getSchemas(schemaCol)));
                AbstractOperation read = new ReadOperation(new QName("get" + singularLabel), governanceSystemRegistry, mediaType, "http://services.get." + key + ".governance.carbon.wso2.org").init(key, receiver);
                Parameter authorizationActionRead = new Parameter("AuthorizationAction", (Object)("/permission/admin/manage/resources/govern/" + pluralLabel + "/list"));
                authorizationActionRead.setLocked(true);
                read.addParameter(authorizationActionRead);
                service.addOperation((AxisOperation)read);
                schemaList.addAll(Arrays.asList(read.getSchemas(schemaCol)));
                AbstractOperation update = new UpdateOperation(new QName("update" + singularLabel), governanceSystemRegistry, mediaType, "http://services.update." + key + ".governance.carbon.wso2.org").init(key, receiver);
                Parameter authorizationActionUpdate = new Parameter("AuthorizationAction", (Object)("/permission/admin/manage/resources/govern/" + pluralLabel + "/add"));
                authorizationActionUpdate.setLocked(true);
                update.addParameter(authorizationActionUpdate);
                service.addOperation((AxisOperation)update);
                schemaList.addAll(Arrays.asList(update.getSchemas(schemaCol)));
                AbstractOperation delete = new DeleteOperation(new QName("delete" + singularLabel), governanceSystemRegistry, mediaType, "http://services.delete." + key + ".governance.carbon.wso2.org").init(key, receiver);
                Parameter authorizationActionDelete = new Parameter("AuthorizationAction", (Object)("/permission/admin/manage/resources/govern/" + pluralLabel + "/add"));
                authorizationActionDelete.setLocked(true);
                delete.addParameter(authorizationActionDelete);
                service.addOperation((AxisOperation)delete);
                schemaList.addAll(Arrays.asList(delete.getSchemas(schemaCol)));
                AbstractOperation getAllArtifactIds = new GetAllArtifactIDsOperation(new QName("get" + singularLabel + "ArtifactIDs"), governanceSystemRegistry, mediaType, "http://services.get." + key + "." + "ArtifactIDs".toLowerCase() + ".governance.carbon.wso2.org").init(key, receiver);
                Parameter authorizationActionGetArtifactIDs = new Parameter("AuthorizationAction", (Object)("/permission/admin/manage/resources/govern/" + pluralLabel + "/list"));
                authorizationActionGetArtifactIDs.setLocked(true);
                getAllArtifactIds.addParameter(authorizationActionGetArtifactIDs);
                service.addOperation((AxisOperation)getAllArtifactIds);
                schemaList.addAll(Arrays.asList(getAllArtifactIds.getSchemas(schemaCol)));
                AbstractOperation getDependencies = new GetDependenciesOperation(new QName("get" + singularLabel + "Dependencies"), governanceSystemRegistry, mediaType, "http://services.get." + key + "." + "Dependencies".toLowerCase() + ".governance.carbon.wso2.org").init(key, receiver);
                Parameter authorizationActionGetDependencies = new Parameter("AuthorizationAction", (Object)("/permission/admin/manage/resources/govern/" + pluralLabel + "/list"));
                authorizationActionGetDependencies.setLocked(true);
                getDependencies.addParameter(authorizationActionGetDependencies);
                service.addOperation((AxisOperation)getDependencies);
                schemaList.addAll(Arrays.asList(getDependencies.getSchemas(schemaCol)));
                axisConfig.addService(service);
                XmlSchema schema = schemaCol.read((Source)new StreamSource(new ByteArrayInputStream("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" attributeFormDefault=\"qualified\" elementFormDefault=\"qualified\" targetNamespace=\"http://api.registry.carbon.wso2.org/xsd\">\n            <xs:complexType name=\"RegistryException\">\n                <xs:sequence />\n            </xs:complexType>\n        </xs:schema>".getBytes())), null);
                schemaList.add(schema);
                schema = schemaCol.read((Source)new StreamSource(new ByteArrayInputStream("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ax2233=\"http://exceptions.core.registry.carbon.wso2.org/xsd\" attributeFormDefault=\"qualified\" elementFormDefault=\"qualified\" targetNamespace=\"http://exception.api.governance.carbon.wso2.org/xsd\">\n            <xs:import namespace=\"http://exceptions.core.registry.carbon.wso2.org/xsd\" />\n            <xs:complexType name=\"GovernanceException\">\n                <xs:complexContent>\n                    <xs:extension base=\"ax2233:RegistryException\">\n                        <xs:sequence />\n                    </xs:extension>\n                </xs:complexContent>\n            </xs:complexType>\n        </xs:schema>".getBytes())), null);
                schemaList.add(schema);
                schema = schemaCol.read((Source)new StreamSource(new ByteArrayInputStream("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ax2232=\"http://api.registry.carbon.wso2.org/xsd\" attributeFormDefault=\"qualified\" elementFormDefault=\"qualified\" targetNamespace=\"http://exceptions.core.registry.carbon.wso2.org/xsd\">\n            <xs:import namespace=\"http://api.registry.carbon.wso2.org/xsd\" />\n            <xs:complexType name=\"RegistryException\">\n                <xs:complexContent>\n                    <xs:extension base=\"ax2232:RegistryException\">\n                        <xs:sequence />\n                    </xs:extension>\n                </xs:complexContent>\n            </xs:complexType>\n        </xs:schema>".getBytes())), null);
                schemaList.add(schema);
                service.addSchema(schemaList);
            }
            catch (AxisFault axisFault) {
                String msg = "Error occured while adding services";
                log.error((Object)msg, (Throwable)axisFault);
            }
        }
    }

    private void unDeployCRUDService(GovernanceArtifactConfiguration configuration, AxisConfiguration axisConfig) {
        String singularLabel = configuration.getSingularLabel();
        try {
            if (axisConfig.getService(singularLabel) != null) {
                axisConfig.removeService(singularLabel);
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)axisFault);
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        ListServiceUtil.stopArtifactFetcher();
        log.debug((Object)"Governance List Metadata bundle is deactivated ");
    }

    protected void setRegistryService(RegistryService registryService) {
        CommonUtil.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        CommonUtil.setRegistryService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"The Configuration Context Service was set");
        if (configurationContextService != null) {
            CommonUtil.setConfigurationContext(configurationContextService.getServerConfigContext());
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        CommonUtil.setConfigurationContext(null);
    }
}

