/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.wsdls.dataobjects;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.endpoints.dataobjects.Endpoint;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.schema.dataobjects.Schema;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class Wsdl
extends GovernanceArtifact {
    private static final Log log = LogFactory.getLog(Wsdl.class);
    private static final String WSDL_TARGET_NAMESPACE_ATTRIBUTE = "targetNamespace";
    private QName qname;
    private OMElement wsdlElement;
    private String url;

    public Wsdl(String id, Registry registry) throws GovernanceException {
        super(id);
        this.associateRegistry(registry);
        this.loadWsdlDetails();
    }

    public Wsdl(String id, String url) {
        super(id);
        this.url = url;
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    public OMElement getWsdlElement() {
        return this.wsdlElement;
    }

    public void setWsdlElement(OMElement wsdlElement) {
        this.wsdlElement = wsdlElement;
    }

    public String getUrl() {
        return this.url;
    }

    public void attachSchema(Schema schema) throws GovernanceException {
        this.attach(schema);
    }

    public void detachSchema(String schemaId) throws GovernanceException {
        this.detach(schemaId);
    }

    public Schema[] getAttachedSchemas() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        Registry registry = this.getAssociatedRegistry();
        String path = this.getPath();
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        try {
            Association[] associations;
            for (Association association : associations = registry.getAssociations(path, "depends")) {
                String destinationPath = association.getDestinationPath();
                GovernanceArtifact governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(registry, destinationPath);
                if (!(governanceArtifact instanceof Schema)) continue;
                schemas.add((Schema)governanceArtifact);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in getting attached schemas from the artifact at path: " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        return schemas.toArray(new Schema[schemas.size()]);
    }

    public void attachEndpoint(Endpoint endpoint) throws GovernanceException {
        this.attach(endpoint);
    }

    public void detachEndpoint(String endpointId) throws GovernanceException {
        this.detach(endpointId);
    }

    public Endpoint[] getAttachedEndpoints() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        Registry registry = this.getAssociatedRegistry();
        String path = this.getPath();
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        try {
            Association[] associations;
            for (Association association : associations = registry.getAssociations(path, "depends")) {
                String destinationPath = association.getDestinationPath();
                GovernanceArtifact governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(registry, destinationPath);
                if (!(governanceArtifact instanceof Endpoint)) continue;
                endpoints.add((Endpoint)governanceArtifact);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in getting attached endpoints from the artifact at path: " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        return endpoints.toArray(new Endpoint[endpoints.size()]);
    }

    public void loadWsdlDetails() throws GovernanceException {
        Set<Object> keySet;
        Resource resource;
        this.checkRegistryResourceAssociation();
        Registry registry = this.getAssociatedRegistry();
        String path = this.getPath();
        String id = this.getId();
        try {
            resource = registry.get(path);
            byte[] content = (byte[])resource.getContent();
            this.wsdlElement = GovernanceUtils.buildOMElement(content);
        }
        catch (RegistryException e) {
            String msg = "Error in getting the qualified name for the artifact. artifact id: " + id + ", " + "path: " + path + ".";
            log.error((Object)msg);
            throw new GovernanceException(msg, e);
        }
        String fileName = RegistryUtils.getResourceName((String)path);
        String namespaceURI = this.wsdlElement.getAttributeValue(new QName(WSDL_TARGET_NAMESPACE_ATTRIBUTE));
        this.qname = new QName(namespaceURI, fileName);
        Properties properties = resource.getProperties();
        if (properties != null && (keySet = properties.keySet()) != null) {
            for (Object keyObj : keySet) {
                String key = (String)keyObj;
                List values = (List)properties.get(key);
                if (values == null) continue;
                for (Object valueObj : values) {
                    String value = (String)valueObj;
                    this.addAttribute(key, value);
                }
            }
        }
    }
}

