/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.wsdls;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.api.wsdls.WsdlFilter;
import org.wso2.carbon.governance.api.wsdls.dataobjects.Wsdl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class WsdlManager {
    private static final Log log = LogFactory.getLog(WsdlManager.class);
    private Registry registry;

    public WsdlManager(Registry registry) {
        this.registry = registry;
    }

    public Wsdl newWsdl(String url) throws GovernanceException {
        String wsdlId = UUID.randomUUID().toString();
        Wsdl wsdl = new Wsdl(wsdlId, url);
        wsdl.associateRegistry(this.registry);
        return wsdl;
    }

    public Wsdl newWsdl(byte[] content) throws RegistryException {
        return this.newWsdl(content, null);
    }

    public Wsdl newWsdl(byte[] content, String name) throws RegistryException {
        String wsdlId = UUID.randomUUID().toString();
        Wsdl wsdl = new Wsdl(wsdlId, name != null ? "name://" + name : null);
        wsdl.associateRegistry(this.registry);
        wsdl.setWsdlElement(GovernanceUtils.buildOMElement(content));
        return wsdl;
    }

    public void addWsdl(Wsdl wsdl) throws GovernanceException {
        boolean succeeded = false;
        try {
            this.registry.beginTransaction();
            String url = wsdl.getUrl();
            Resource wsdlResource = this.registry.newResource();
            wsdlResource.setMediaType("application/wsdl+xml");
            this.setContent(wsdl, wsdlResource);
            String tmpPath = wsdl.getQName() != null ? "/" + wsdl.getQName().getLocalPart() : (url != null && !url.startsWith("name://") ? RegistryUtils.getResourceName((String)new URL(url).getFile().replace("~", "")) : (url != null ? url.substring("name://".length()) : wsdl.getId() + ".wsdl"));
            Resource resource = url == null || url.startsWith("name://") ? this.registry.get(this.registry.put("/" + tmpPath, wsdlResource)) : this.registry.get(this.registry.importResource(tmpPath, url, wsdlResource));
            wsdl.setId(resource.getUUID());
            wsdl.updatePath();
            wsdl.loadWsdlDetails();
            succeeded = true;
        }
        catch (RegistryException e) {
            String msg = "Error in adding the wsdl. wsdl id: " + wsdl.getId() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        catch (MalformedURLException e) {
            String msg = "Malformed policy url provided. url: " + wsdl.getUrl() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        finally {
            if (succeeded) {
                try {
                    this.registry.commitTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in committing transactions. Add wsdl failed: wsdl id: " + wsdl.getId() + ", path: " + wsdl.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            } else {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in rolling back transactions. Add wsdl failed: wsdl id: " + wsdl.getId() + ", path: " + wsdl.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    public void updateWsdl(Wsdl wsdl) throws GovernanceException {
        if (wsdl.getWsdlElement() == null) {
            String msg = "Updates are only accepted if the wsdlElement available. So no updates will be done. wsdl id: " + wsdl.getId() + ", wsdl path: " + wsdl.getPath() + ".";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        boolean succeeded = false;
        try {
            this.registry.beginTransaction();
            Wsdl oldWsdl = this.getWsdl(wsdl.getId());
            if (oldWsdl == null) {
                this.addWsdl(wsdl);
                return;
            }
            Resource wsdlResource = this.registry.newResource();
            wsdlResource.setMediaType("application/wsdl+xml");
            this.setContent(wsdl, wsdlResource);
            String tmpPath = oldWsdl.getPath();
            wsdlResource.setUUID(wsdl.getId());
            this.registry.put(tmpPath, wsdlResource);
            wsdl.setId(wsdlResource.getUUID());
            wsdl.updatePath();
            wsdl.loadWsdlDetails();
            succeeded = true;
        }
        catch (RegistryException e) {
            String msg = "Error in updating the wsdl, wsdl id: " + wsdl.getId() + ", wsdl path: " + wsdl.getPath() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        finally {
            if (succeeded) {
                try {
                    this.registry.commitTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in committing transactions. Update wsdl failed: wsdl id: " + wsdl.getId() + ", path: " + wsdl.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            } else {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in rolling back transactions. Update wsdl failed: wsdl id: " + wsdl.getId() + ", path: " + wsdl.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    public Wsdl getWsdl(String wsdlId) throws GovernanceException {
        GovernanceArtifact artifact = GovernanceUtils.retrieveGovernanceArtifactById(this.registry, wsdlId);
        if (artifact != null && !(artifact instanceof Wsdl)) {
            String msg = "The artifact request is not a Wsdl. id: " + wsdlId + ".";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        return (Wsdl)artifact;
    }

    public void removeWsdl(String wsdlId) throws GovernanceException {
        GovernanceUtils.removeArtifact(this.registry, wsdlId);
    }

    protected void setContent(Wsdl wsdl, Resource wsdlResource) throws GovernanceException {
        String[] attributeKeys;
        if (wsdl.getWsdlElement() != null) {
            OMElement contentElement = wsdl.getWsdlElement().cloneOMElement();
            try {
                String path;
                OMAttribute location;
                for (String importType : new String[]{"import", "include"}) {
                    List<OMElement> wsdlImports = GovernanceUtils.evaluateXPathToElements("//wsdl:" + importType, contentElement);
                    for (OMElement wsdlImport : wsdlImports) {
                        location = wsdlImport.getAttribute(new QName("location"));
                        if (location == null || (path = location.getAttributeValue()).indexOf(";version:") <= 0) continue;
                        location.setAttributeValue(path.substring(0, path.lastIndexOf(";version:")));
                    }
                }
                for (String importType : new String[]{"import", "include", "redefine"}) {
                    List<OMElement> schemaImports = GovernanceUtils.evaluateXPathToElements("//xsd:" + importType, contentElement);
                    for (OMElement schemaImport : schemaImports) {
                        location = schemaImport.getAttribute(new QName("schemaLocation"));
                        if (location == null || (path = location.getAttributeValue()).indexOf(";version:") <= 0) continue;
                        location.setAttributeValue(path.substring(0, path.lastIndexOf(";version:")));
                    }
                }
            }
            catch (JaxenException ignore) {
                // empty catch block
            }
            String wsdlContent = contentElement.toString();
            try {
                wsdlResource.setContent((Object)wsdlContent);
            }
            catch (RegistryException e) {
                String msg = "Error in setting the content from wsdl, wsdl id: " + wsdl.getId() + ", wsdl path: " + wsdl.getPath() + ".";
                log.error((Object)msg, (Throwable)e);
                throw new GovernanceException(msg, e);
            }
        }
        if ((attributeKeys = wsdl.getAttributeKeys()) != null) {
            Properties properties = new Properties();
            for (String attributeKey : attributeKeys) {
                String[] attributeValues = wsdl.getAttributes(attributeKey);
                if (attributeValues == null) continue;
                properties.put(attributeKey, new ArrayList<String>(Arrays.asList(attributeValues)));
            }
            wsdlResource.setProperties(properties);
        }
        wsdlResource.setUUID(wsdl.getId());
    }

    public Wsdl[] findWsdls(WsdlFilter criteria) throws GovernanceException {
        ArrayList<Wsdl> wsdls = new ArrayList<Wsdl>();
        for (Wsdl wsdl : this.getAllWsdls()) {
            if (wsdl == null || !criteria.matches(wsdl)) continue;
            wsdls.add(wsdl);
        }
        return wsdls.toArray(new Wsdl[wsdls.size()]);
    }

    public Wsdl[] getAllWsdls() throws GovernanceException {
        List<String> wsdlPaths = Arrays.asList(GovernanceUtils.getResultPaths(this.registry, "application/wsdl+xml"));
        Collections.sort(wsdlPaths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int result = RegistryUtils.getResourceName((String)o1).compareToIgnoreCase(RegistryUtils.getResourceName((String)o2));
                if (result != 0) {
                    return result;
                }
                return o1.compareToIgnoreCase(o2);
            }
        });
        ArrayList<Wsdl> wsdls = new ArrayList<Wsdl>();
        for (String wsdlPath : wsdlPaths) {
            GovernanceArtifact artifact = GovernanceUtils.retrieveGovernanceArtifactByPath(this.registry, wsdlPath);
            wsdls.add((Wsdl)artifact);
        }
        return wsdls.toArray(new Wsdl[wsdls.size()]);
    }
}

