/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.policies;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.policies.PolicyFilter;
import org.wso2.carbon.governance.api.policies.dataobjects.Policy;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class PolicyManager {
    private static final Log log = LogFactory.getLog(PolicyManager.class);
    private Registry registry;

    public PolicyManager(Registry registry) {
        this.registry = registry;
    }

    public Policy newPolicy(byte[] content) throws RegistryException {
        return this.newPolicy(content, null);
    }

    public Policy newPolicy(byte[] content, String name) throws RegistryException {
        String policyId = UUID.randomUUID().toString();
        Policy policy = new Policy(policyId, name != null ? "name://" + name : null);
        policy.associateRegistry(this.registry);
        policy.setPolicyContent(RegistryUtils.decodeBytes((byte[])content));
        return policy;
    }

    public Policy newPolicy(String url) throws GovernanceException {
        String policyId = UUID.randomUUID().toString();
        Policy policy = new Policy(policyId, url);
        policy.associateRegistry(this.registry);
        return policy;
    }

    public void addPolicy(Policy policy) throws GovernanceException {
        boolean succeeded = false;
        String url = policy.getUrl();
        try {
            this.registry.beginTransaction();
            Resource policyResource = this.registry.newResource();
            policyResource.setMediaType("application/policy+xml");
            this.setContent(policy, policyResource);
            String tmpPath = policy.getQName() != null ? "/" + policy.getQName().getLocalPart() : (url != null && !url.startsWith("name://") ? RegistryUtils.getResourceName((String)new URL(url).getFile().replace("~", "")) : (url != null ? url.substring("name://".length()) : policy.getId() + ".xml"));
            Resource resource = url == null || url.startsWith("name://") ? this.registry.get(this.registry.put("/" + tmpPath, policyResource)) : this.registry.get(this.registry.importResource(tmpPath, url, policyResource));
            policy.setId(resource.getUUID());
            policy.updatePath();
            policy.loadPolicyDetails();
            succeeded = true;
        }
        catch (RegistryException e) {
            String msg = "Error in adding the Policy. policy id: " + policy.getId() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        catch (MalformedURLException e) {
            String msg = "Malformed policy url provided. url: " + url + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        finally {
            if (succeeded) {
                try {
                    this.registry.commitTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in committing transactions. Add policy failed: policy id: " + policy.getId() + ", path: " + policy.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            } else {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in rolling back transactions. Add policy failed: policy id: " + policy.getId() + ", path: " + policy.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    public void updatePolicy(Policy policy) throws GovernanceException {
        if (policy.getPolicyContent() == null) {
            String msg = "Updates are only accepted if the policy content is available. So no updates will be done. policy id: " + policy.getId() + ", policy path: " + policy.getPath() + ".";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        boolean succeeded = false;
        String url = policy.getUrl();
        try {
            String tmpPath;
            this.registry.beginTransaction();
            Policy oldPolicy = this.getPolicy(policy.getId());
            if (oldPolicy == null) {
                this.addPolicy(policy);
                return;
            }
            Resource policyResource = this.registry.newResource();
            policyResource.setMediaType("application/policy+xml");
            this.setContent(policy, policyResource);
            this.registry.delete(oldPolicy.getPath());
            if (policy.getQName() != null) {
                tmpPath = "/" + policy.getQName().getLocalPart();
            } else if (url != null) {
                tmpPath = RegistryUtils.getResourceName((String)new URL(url).getFile().replace("~", ""));
            } else {
                String msg = "Error in identifying the name for the policy. State the name for the policy.";
                log.error((Object)msg);
                throw new GovernanceException(msg);
            }
            policyResource.setUUID(policy.getId());
            this.registry.put(tmpPath, policyResource);
            policy.setId(policyResource.getUUID());
            policy.updatePath();
            succeeded = true;
        }
        catch (RegistryException e) {
            String msg = "Error in updating the policy, policy id: " + policy.getId() + ", policy path: " + policy.getPath() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        catch (MalformedURLException e) {
            String msg = "Malformed url found, url " + url + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        finally {
            if (succeeded) {
                try {
                    this.registry.commitTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in committing transactions. Update policy failed: policy id: " + policy.getId() + ", path: " + policy.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            } else {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in rolling back transactions. Update policy failed: policy id: " + policy.getId() + ", path: " + policy.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    public Policy getPolicy(String policyId) throws GovernanceException {
        GovernanceArtifact artifact = GovernanceUtils.retrieveGovernanceArtifactById(this.registry, policyId);
        if (artifact != null && !(artifact instanceof Policy)) {
            String msg = "The artifact request is not a policy. id: " + policyId + ".";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        return (Policy)artifact;
    }

    public void removePolicy(String policyId) throws GovernanceException {
        GovernanceUtils.removeArtifact(this.registry, policyId);
    }

    protected void setContent(Policy policy, Resource policyResource) throws GovernanceException {
        String[] attributeKeys;
        if (policy.getPolicyContent() != null) {
            String policyContent = policy.getPolicyContent();
            try {
                policyResource.setContent((Object)policyContent);
            }
            catch (RegistryException e) {
                String msg = "Error in setting the content from policy, policy id: " + policy.getId() + ", policy path: " + policy.getPath() + ".";
                log.error((Object)msg, (Throwable)e);
                throw new GovernanceException(msg, e);
            }
        }
        if ((attributeKeys = policy.getAttributeKeys()) != null) {
            Properties properties = new Properties();
            for (String attributeKey : attributeKeys) {
                String[] attributeValues = policy.getAttributes(attributeKey);
                if (attributeValues == null) continue;
                properties.put(attributeKey, new ArrayList<String>(Arrays.asList(attributeValues)));
            }
            policyResource.setProperties(properties);
        }
        policyResource.setUUID(policy.getId());
    }

    public Policy[] findPolicies(PolicyFilter criteria) throws GovernanceException {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        for (Policy policy : this.getAllPolicies()) {
            if (policy == null || !criteria.matches(policy)) continue;
            policies.add(policy);
        }
        return policies.toArray(new Policy[policies.size()]);
    }

    public Policy[] getAllPolicies() throws GovernanceException {
        List<String> policyPaths = Arrays.asList(GovernanceUtils.getResultPaths(this.registry, "application/policy+xml"));
        Collections.sort(policyPaths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return RegistryUtils.getResourceName((String)o1).compareToIgnoreCase(RegistryUtils.getResourceName((String)o2));
            }
        });
        ArrayList<Policy> policies = new ArrayList<Policy>();
        for (String policyPath : policyPaths) {
            GovernanceArtifact artifact = GovernanceUtils.retrieveGovernanceArtifactByPath(this.registry, policyPath);
            policies.add((Policy)artifact);
        }
        return policies.toArray(new Policy[policies.size()]);
    }
}

