/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.endpoints.dataobjects;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class Endpoint
extends GovernanceArtifact {
    private static final Log log = LogFactory.getLog(Endpoint.class);
    private String url;

    public Endpoint(String id, Registry registry) throws GovernanceException {
        super(id);
        this.associateRegistry(registry);
        this.loadEndpointDetails();
    }

    public Endpoint(String url, String id) {
        super(id);
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public QName getQName() {
        return new QName(this.url);
    }

    public void loadEndpointDetails() throws GovernanceException {
        Set<Object> keySet;
        Resource resource;
        this.checkRegistryResourceAssociation();
        Registry registry = this.getAssociatedRegistry();
        String path = this.getPath();
        String id = this.getId();
        try {
            resource = registry.get(path);
            Object contentObj = resource.getContent();
            if (contentObj instanceof String) {
                this.url = (String)contentObj;
            } else {
                byte[] content = (byte[])contentObj;
                this.url = RegistryUtils.decodeBytes((byte[])content);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in getting the content for the artifact. artifact id: " + id + ", " + "path: " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        Properties properties = resource.getProperties();
        if (properties != null && (keySet = properties.keySet()) != null) {
            for (Object keyObj : keySet) {
                String key = (String)keyObj;
                List values = (List)properties.get(key);
                if (values == null) continue;
                for (Object valueObj : values) {
                    String value = (String)valueObj;
                    this.addAttribute(key, value);
                }
            }
        }
    }
}

