/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.GovernanceArtifactFilter;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class GovernanceArtifactManager {
    private static final Log log = LogFactory.getLog(GovernanceArtifactManager.class);
    private Registry registry;
    private String mediaType;
    private String artifactNameAttribute;
    private String artifactNamespaceAttribute;
    private String artifactElementRoot;
    private String artifactElementNamespace;
    private String pathExpression;
    private List<Association> relationshipDefinitions;

    public GovernanceArtifactManager(Registry registry, String mediaType, String artifactNameAttribute, String artifactNamespaceAttribute, String artifactElementRoot, String artifactElementNamespace, String pathExpression, Association[] relationshipDefinitions) {
        this.registry = registry;
        this.mediaType = mediaType;
        this.artifactNameAttribute = artifactNameAttribute;
        this.artifactNamespaceAttribute = artifactNamespaceAttribute;
        this.artifactElementRoot = artifactElementRoot;
        this.artifactElementNamespace = artifactElementNamespace;
        this.pathExpression = pathExpression;
        this.relationshipDefinitions = Arrays.asList(relationshipDefinitions);
    }

    public GovernanceArtifact newGovernanceArtifact() throws GovernanceException {
        return GovernanceArtifact.create(this.registry, UUID.randomUUID().toString());
    }

    public GovernanceArtifact newGovernanceArtifact(OMElement content) throws GovernanceException {
        return GovernanceArtifact.create(this.registry, UUID.randomUUID().toString(), content);
    }

    public void addGovernanceArtifact(GovernanceArtifact artifact) throws GovernanceException {
        if (artifact.getQName() == null || artifact.getQName().getLocalPart() == null) {
            String msg = "A valid qualified name was not set for this artifact";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        String artifactName = artifact.getQName().getLocalPart();
        artifact.setAttributes(this.artifactNameAttribute, new String[]{artifactName});
        String namespace = artifact.getQName().getNamespaceURI();
        if (this.artifactNamespaceAttribute != null) {
            artifact.setAttributes(this.artifactNamespaceAttribute, new String[]{namespace});
        }
        artifact.associateRegistry(this.registry);
        boolean succeeded = false;
        try {
            this.registry.beginTransaction();
            Resource resource = this.registry.newResource();
            resource.setMediaType(this.mediaType);
            this.setContent(artifact, resource);
            String path = GovernanceUtils.getPathFromPathExpression(this.pathExpression, artifact);
            if (this.registry.resourceExists(path)) {
                throw new GovernanceException("Governance artifact already exists");
            }
            String artifactId = artifact.getId();
            resource.setUUID(artifactId);
            this.registry.put(path, resource);
            artifact.setId(resource.getUUID());
            this.addRelationships(path, artifact);
            succeeded = true;
        }
        catch (RegistryException e) {
            String msg = artifact.getPath() != null ? "Failed to add artifact: artifact id: " + artifact.getId() + ", path: " + artifact.getPath() + ". " + e.getMessage() : "Failed to add artifact: artifact id: " + artifact.getId() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        finally {
            if (succeeded) {
                try {
                    this.registry.commitTransaction();
                }
                catch (RegistryException e) {
                    String msg = artifact.getPath() != null ? "Error in committing transactions. Failed to add artifact: artifact id: " + artifact.getId() + ", path: " + artifact.getPath() + "." : "Error in committing transactions. Failed to add artifact: artifact id: " + artifact.getId() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            } else {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in rolling back transactions. Failed to add artifact: artifact id: " + artifact.getId() + ", path: " + artifact.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    private void addRelationships(String path, GovernanceArtifact artifact) throws RegistryException {
        LinkedHashMap<String, AssociationInteger> typeMap = new LinkedHashMap<String, AssociationInteger>();
        for (Association association : this.relationshipDefinitions) {
            AssociationInteger associationInteger;
            String type = association.getAssociationType();
            String source = association.getSourcePath();
            String target = association.getDestinationPath();
            if (typeMap.containsKey(type)) {
                associationInteger = (AssociationInteger)typeMap.get(type);
                if (source == null) {
                    if (associationInteger.getInteger() < 0) {
                        associationInteger.setInteger(0);
                    }
                    for (String targetPath : GovernanceUtils.getPathsFromPathExpression(target, artifact)) {
                        associationInteger.getAssociations().add(new Association(path, targetPath, type));
                    }
                    continue;
                }
                if (target != null) continue;
                if (associationInteger.getInteger() > 0) {
                    associationInteger.setInteger(0);
                }
                for (String sourcePath : GovernanceUtils.getPathsFromPathExpression(source, artifact)) {
                    associationInteger.getAssociations().add(new Association(sourcePath, path, type));
                }
                continue;
            }
            associationInteger = new AssociationInteger();
            if (source == null) {
                associationInteger.setInteger(1);
                for (String targetPath : GovernanceUtils.getPathsFromPathExpression(target, artifact)) {
                    associationInteger.getAssociations().add(new Association(path, targetPath, type));
                }
            } else if (target == null) {
                associationInteger.setInteger(-1);
                for (String sourcePath : GovernanceUtils.getPathsFromPathExpression(source, artifact)) {
                    associationInteger.getAssociations().add(new Association(sourcePath, path, type));
                }
            }
            typeMap.put(type, associationInteger);
        }
        for (Map.Entry entry : typeMap.entrySet()) {
            AssociationInteger value = (AssociationInteger)entry.getValue();
            List<Association> associations = value.getAssociations();
            this.fixAssociations(path, (String)entry.getKey(), value.getInteger() >= 0, value.getInteger() <= 0, associations.toArray(new Association[associations.size()]));
        }
    }

    private void fixAssociations(String path, String type, boolean isSource, boolean isTarget, Association[] toAdd) throws RegistryException {
        String[] params;
        String SEPARATOR = ":";
        HashSet<String> existingSet = new HashSet<String>();
        for (Association association : this.registry.getAllAssociations(path)) {
            if (!type.equals(association.getAssociationType()) || (!isSource || !association.getSourcePath().equals(path)) && (!isTarget || !association.getDestinationPath().equals(path))) continue;
            existingSet.add(association.getSourcePath() + ":" + association.getDestinationPath() + ":" + association.getAssociationType());
        }
        HashSet<String> updatedSet = new HashSet<String>();
        for (Association association : toAdd) {
            updatedSet.add(association.getSourcePath() + ":" + association.getDestinationPath() + ":" + association.getAssociationType());
        }
        HashSet removedAssociations = new HashSet(existingSet);
        removedAssociations.removeAll(updatedSet);
        HashSet newAssociations = new HashSet(updatedSet);
        newAssociations.removeAll(existingSet);
        for (String removedAssociation : removedAssociations) {
            params = removedAssociation.split(":");
            this.registry.removeAssociation(params[0], params[1], params[2]);
        }
        for (String newAssociation : newAssociations) {
            params = newAssociation.split(":");
            this.registry.addAssociation(params[0], params[1], params[2]);
        }
    }

    public void updateGovernanceArtifact(GovernanceArtifact artifact) throws GovernanceException {
        boolean succeeded = false;
        try {
            this.registry.beginTransaction();
            GovernanceArtifact oldArtifact = this.getGovernanceArtifact(artifact.getId());
            if (oldArtifact != null) {
                QName oldName = oldArtifact.getQName();
                if (!oldName.equals(artifact.getQName())) {
                    String oldPath = oldArtifact.getPath();
                    this.registry.delete(oldPath);
                    String artifactName = artifact.getQName().getLocalPart();
                    artifact.setAttributes(this.artifactNameAttribute, new String[]{artifactName});
                    String namespace = artifact.getQName().getNamespaceURI();
                    if (this.artifactNamespaceAttribute != null) {
                        artifact.setAttributes(this.artifactNamespaceAttribute, new String[]{namespace});
                    }
                }
            } else {
                throw new GovernanceException("No artifact found for the artifact id :" + artifact.getId());
            }
            String artifactId = artifact.getId();
            Resource resource = this.registry.newResource();
            resource.setMediaType(this.mediaType);
            this.setContent(artifact, resource);
            String path = GovernanceUtils.getPathFromPathExpression(this.pathExpression, artifact);
            if (this.registry.resourceExists(path)) {
                Resource oldResource = this.registry.get(path);
                Properties properties = (Properties)oldResource.getProperties().clone();
                resource.setProperties(properties);
                Object content = oldResource.getContent();
                String oldContent = content instanceof String ? (String)content : new String((byte[])content);
                content = resource.getContent();
                String newContent = content instanceof String ? (String)content : new String((byte[])content);
                if (newContent.equals(oldContent)) {
                    artifact.setId(oldResource.getUUID());
                    this.addRelationships(path, artifact);
                    succeeded = true;
                    return;
                }
            }
            resource.setUUID(artifactId);
            this.registry.put(path, resource);
            artifact.setId(resource.getUUID());
            this.addRelationships(path, artifact);
            artifact.updatePath(artifactId);
            succeeded = true;
        }
        catch (RegistryException e) {
            if (e instanceof GovernanceException) {
                throw (GovernanceException)e;
            }
            String msg = artifact.getPath() != null ? "Error in updating the artifact, artifact id: " + artifact.getId() + ", artifact path: " + artifact.getPath() + "." + e.getMessage() + "." : "Error in updating the artifact, artifact id: " + artifact.getId() + "." + e.getMessage() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        finally {
            if (succeeded) {
                try {
                    this.registry.commitTransaction();
                }
                catch (RegistryException e) {
                    String msg = artifact.getPath() != null ? "Error in committing transactions. Update artifact failed: artifact id: " + artifact.getId() + ", path: " + artifact.getPath() + "." : "Error in committing transactions. Update artifact failed: artifact id: " + artifact.getId() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            } else {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in rolling back transactions. Update artifact failed: artifact id: " + artifact.getId() + ", path: " + artifact.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    public GovernanceArtifact getGovernanceArtifact(String artifactId) throws GovernanceException {
        return GovernanceUtils.retrieveGovernanceArtifactById(this.registry, artifactId);
    }

    public void removeGovernanceArtifact(String artifactId) throws GovernanceException {
        GovernanceUtils.removeArtifact(this.registry, artifactId);
    }

    protected void setContent(GovernanceArtifact artifact, Resource resource) throws GovernanceException {
        try {
            OMNamespace namespace = OMAbstractFactory.getOMFactory().createOMNamespace(this.artifactElementNamespace, "");
            HashMap<String, OMElement> elementsMap = new HashMap<String, OMElement>();
            String[] attributeKeys = artifact.getAttributeKeys();
            if (attributeKeys != null) {
                OMElement contentElement = OMAbstractFactory.getOMFactory().createOMElement(this.artifactElementRoot, namespace);
                for (String aggregatedKey : attributeKeys) {
                    String[] keys = aggregatedKey.split("_");
                    String elementsMapKey = null;
                    OMElement parentKeyElement = contentElement;
                    for (int i = 0; i < keys.length - 1; ++i) {
                        String key = keys[i];
                        OMElement keyElement = (OMElement)elementsMap.get(elementsMapKey = (elementsMapKey == null ? "" : elementsMapKey + "_") + key);
                        if (keyElement == null) {
                            keyElement = OMAbstractFactory.getOMFactory().createOMElement(key, namespace);
                            parentKeyElement.addChild((OMNode)keyElement);
                            elementsMap.put(elementsMapKey, keyElement);
                        }
                        parentKeyElement = keyElement;
                    }
                    String[] attributeValues = artifact.getAttributes(aggregatedKey);
                    String elementName = keys[keys.length - 1];
                    for (String value : attributeValues) {
                        OMElement keyElement = OMAbstractFactory.getOMFactory().createOMElement(elementName, namespace);
                        OMText textElement = OMAbstractFactory.getOMFactory().createOMText(value);
                        keyElement.addChild((OMNode)textElement);
                        parentKeyElement.addChild((OMNode)keyElement);
                    }
                }
                String updatedContent = GovernanceUtils.serializeOMElement(contentElement);
                resource.setContent((Object)updatedContent);
            }
        }
        catch (RegistryException e) {
            String msg = artifact.getPath() != null ? "Error in saving attributes for the artifact. id: " + artifact.getId() + ", path: " + artifact.getPath() + "." : "Error in saving attributes for the artifact. id: " + artifact.getId() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    public GovernanceArtifact[] findGovernanceArtifacts(GovernanceArtifactFilter criteria) throws GovernanceException {
        ArrayList<GovernanceArtifact> artifacts = new ArrayList<GovernanceArtifact>();
        for (GovernanceArtifact artifact : this.getAllGovernanceArtifacts()) {
            if (artifact == null || !criteria.matches(artifact)) continue;
            artifacts.add(artifact);
        }
        return artifacts.toArray(new GovernanceArtifact[artifacts.size()]);
    }

    public GovernanceArtifact[] getAllGovernanceArtifacts() throws GovernanceException {
        List<String> paths = Arrays.asList(GovernanceUtils.getResultPaths(this.registry, this.mediaType));
        Collections.sort(paths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                long l1 = -1L;
                long l2 = -1L;
                String temp1 = RegistryUtils.getParentPath((String)o1);
                String temp2 = RegistryUtils.getParentPath((String)o2);
                try {
                    l1 = Long.parseLong(RegistryUtils.getResourceName((String)temp1));
                    l2 = Long.parseLong(RegistryUtils.getResourceName((String)temp2));
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
                int result = RegistryUtils.getResourceName((String)temp1).compareToIgnoreCase(RegistryUtils.getResourceName((String)temp2));
                if (result != 0) {
                    return result;
                }
                result = temp1.compareToIgnoreCase(temp2);
                if (result != 0) {
                    return result;
                }
                return l1 > l2 ? -1 : 1;
            }
        });
        ArrayList<GovernanceArtifact> artifacts = new ArrayList<GovernanceArtifact>();
        for (String path : paths) {
            artifacts.add(GovernanceUtils.retrieveGovernanceArtifactByPath(this.registry, path));
        }
        return artifacts.toArray(new GovernanceArtifact[artifacts.size()]);
    }

    public String[] getAllGovernanceArtifactIds() throws GovernanceException {
        ArrayList<String> artifactIds = new ArrayList<String>();
        for (GovernanceArtifact artifact : this.getAllGovernanceArtifacts()) {
            artifactIds.add(artifact.getId());
        }
        return artifactIds.toArray(new String[artifactIds.size()]);
    }

    private static class AssociationInteger {
        private List<Association> associations = new LinkedList<Association>();
        private Integer integer;

        private AssociationInteger() {
        }

        public List<Association> getAssociations() {
            return this.associations;
        }

        public Integer getInteger() {
            return this.integer;
        }

        public void setInteger(Integer integer) {
            this.integer = integer;
        }
    }
}

