/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.ui.internal;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.ws.client.registry.WSRegistryServiceClient;
import org.wso2.carbon.ui.CarbonUIAuthenticator;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.UIAuthenticationExtender;
import org.wso2.carbon.ui.deployment.ComponentBuilder;
import org.wso2.carbon.ui.deployment.beans.Component;
import org.wso2.carbon.ui.deployment.beans.Menu;
import org.wso2.carbon.user.core.UserStoreException;

public class GovernanceListUIServiceComponent {
    private static Log log = LogFactory.getLog(GovernanceListUIServiceComponent.class);
    private ServiceRegistration serviceRegistration;
    private static final String DEFAULT_LIFECYCLE_GENERATOR_CLASS = "org.wso2.carbon.governance.services.ui.utils.LifecycleListPopulator";

    protected void activate(ComponentContext context) {
        UIAuthenticationExtender authenticationExtender = new UIAuthenticationExtender(){

            public void onSuccessAdminLogin(HttpServletRequest request, String s, String s1, String s2) {
                if (CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)"/permission/admin/manage/resources/ws-api")) {
                    HttpSession session = request.getSession();
                    String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
                    try {
                        WSRegistryServiceClient registry = new WSRegistryServiceClient(s2, cookie);
                        List configurations = GovernanceUtils.findGovernanceArtifactConfigurations((Registry)registry);
                        LinkedHashMap customAddUIMap = new LinkedHashMap();
                        LinkedHashMap customViewUIMap = new LinkedHashMap();
                        LinkedList userCustomMenuItemsList = new LinkedList();
                        for (GovernanceArtifactConfiguration configuration : configurations) {
                            OMElement layout;
                            Component component = new Component();
                            OMElement uiConfigurations = configuration.getUIConfigurations();
                            String key = configuration.getKey();
                            String configurationPath = "/_system/config/repository/components/org.wso2.carbon.governance/configuration/";
                            String layoutStoragePath = configurationPath + key;
                            if (!registry.getRegistryContext().getRealmService().getBootstrapRealm().getAuthorizationManager().isUserAuthorized(s, configurationPath, "http://www.wso2.org/projects/registry/actions/add") && !registry.resourceExists(layoutStoragePath)) continue;
                            if (uiConfigurations != null) {
                                ComponentBuilder.processMenus((String)"artifactType", (OMElement)uiConfigurations, (Component)component);
                                ComponentBuilder.processCustomUIs((OMElement)uiConfigurations, (Component)component);
                                List menuList = component.getMenusList();
                                if (menuList.size() == 0) {
                                    GovernanceListUIServiceComponent.this.buildMenuList(request, configuration, menuList, key);
                                }
                                userCustomMenuItemsList.addAll(menuList);
                                customAddUIMap.putAll(component.getCustomAddUIMap());
                                Map viewUIMap = component.getCustomViewUIMap();
                                if (viewUIMap.isEmpty()) {
                                    GovernanceListUIServiceComponent.this.buildViewUI(configuration, viewUIMap, key);
                                }
                                customViewUIMap.putAll(viewUIMap);
                            }
                            if ((layout = configuration.getContentDefinition()) == null || registry.resourceExists(layoutStoragePath)) continue;
                            Resource resource = registry.newResource();
                            resource.setContent((Object)RegistryUtils.encodeString((String)layout.toString()));
                            resource.setMediaType("application/xml");
                            registry.put(layoutStoragePath, resource);
                        }
                        session.setAttribute("UserCustomMenuItems", (Object)userCustomMenuItemsList.toArray(new Menu[userCustomMenuItemsList.size()]));
                        session.setAttribute("customAddUI", customAddUIMap);
                        session.setAttribute("customViewUI", customViewUIMap);
                    }
                    catch (RegistryException e) {
                        log.error((Object)"unable to create connection to registry");
                    }
                    catch (UserStoreException e) {
                        log.error((Object)"unable to realm service");
                    }
                }
            }
        };
        this.serviceRegistration = context.getBundleContext().registerService(UIAuthenticationExtender.class.getName(), (Object)authenticationExtender, null);
        log.debug((Object)"******* Governance List UI bundle is activated ******* ");
    }

    private void buildViewUI(GovernanceArtifactConfiguration configuration, Map<String, String> viewUIMap, String key) {
        String singularLabel = configuration.getSingularLabel();
        String pluralLabel = configuration.getPluralLabel();
        String lifecycleAttribute = key + "Lifecycle_lifecycleName";
        lifecycleAttribute = this.BuilLifecycleAttribute(configuration, DEFAULT_LIFECYCLE_GENERATOR_CLASS, lifecycleAttribute);
        if (singularLabel == null || pluralLabel == null) {
            log.error((Object)("The singular label and plural label have not been defined for the artifact type: " + key));
        } else {
            String path = "../generic/edit_ajaxprocessor.jsp?hideEditView=true&key=" + key + "&lifecycleAttribute=" + lifecycleAttribute + "&add_edit_breadcrumb=" + singularLabel + "&add_edit_region=region3&add_edit_item=governance_add_" + key + "_menu&breadcrumb=" + singularLabel;
            viewUIMap.put(configuration.getMediaType(), path);
        }
    }

    private String BuilLifecycleAttribute(GovernanceArtifactConfiguration configuration, String defaultLifecycleGeneratorClass, String lifecycleAttribute) {
        try {
            OMElement configurationElement = configuration.getContentDefinition();
            String xpathExpression = "//@class";
            AXIOMXPath xpath = new AXIOMXPath(xpathExpression);
            List resultNodes = xpath.selectNodes((Object)configurationElement);
            if (resultNodes != null && resultNodes.size() > 0) {
                String lifecycleParentName = null;
                String lifecycleName = null;
                for (Object resultNode : resultNodes) {
                    OMElement parentElement = ((OMAttribute)resultNode).getOwner();
                    if (parentElement.getAttributeValue(new QName("class")).equals(defaultLifecycleGeneratorClass)) {
                        Iterator childrenIterator = parentElement.getParent().getChildrenWithLocalName("name");
                        while (childrenIterator.hasNext()) {
                            OMElement next = (OMElement)childrenIterator.next();
                            lifecycleName = next.getAttributeValue(new QName("label"));
                        }
                        OMElement rootElement = (OMElement)((OMElement)parentElement.getParent()).getParent();
                        lifecycleParentName = rootElement.getAttributeValue(new QName("name"));
                        break;
                    }
                    if (!parentElement.getAttributeValue(new QName("isLifecycle")).equals("true")) continue;
                    Iterator childrenIterator = parentElement.getParent().getChildrenWithLocalName("name");
                    while (childrenIterator.hasNext()) {
                        OMElement next = (OMElement)childrenIterator.next();
                        lifecycleName = next.getAttributeValue(new QName("label"));
                    }
                    OMElement rootElement = (OMElement)((OMElement)parentElement.getParent()).getParent();
                    lifecycleParentName = rootElement.getAttributeValue(new QName("name"));
                    break;
                }
                if (lifecycleParentName != null && lifecycleName != null) {
                    return this.convertName(lifecycleParentName.split(" ")) + "_" + this.convertName(lifecycleName.split(" "));
                }
            }
        }
        catch (OMException e) {
            log.error((Object)("Governance artifact configuration of configuration key:" + configuration.getKey() + " is invalid"), (Throwable)e);
        }
        catch (JaxenException e) {
            log.error((Object)"Error in getting the lifecycle attribute", (Throwable)e);
        }
        return null;
    }

    private String convertName(String[] nameParts) {
        String convertedName = null;
        for (String namePart : nameParts) {
            char c;
            int i;
            for (i = 0; i < namePart.length() && Character.isLetter(c = namePart.charAt(i)) && !Character.isLowerCase(c); ++i) {
            }
            if (namePart.equals(nameParts[0])) {
                namePart = namePart.substring(0, i).toLowerCase() + namePart.substring(i);
            }
            convertedName = convertedName == null ? namePart : convertedName + namePart;
        }
        return convertedName;
    }

    private void buildMenuList(HttpServletRequest request, GovernanceArtifactConfiguration configuration, List<Menu> menuList, String key) {
        String singularLabel = configuration.getSingularLabel();
        String pluralLabel = configuration.getPluralLabel();
        String lifecycleAttribute = key + "Lifecycle_lifecycleName";
        lifecycleAttribute = this.BuilLifecycleAttribute(configuration, DEFAULT_LIFECYCLE_GENERATOR_CLASS, lifecycleAttribute);
        if (singularLabel == null || pluralLabel == null) {
            log.error((Object)("The singular label and plural label have not been defined for the artifact type: " + key));
        } else {
            int iconSet = configuration.getIconSet();
            if (CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)("/permission/admin/manage/resources/govern/" + key + "/add")) && CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)"/permission/admin/manage/resources/browse") && CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)"/permission/admin/manage/resources/ws-api")) {
                Menu addMenu = new Menu();
                addMenu.setId("governance_add_" + key + "_menu");
                addMenu.setI18nKey(singularLabel);
                addMenu.setParentMenu("add_sub_menu");
                addMenu.setLink("../generic/add_edit.jsp");
                addMenu.setUrlParameters("key=" + key + "&lifecycleAttribute=" + lifecycleAttribute + "&breadcrumb=" + singularLabel);
                addMenu.setRegion("region3");
                addMenu.setOrder("50");
                addMenu.setStyleClass("manage");
                if (iconSet > 0) {
                    addMenu.setIcon("../generic/images/add" + iconSet + ".png");
                } else {
                    addMenu.setIcon("../images/add.gif");
                }
                addMenu.setAllPermissionsRequired(true);
                addMenu.setRequirePermission(new String[]{"/permission/admin/manage/resources/govern/" + key + "/add", "/permission/admin/manage/resources/browse", "/permission/admin/manage/resources/ws-api"});
                menuList.add(addMenu);
            }
            if (CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)("/permission/admin/manage/resources/govern/" + key + "/list")) && CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)"/permission/admin/manage/resources/ws-api")) {
                Menu listMenu = new Menu();
                listMenu.setId("governance_list_" + key + "_menu");
                listMenu.setI18nKey(pluralLabel);
                listMenu.setParentMenu("list_sub_menu");
                listMenu.setLink("../generic/list.jsp");
                listMenu.setUrlParameters("key=" + key + "&breadcrumb=" + pluralLabel + "&singularLabel=" + singularLabel + "&pluralLabel=" + pluralLabel);
                listMenu.setRegion("region3");
                listMenu.setOrder("50");
                listMenu.setStyleClass("manage");
                if (iconSet > 0) {
                    listMenu.setIcon("../generic/images/list" + iconSet + ".png");
                } else {
                    listMenu.setIcon("../images/list.gif");
                }
                listMenu.setAllPermissionsRequired(true);
                listMenu.setRequirePermission(new String[]{"/permission/admin/manage/resources/govern/" + key + "/list", "/permission/admin/manage/resources/ws-api"});
                menuList.add(listMenu);
            }
            if (CarbonUIUtil.isUserAuthorized((HttpServletRequest)request, (String)("/permission/admin/configure/governance/" + key + "-ui"))) {
                Menu configureMenu = new Menu();
                configureMenu.setId("governance_" + key + "_config_menu");
                configureMenu.setI18nKey(pluralLabel);
                configureMenu.setParentMenu("configure_menu");
                configureMenu.setLink("../generic/configure.jsp");
                configureMenu.setUrlParameters("key=" + key + "&breadcrumb=" + pluralLabel + "&add_edit_region=region3&add_edit_item=governance_add_" + key + "_menu" + "&lifecycleAttribute=" + lifecycleAttribute + "&add_edit_breadcrumb=" + singularLabel + "&singularLabel=" + singularLabel + "&pluralLabel=" + pluralLabel);
                configureMenu.setRegion("region1");
                configureMenu.setOrder("40");
                configureMenu.setStyleClass("manage");
                if (iconSet > 0) {
                    configureMenu.setIcon("../generic/images/configure" + iconSet + ".png");
                } else {
                    configureMenu.setIcon("../generic/images/services1.gif");
                }
                configureMenu.setRequirePermission(new String[]{"/permission/admin/configure/governance/" + key + "-ui"});
                menuList.add(configureMenu);
            }
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        log.debug((Object)"Governance List UI bundle is deactivated ");
    }

    protected void setCarbonUIAuthenticator(CarbonUIAuthenticator uiAuthenticator) {
    }

    protected void unsetCarbonUIAuthenticator(CarbonUIAuthenticator uiAuthenticator) {
    }
}

