/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.list.stub.ListMetadataServiceStub;
import org.wso2.carbon.governance.list.stub.beans.xsd.PolicyBean;
import org.wso2.carbon.governance.list.stub.beans.xsd.SchemaBean;
import org.wso2.carbon.governance.list.stub.beans.xsd.ServiceBean;
import org.wso2.carbon.governance.list.stub.beans.xsd.WSDLBean;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ListMetadataServiceClient {
    private static final Log log = LogFactory.getLog(ListMetadataServiceClient.class);
    private ListMetadataServiceStub stub;
    private String epr;

    public ListMetadataServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "ListMetadataService";
        try {
            this.stub = new ListMetadataServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate ListMetadataServices service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ListMetadataServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "ListMetadataService";
        try {
            this.stub = new ListMetadataServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate Add Services service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ServiceBean listservices(String criteria) throws Exception {
        return this.stub.listservices(criteria);
    }

    public WSDLBean listwsdls() throws Exception {
        return this.stub.listwsdls();
    }

    public PolicyBean listpolicies() throws Exception {
        return this.stub.listpolicies();
    }

    public SchemaBean listschemas() throws Exception {
        return this.stub.listschema();
    }
}

