/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.services;

import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactFilter;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.generic.beans.ArtifactBean;
import org.wso2.carbon.governance.generic.beans.ArtifactsBean;
import org.wso2.carbon.governance.list.util.GovernanceArtifactFilter;
import org.wso2.carbon.governance.services.util.Util;
import org.wso2.carbon.registry.admin.api.governance.IManageGenericArtifactService;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class ManageGenericArtifactService
extends RegistryAbstractAdmin
implements IManageGenericArtifactService {
    private static final Log log = LogFactory.getLog(ManageGenericArtifactService.class);
    private static final String GOVERNANCE_ARTIFACT_CONFIGURATION_PATH = "/repository/components/org.wso2.carbon.governance/configuration/";

    public String addArtifact(String key, String info, String lifecycleAttribute) throws RegistryException {
        RegistryUtils.recordStatistics((Object[])new Object[]{key, info, lifecycleAttribute});
        Registry registry = this.getGovernanceUserRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return null;
        }
        try {
            String lifecycle;
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(info));
            GovernanceArtifactConfiguration configuration = GovernanceUtils.findGovernanceArtifactConfiguration((String)key, (Registry)this.getRootRegistry());
            GenericArtifactManager manager = new GenericArtifactManager(registry, configuration.getMediaType(), configuration.getArtifactNameAttribute(), configuration.getArtifactNamespaceAttribute(), configuration.getArtifactElementRoot(), configuration.getArtifactElementNamespace(), configuration.getPathExpression(), configuration.getRelationshipDefinitions());
            GenericArtifact artifact = manager.newGovernanceArtifact(new StAXOMBuilder(reader).getDocumentElement());
            manager.addGenericArtifact(artifact);
            if (lifecycleAttribute != null && (lifecycle = artifact.getAttribute(lifecycleAttribute)) != null) {
                artifact.attachLifecycle(lifecycle);
            }
            return "/_system/governance" + artifact.getPath();
        }
        catch (Exception e) {
            String msg = "Unable to add artifact. ";
            if (e instanceof RegistryException) {
                throw (RegistryException)e;
            }
            if (e instanceof OMException) {
                msg = msg + "Unexpected character found in input-field name.";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
            throw new RegistryException(msg + (e.getCause() instanceof SQLException ? "" : e.getCause().getMessage()), (Throwable)e);
        }
    }

    public ArtifactsBean listArtifacts(String key, String criteria) {
        RegistryUtils.recordStatistics((Object[])new Object[]{key, criteria});
        UserRegistry governanceRegistry = (UserRegistry)this.getGovernanceUserRegistry();
        ArtifactsBean bean = new ArtifactsBean();
        try {
            GenericArtifact referenceArtifact;
            GovernanceArtifactConfiguration configuration = GovernanceUtils.findGovernanceArtifactConfiguration((String)key, (Registry)this.getRootRegistry());
            GenericArtifactManager manager = new GenericArtifactManager((Registry)governanceRegistry, configuration.getMediaType(), configuration.getArtifactNameAttribute(), configuration.getArtifactNamespaceAttribute(), configuration.getArtifactElementRoot(), configuration.getArtifactElementNamespace(), configuration.getPathExpression(), configuration.getRelationshipDefinitions());
            if (criteria != null) {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(criteria));
                referenceArtifact = manager.newGovernanceArtifact(new StAXOMBuilder(reader).getDocumentElement());
            } else {
                referenceArtifact = null;
            }
            GenericArtifactFilter artifactFilter = new GenericArtifactFilter(){
                GovernanceArtifactFilter filter;
                {
                    this.filter = new GovernanceArtifactFilter((GovernanceArtifact)referenceArtifact);
                }

                public boolean matches(GenericArtifact artifact) throws GovernanceException {
                    return this.filter.matches((GovernanceArtifact)artifact);
                }
            };
            bean.setNames(configuration.getNamesOnListUI());
            bean.setTypes(configuration.getTypesOnListUI());
            String[] expressions = configuration.getExpressionsOnListUI();
            String[] keys = configuration.getKeysOnListUI();
            GenericArtifact[] artifacts = manager.findGenericArtifacts(artifactFilter);
            if (artifacts != null) {
                LinkedList<ArtifactBean> artifactBeans = new LinkedList<ArtifactBean>();
                for (GenericArtifact artifact : artifacts) {
                    ArtifactBean artifactBean = new ArtifactBean();
                    ArrayList<String> paths = new ArrayList<String>();
                    ArrayList<String> values = new ArrayList<String>();
                    String path = "/_system/governance" + artifact.getPath();
                    artifactBean.setPath(path);
                    for (String expression : expressions) {
                        if (expression != null) {
                            if (expression.contains("@{storagePath}") && artifact.getPath() != null) {
                                paths.add("/_system/governance" + GovernanceUtils.getPathFromPathExpression((String)expression, (GovernanceArtifact)artifact, (String)artifact.getPath()));
                                continue;
                            }
                            paths.add("/_system/governance" + GovernanceUtils.getPathFromPathExpression((String)expression, (GovernanceArtifact)artifact, (String)configuration.getPathExpression()));
                            continue;
                        }
                        paths.add("");
                    }
                    artifactBean.setValuesB(paths.toArray(new String[paths.size()]));
                    for (String keyForValue : keys) {
                        if (keyForValue != null) {
                            values.add(artifact.getAttribute(keyForValue));
                            continue;
                        }
                        values.add("");
                    }
                    artifactBean.setValuesA(values.toArray(new String[values.size()]));
                    artifactBean.setCanDelete(governanceRegistry.getUserRealm().getAuthorizationManager().isUserAuthorized(governanceRegistry.getUserName(), path, "http://www.wso2.org/projects/registry/actions/delete"));
                    artifactBean.setLCName(artifact.getLifecycleName());
                    artifactBean.setLCState(artifact.getLifecycleState());
                    artifactBeans.add(artifactBean);
                }
                bean.setArtifacts(artifactBeans.toArray(new ArtifactBean[artifactBeans.size()]));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while obtaining the list of artifacts.", (Throwable)e);
        }
        return bean;
    }

    public String editArtifact(String key, String info, String lifecycleAttribute) throws RegistryException {
        RegistryUtils.recordStatistics((Object[])new Object[]{key, info, lifecycleAttribute});
        Registry registry = this.getGovernanceUserRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return null;
        }
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(info));
            GovernanceArtifactConfiguration configuration = GovernanceUtils.findGovernanceArtifactConfiguration((String)key, (Registry)this.getRootRegistry());
            GenericArtifactManager manager = new GenericArtifactManager(registry, configuration.getMediaType(), configuration.getArtifactNameAttribute(), configuration.getArtifactNamespaceAttribute(), configuration.getArtifactElementRoot(), configuration.getArtifactElementNamespace(), configuration.getPathExpression(), configuration.getRelationshipDefinitions());
            GenericArtifact artifact = manager.newGovernanceArtifact(new StAXOMBuilder(reader).getDocumentElement());
            String currentPath = GovernanceUtils.getPathFromPathExpression((String)configuration.getPathExpression(), (GovernanceArtifact)artifact);
            if (registry.resourceExists(currentPath)) {
                GovernanceArtifact oldArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath((Registry)registry, (String)currentPath);
                if (!(oldArtifact instanceof GenericArtifact)) {
                    String msg = "The updated path is occupied by a non-generic artifact. path: " + currentPath + ".";
                    log.error((Object)msg);
                    throw new Exception(msg);
                }
                String id = oldArtifact.getId();
                artifact.setId(id);
                manager.updateGenericArtifact(artifact);
            } else {
                manager.addGenericArtifact(artifact);
            }
            if (lifecycleAttribute != null && !lifecycleAttribute.equals("null")) {
                String lifecycle = artifact.getAttribute(lifecycleAttribute);
                artifact.attachLifecycle(lifecycle);
            }
            return "/_system/governance" + artifact.getPath();
        }
        catch (Exception e) {
            String msg = "Unable to edit artifact. ";
            if (e instanceof RegistryException) {
                throw (RegistryException)e;
            }
            if (e instanceof OMException) {
                msg = msg + "Unexpected character found in input-field name.";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
            throw new RegistryException(msg + (e.getCause() instanceof SQLException ? "" : e.getCause().getMessage()), (Throwable)e);
        }
    }

    public String getArtifactContent(String path) throws RegistryException {
        Registry registry = this.getGovernanceUserRegistry();
        if (!registry.resourceExists(new ResourcePath(path).getPath())) {
            return null;
        }
        return RegistryUtils.decodeBytes((byte[])((byte[])registry.get(path).getContent()));
    }

    public String getArtifactUIConfiguration(String key) throws RegistryException {
        try {
            Registry registry = this.getConfigSystemRegistry();
            return RegistryUtils.decodeBytes((byte[])((byte[])registry.get(GOVERNANCE_ARTIFACT_CONFIGURATION_PATH + key).getContent()));
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while obtaining configuration", (Throwable)e);
            return null;
        }
    }

    public boolean setArtifactUIConfiguration(String key, String update) throws RegistryException {
        Registry registry = this.getConfigSystemRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        try {
            Util.validateOMContent((OMElement)Util.buildOMElement((String)update));
            String path = GOVERNANCE_ARTIFACT_CONFIGURATION_PATH + key;
            Resource resource = registry.get(path);
            resource.setContent((Object)update);
            registry.put(path, resource);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while saving configuration", (Throwable)e);
            return false;
        }
    }

    public boolean canChange(String path) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (registry.getUserName() != null && registry.getUserRealm() != null && registry.getUserRealm().getAuthorizationManager().isUserAuthorized(registry.getUserName(), path, "http://www.wso2.org/projects/registry/actions/add")) {
            Resource resource = registry.get(path);
            String property = resource.getProperty("registry.retention.writeLocked");
            return property == null || !Boolean.parseBoolean(property) || registry.getUserName().equals(resource.getProperty("registry.retention.user.name"));
        }
        return false;
    }

    public String[] getAvailableAspects() throws Exception {
        return GovernanceUtils.getAvailableAspects();
    }
}

