/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.gadgets.ui;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.gadgets.stub.ResourceImpactAdminServiceStub;
import org.wso2.carbon.governance.gadgets.stub.beans.xsd.AssociationBean;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ResourceImpactAdminClient {
    private static final Log log = LogFactory.getLog(ResourceImpactAdminClient.class);
    ResourceImpactAdminServiceStub stub;

    public ResourceImpactAdminClient(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String serviceURL = backendServerURL + "ResourceImpactAdminService";
        this.stub = new ResourceImpactAdminServiceStub(configContext, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public AssociationBean[] getResourceAssociations(String path, boolean reverse) {
        AssociationBean[] associationBeans = new AssociationBean[]{};
        try {
            associationBeans = this.stub.getAssociations(path, reverse);
        }
        catch (Exception e) {
            String msg = "Failed to get associations for " + path;
            log.error((Object)msg, (Throwable)e);
        }
        return associationBeans;
    }
}

