/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.gadgets.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.policies.PolicyFilter;
import org.wso2.carbon.governance.api.policies.PolicyManager;
import org.wso2.carbon.governance.api.policies.dataobjects.Policy;
import org.wso2.carbon.governance.api.schema.SchemaFilter;
import org.wso2.carbon.governance.api.schema.SchemaManager;
import org.wso2.carbon.governance.api.schema.dataobjects.Schema;
import org.wso2.carbon.governance.api.services.ServiceFilter;
import org.wso2.carbon.governance.api.services.ServiceManager;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.api.wsdls.WsdlFilter;
import org.wso2.carbon.governance.api.wsdls.WsdlManager;
import org.wso2.carbon.governance.api.wsdls.dataobjects.Wsdl;
import org.wso2.carbon.governance.gadgets.stub.beans.xsd.AssociationBean;
import org.wso2.carbon.governance.gadgets.ui.ResourceImpactAdminClient;
import org.wso2.carbon.governance.gadgets.ui.beans.AssociationBeanLocal;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.ws.client.registry.WSRegistryServiceClient;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ResourceImpactDataProcesssor {
    ResourceImpactAdminClient client;
    Registry registry;
    boolean reverse = false;

    public ResourceImpactDataProcesssor(ServletConfig config, HttpSession session, HttpServletRequest request) throws Exception {
        this.client = new ResourceImpactAdminClient(config, session, request);
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        this.registry = GovernanceUtils.getGovernanceUserRegistry((Registry)new WSRegistryServiceClient(backendServerURL, cookie), (String)((String)session.getAttribute("logged-user")));
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public String getResourceImpactJSONTree(String path) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildOpenJSONForNameandChildren("Assets"));
        HashSet<String> processedPathList = new HashSet<String>();
        if (path.length() == 0 || path.startsWith("/")) {
            this.addChildPathsToBuilder(path, builder, true, processedPathList);
        } else {
            Policy[] policies;
            Schema[] schemas;
            Wsdl[] wsdls;
            Service[] services;
            final String referenceValue = path;
            boolean first = true;
            for (Service service : services = new ServiceManager(this.registry).findServices(new ServiceFilter(){

                public boolean matches(Service service) throws GovernanceException {
                    String realValue = service.getQName().getLocalPart();
                    try {
                        return realValue.contains(referenceValue) || realValue.matches(referenceValue);
                    }
                    catch (Exception e) {
                        throw new GovernanceException("Error in performing the matches for: " + referenceValue + ".", (Throwable)e);
                    }
                }
            })) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" , \n");
                }
                this.addChildPathsToBuilder("/_system/governance" + service.getPath(), builder, true, processedPathList);
            }
            for (Wsdl wsdl : wsdls = new WsdlManager(this.registry).findWsdls(new WsdlFilter(){

                public boolean matches(Wsdl wsdl) throws GovernanceException {
                    String realValue = wsdl.getQName().getLocalPart();
                    try {
                        return realValue.contains(referenceValue) || realValue.matches(referenceValue);
                    }
                    catch (Exception e) {
                        throw new GovernanceException("Error in performing the matches for: " + referenceValue + ".", (Throwable)e);
                    }
                }
            })) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" , \n");
                }
                this.addChildPathsToBuilder("/_system/governance" + wsdl.getPath(), builder, true, processedPathList);
            }
            for (Schema schema : schemas = new SchemaManager(this.registry).findSchemas(new SchemaFilter(){

                public boolean matches(Schema schema) throws GovernanceException {
                    String realValue = schema.getQName().getLocalPart();
                    try {
                        return realValue.contains(referenceValue) || realValue.matches(referenceValue);
                    }
                    catch (Exception e) {
                        throw new GovernanceException("Error in performing the matches for: " + referenceValue + ".", (Throwable)e);
                    }
                }
            })) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" , \n");
                }
                this.addChildPathsToBuilder("/_system/governance" + schema.getPath(), builder, true, processedPathList);
            }
            for (Policy policy : policies = new PolicyManager(this.registry).findPolicies(new PolicyFilter(){

                public boolean matches(Policy policy) throws GovernanceException {
                    String realValue = policy.getQName().getLocalPart();
                    try {
                        return realValue.contains(referenceValue) || realValue.matches(referenceValue);
                    }
                    catch (Exception e) {
                        throw new GovernanceException("Error in performing the matches for: " + referenceValue + ".", (Throwable)e);
                    }
                }
            })) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" , \n");
                }
                this.addChildPathsToBuilder("/_system/governance" + policy.getPath(), builder, true, processedPathList);
            }
        }
        builder.append(this.buildCloseJSONForNameandChildren());
        return builder.toString();
    }

    private boolean addChildPathsToBuilder(String path, StringBuilder builder, boolean addEmptyMessage, Set<String> processedPaths) throws Exception {
        ArrayList<AssociationBeanLocal> associationBeans = this.getBean(path, processedPaths, true);
        return this.processBean(path, builder, addEmptyMessage, processedPaths, associationBeans);
    }

    private boolean processBean(String path, StringBuilder builder, boolean addEmptyMessage, Set<String> processedPaths, ArrayList<AssociationBeanLocal> associationBeans) throws Exception {
        associationBeans.trimToSize();
        if (!associationBeans.isEmpty()) {
            builder.append(this.buildOpenJSONForNameandChildren(this.trimPath(path)));
            int k = 1;
            for (AssociationBeanLocal bean : associationBeans) {
                String currentType = bean.getAssociationType();
                builder.append(this.buildOpenJSONForNameandChildren(currentType));
                ArrayList<AssociationBeanLocal.DestinationPath> paths = bean.getDestinationPaths();
                paths.trimToSize();
                int i = 1;
                for (AssociationBeanLocal.DestinationPath destinationPath : paths) {
                    String destination = this.trimPath(destinationPath.getPath());
                    builder.append(this.buildOpenJSONForNameandChildren(destination));
                    if (destinationPath.getAssociations().size() > 0) {
                        this.addChildPathsToBuilder(destinationPath.getPath(), builder, false, processedPaths);
                    }
                    builder.append(this.buildCloseJSONForNameandChildren());
                    if (i != paths.size()) {
                        builder.append(" , \n");
                    }
                    ++i;
                }
                builder.append("\n");
                builder.append(this.buildCloseJSONForNameandChildren());
                if (k != associationBeans.size()) {
                    builder.append(" , \n");
                }
                ++k;
            }
            builder.append(this.buildCloseJSONForNameandChildren());
            return true;
        }
        if (addEmptyMessage) {
            builder.append(this.buildOpenJSONForNameandChildren(""));
        }
        builder.append(this.buildCloseJSONForNameandChildren());
        return false;
    }

    private String trimPath(String originalPath) {
        String[] parts = originalPath.split("/");
        int index = parts.length - 1;
        String part = parts[index];
        if (index == 0) {
            return part;
        }
        if (part.equals("service")) {
            part = parts[--index];
        }
        if (index != 0) {
            String regEx = "^\\d+[.]\\d+[.]\\d+(-[a-zA-Z0-9]+)?$".replace("$", "(-[a-zA-Z0-9]+)?$");
            if (part.matches(regEx)) {
                return parts[index - 1] + " - " + part;
            }
            if (parts[index - 1].matches(regEx)) {
                return part + " - " + parts[index - 1];
            }
        }
        return part;
    }

    private ArrayList<AssociationBeanLocal> getBean(String path, Set<String> processedList, boolean expandPaths) throws Exception {
        AssociationBean[] associations = this.client.getResourceAssociations(path, this.reverse);
        ArrayList<String> associationTypeList = new ArrayList<String>();
        ArrayList<AssociationBeanLocal> beanList = new ArrayList<AssociationBeanLocal>();
        LinkedHashMap<String, AssociationBeanLocal> pathMap = new LinkedHashMap<String, AssociationBeanLocal>();
        if (associations != null) {
            for (int i = 0; i < associations.length; ++i) {
                String pathToAdd;
                String currentType = associations[i].getAssociationType();
                String currentDestPath = associations[i].getDestinationPath();
                String currentSourcePath = associations[i].getSourcePath();
                String string = pathToAdd = currentDestPath.equals(path) ? currentSourcePath : currentDestPath;
                if (!associationTypeList.contains(currentType)) {
                    associationTypeList.add(currentType);
                    AssociationBeanLocal assoBean = new AssociationBeanLocal();
                    assoBean.setAssociationType(currentType);
                    if (expandPaths) {
                        pathMap.put(pathToAdd, assoBean);
                    }
                    beanList.add(assoBean);
                    continue;
                }
                if (!expandPaths) continue;
                for (AssociationBeanLocal bean : beanList) {
                    if (!bean.getAssociationType().equals(currentType)) continue;
                    pathMap.put(pathToAdd, bean);
                }
            }
            for (Map.Entry e : pathMap.entrySet()) {
                String key = (String)e.getKey();
                if (processedList.contains(e.getKey())) {
                    ((AssociationBeanLocal)e.getValue()).setDestinationPaths(key, new ArrayList<AssociationBeanLocal>());
                    continue;
                }
                processedList.add(key);
                ((AssociationBeanLocal)e.getValue()).setDestinationPaths(key, this.getBean(key, processedList, true));
            }
        }
        return beanList;
    }

    private String buildCloseJSONForNameandChildren() {
        StringBuilder builder = new StringBuilder();
        builder.append("] } \n");
        return builder.toString();
    }

    private String buildOpenJSONForNameandChildren(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        builder.append(this.buildJSONforBeanAttributes(UUID.randomUUID().toString(), name, "") + this.appendChildrenJSON());
        return builder.toString();
    }

    private String appendChildrenJSON() {
        return ", \"children\" : [";
    }

    private String buildJSONforBeanAttributes(String id, String name, String path) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildJSONNameValuePair("id", id) + "," + this.buildJSONNameValuePair("name", name) + "," + this.buildJSONNameValuePair("data", "{}"));
        return builder.toString();
    }

    private String buildJSONwithNoChildren(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ").append(this.buildJSONforBeanAttributes(UUID.randomUUID().toString(), name, ""));
        builder.append(", ").append(this.buildJSONNameValuePair("children", "[]")).append("}");
        return builder.toString();
    }

    private String buildJSONNameValuePair(String name, String value) {
        if (value.contentEquals("[]") || value.contentEquals("{}")) {
            return "\"" + name + "\" : " + value + " ";
        }
        return "\"" + name + "\" : \"" + value + "\" ";
    }
}

