/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.gadgets.impactanalysis.services.util;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.policies.dataobjects.Policy;
import org.wso2.carbon.governance.api.schema.dataobjects.Schema;
import org.wso2.carbon.governance.api.services.ServiceManager;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.api.wsdls.dataobjects.Wsdl;
import org.wso2.carbon.governance.gadgets.impactanalysis.beans.ImpactBean;
import org.wso2.carbon.governance.gadgets.impactanalysis.beans.PolicyBean;
import org.wso2.carbon.governance.gadgets.impactanalysis.beans.SchemaBean;
import org.wso2.carbon.governance.gadgets.impactanalysis.beans.ServiceBean;
import org.wso2.carbon.governance.gadgets.impactanalysis.beans.WSDLBean;

public class BeanUtils {
    private static final Log log = LogFactory.getLog(BeanUtils.class);

    public static ImpactBean populateImpactBean(ServiceManager manager) throws GovernanceException {
        ImpactBean impactBean = new ImpactBean();
        impactBean.setServiceBean(BeanUtils.populateServicesBean(manager));
        return impactBean;
    }

    public static ServiceBean[] populateServicesBean(ServiceManager manager) throws GovernanceException {
        String[] serviceIds = manager.getAllServiceIds();
        if (serviceIds == null) {
            return null;
        }
        ServiceBean[] serviceBeans = new ServiceBean[serviceIds.length];
        for (int i = 0; i < serviceIds.length; ++i) {
            Service service;
            serviceBeans[i] = new ServiceBean();
            if (serviceIds[i] == null || (service = manager.getService(serviceIds[i])) == null) continue;
            serviceBeans[i].setWsdlBeans(BeanUtils.populateWSDLBean(service.getAttachedWsdls()));
            serviceBeans[i].setSchemaBeans(BeanUtils.populateSchemaBean(service.getAttachedSchemas()));
            serviceBeans[i].setPolicyBeans(BeanUtils.populatePolicyBean(service.getAttachedPolicies()));
            serviceBeans[i].setId(service.getId());
            serviceBeans[i].setPath(service.getPath());
            serviceBeans[i].setqName(BeanUtils.getName(service.getQName()));
        }
        return serviceBeans;
    }

    public static WSDLBean[] populateWSDLBean(Wsdl[] wsdls) throws GovernanceException {
        if (wsdls == null) {
            return null;
        }
        WSDLBean[] wsdlBean = new WSDLBean[wsdls.length];
        for (int j = 0; j < wsdls.length; ++j) {
            wsdlBean[j] = new WSDLBean();
            if (wsdls[j] == null) continue;
            wsdlBean[j].setId(wsdls[j].getId());
            wsdlBean[j].setPath(wsdls[j].getPath());
            wsdlBean[j].setqName(BeanUtils.getName(wsdls[j].getQName()));
            wsdlBean[j].setAttachedSchemas(BeanUtils.populateSchemaBean(wsdls[j].getAttachedSchemas()));
        }
        return wsdlBean;
    }

    public static PolicyBean[] populatePolicyBean(Policy[] policies) {
        if (policies == null) {
            return null;
        }
        PolicyBean[] policyBean = new PolicyBean[policies.length];
        for (int j = 0; j < policies.length; ++j) {
            policyBean[j] = new PolicyBean();
            if (policies[j] == null) continue;
            policyBean[j].setId(policies[j].getId());
            try {
                policyBean[j].setPath(policies[j].getPath());
            }
            catch (GovernanceException e) {
                String msg = "Error in getting the path from the policy.";
                log.error((Object)msg, (Throwable)e);
            }
            policyBean[j].setqName(BeanUtils.getName(policies[j].getQName()));
        }
        return policyBean;
    }

    public static SchemaBean[] populateSchemaBean(Schema[] schemas) {
        if (schemas == null) {
            return null;
        }
        SchemaBean[] schemaBean = new SchemaBean[schemas.length];
        for (int j = 0; j < schemas.length; ++j) {
            schemaBean[j] = new SchemaBean();
            if (schemas[j] == null) continue;
            schemaBean[j].setId(schemas[j].getId());
            try {
                schemaBean[j].setPath(schemas[j].getPath());
            }
            catch (GovernanceException e) {
                String msg = "Error in getting the path.";
                log.error((Object)msg);
            }
            schemaBean[j].setqName(BeanUtils.getName(schemas[j].getQName()));
        }
        return schemaBean;
    }

    private static String getName(QName qName) {
        return qName.getLocalPart() + " - " + qName.getNamespaceURI();
    }
}

