/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.gadgets.ui;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.governance.gadgets.stub.governance.gadgetsource.beans.xsd.LifecycleInfoBean;
import org.wso2.carbon.governance.gadgets.stub.governance.gadgetsource.beans.xsd.LifecyclePiechartGadgetBean;
import org.wso2.carbon.governance.gadgets.stub.governance.gadgetsource.beans.xsd.LifecycleStageInfoBean;
import org.wso2.carbon.governance.gadgets.ui.GadgetSourceServiceClient;
import org.wso2.carbon.ui.CarbonUIUtil;

public class GadgetSourceServiceDataProcessor {
    GadgetSourceServiceClient client;

    public GadgetSourceServiceDataProcessor(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        this.client = new GadgetSourceServiceClient(cookie, backendServerURL, configContext, request.getLocale());
    }

    public String getLifeCycles() {
        LifecyclePiechartGadgetBean gadgetBean = this.client.getLifecyclePiechartGadgetData();
        StringBuilder lifeCycleNames = new StringBuilder();
        if (gadgetBean != null) {
            LifecycleInfoBean[] lifecycles;
            for (LifecycleInfoBean lifecycle : lifecycles = gadgetBean.getLifecycles()) {
                lifeCycleNames.append(lifecycle.getName()).append(";");
            }
        }
        return lifeCycleNames.toString();
    }

    public String getLifeCyleDataforPieChart(String lifeCycleName) {
        String data = "";
        LifecyclePiechartGadgetBean gadgetBean = this.client.getLifecyclePiechartGadgetData();
        if (gadgetBean != null) {
            LifecycleInfoBean[] lifecycles = gadgetBean.getLifecycles();
            LifecycleInfoBean currentLIBean = null;
            for (LifecycleInfoBean infoBean : lifecycles) {
                if (!infoBean.getName().equals(lifeCycleName)) continue;
                currentLIBean = infoBean;
            }
            String pieChartLables = "";
            String pieChartValues = "";
            LifecycleStageInfoBean[] stages = currentLIBean.getStages();
            for (int y = 0; y < stages.length; ++y) {
                LifecycleStageInfoBean currentStage = stages[y];
                if (y == 0) {
                    pieChartLables = currentStage.getName();
                    pieChartValues = String.valueOf(currentStage.getServiceCount());
                    continue;
                }
                pieChartLables = pieChartLables + "," + currentStage.getName();
                pieChartValues = pieChartValues + "," + currentStage.getServiceCount();
            }
            data = "&bg_colour=#ffffff&\n&x_axis_steps=1&\n&y_ticks=5,10,5&\n&line=3,#87421F&\n&y_min=0&\n&y_max=20&\n&pie=60,#505050,{font-size: 12px; color: #404040;&\n&values=" + pieChartValues + "&\n" + "&pie_labels=" + pieChartLables + "&\n" + "&colours=#d01f3c,#356aa0,#C78810,#66CC66,#999999,#CC66CC,#99CC33&\n" + "&links=&\n" + "&tool_tip=%23val%23&";
        } else {
            data = "&bg_colour=#ffffff&\n&x_axis_steps=1&\n&y_ticks=5,10,5&\n&line=3,#87421F&\n&y_min=0&\n&y_max=20&\n&pie=60,#505050,{font-size: 12px; color: #404040;&\n&values=0&\n&pie_labels=Life Cycle Data Not Available.&\n&colours=#d01f3c,#356aa0,#C78810,#66CC66,#999999,#CC66CC,#99CC33&\n&links=&\n&tool_tip=%23val%23&";
        }
        return data;
    }
}

