/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.gadgets.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.policies.dataobjects.Policy;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.ws.client.registry.WSRegistryServiceClient;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.user.mgt.common.FlaggedName;
import org.wso2.carbon.user.mgt.ui.UserAdminClient;

public class ProjectDataProcessor {
    private static final Log log = LogFactory.getLog(ProjectDataProcessor.class);
    private Registry registry;
    private UserAdminClient userManager;

    public ProjectDataProcessor(HttpServletRequest request, ServletConfig config) {
        HttpSession session = request.getSession();
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        try {
            this.registry = GovernanceUtils.getGovernanceUserRegistry((Registry)new WSRegistryServiceClient(backendServerURL, cookie), (String)((String)session.getAttribute("logged-user")));
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to obtain an instance of the registry.", (Throwable)e);
        }
        try {
            this.userManager = new UserAdminClient(cookie, backendServerURL, configContext);
        }
        catch (Exception e) {
            log.error((Object)"Unable to create connection to User Manager", (Throwable)e);
        }
    }

    public String getJSONTree() throws Exception {
        String key = "projects";
        GenericArtifactManager manager = new GenericArtifactManager(this.registry, key);
        GenericArtifact[] projects = manager.getAllGenericArtifacts();
        LinkedList projectList = new LinkedList();
        Map projectsMap = Collections.singletonMap("projects", Collections.singletonMap("project", projectList));
        if (projects != null) {
            for (GenericArtifact project : projects) {
                String[] products;
                String plan_issueTracker;
                String cost_actual;
                String timeline_endDate;
                LinkedHashMap<String, Object> projectMap = new LinkedHashMap<String, Object>();
                projectMap.put("name", project.getAttribute("overview_name"));
                String projectManager = project.getAttribute("overview_projectManager");
                projectMap.put("manager", projectManager);
                String timeline_startDate = project.getAttribute("timeline_startDate");
                if (timeline_startDate != null) {
                    projectMap.put("startdate", timeline_startDate);
                }
                if ((timeline_endDate = project.getAttribute("timeline_endDate")) != null) {
                    projectMap.put("enddate", timeline_endDate);
                }
                if ((cost_actual = project.getAttribute("cost_actual")) != null) {
                    projectMap.put("cost", cost_actual);
                }
                if ((plan_issueTracker = project.getAttribute("plan_issueTracker")) != null) {
                    projectMap.put("jira", plan_issueTracker);
                }
                LinkedList roleList = new LinkedList();
                projectMap.put("roles", Collections.singletonMap("role", roleList));
                String members_roles = project.getAttribute("members_roles");
                if (members_roles != null) {
                    String[] roles;
                    for (String role : roles = members_roles.split(",")) {
                        FlaggedName[] usersOfRole;
                        LinkedHashMap<String, Object> roleMap = new LinkedHashMap<String, Object>();
                        roleMap.put("name", role);
                        LinkedList<Map<String, String>> memberList = new LinkedList<Map<String, String>>();
                        roleMap.put("member", memberList);
                        for (FlaggedName flaggedName : usersOfRole = this.userManager.getUsersOfRole(role, "*")) {
                            if (!flaggedName.isSelected()) continue;
                            memberList.add(Collections.singletonMap("name", flaggedName.getItemName()));
                        }
                        roleList.add(roleMap);
                    }
                }
                LinkedHashMap<String, Object> roleMap = new LinkedHashMap<String, Object>();
                roleMap.put("name", "manager");
                LinkedHashMap memberMap = new LinkedHashMap();
                roleMap.put("member", Collections.singletonMap("name", projectManager));
                roleList.add(roleMap);
                String[] assets = project.getAttributes("assets_entry");
                if (assets != null) {
                    LinkedList<String> policies = new LinkedList<String>();
                    LinkedList<String> services = new LinkedList<String>();
                    for (String asset : assets) {
                        String[] stringArray = asset.split(":");
                        if (stringArray.length != 2) continue;
                        if (stringArray[0].equals("Service")) {
                            services.add(stringArray[1]);
                            continue;
                        }
                        if (!stringArray[0].equals("Policy")) continue;
                        policies.add(RegistryUtils.getResourceName((String)stringArray[1]));
                    }
                    LinkedList policyList = new LinkedList();
                    projectMap.put("policies", Collections.singletonMap("policy", policyList));
                    for (String policy : policies) {
                        LinkedHashMap<String, String> policyMap = new LinkedHashMap<String, String>();
                        policyMap.put("name", policy);
                        policyList.add(policyMap);
                    }
                    LinkedList serviceList = new LinkedList();
                    LinkedHashMap versionMap = new LinkedHashMap();
                    for (String string : services) {
                        HashMap<String, String> enforcement;
                        Service artifact = (Service)GovernanceUtils.retrieveGovernanceArtifactByPath((Registry)this.registry, (String)string);
                        Policy[] attachedPolicies = artifact.getAttachedPolicies();
                        LinkedList<String> enforcedPolicies = new LinkedList<String>();
                        if (attachedPolicies != null && attachedPolicies.length >= 0 && policies.size() > 0) {
                            for (Policy policy : attachedPolicies) {
                                String policyName = RegistryUtils.getResourceName((String)policy.getPath());
                                if (!policies.contains(policyName)) continue;
                                enforcedPolicies.add(policyName);
                                if (enforcedPolicies.size() == policies.size()) break;
                            }
                        }
                        String name = artifact.getQName().getLocalPart();
                        String version = artifact.getAttribute("overview_version");
                        LinkedList nonEnforcedPolicies = new LinkedList(policies);
                        nonEnforcedPolicies.removeAll(enforcedPolicies);
                        LinkedList servicePolicies = new LinkedList();
                        for (String entry : enforcedPolicies) {
                            enforcement = new HashMap<String, String>();
                            enforcement.put("name", entry);
                            enforcement.put("policyEnforcement", "yes");
                            servicePolicies.add(enforcement);
                        }
                        for (String entry : nonEnforcedPolicies) {
                            enforcement = new HashMap();
                            enforcement.put("name", entry);
                            enforcement.put("policyEnforcement", "no");
                            servicePolicies.add(enforcement);
                        }
                        LinkedHashMap<String, Object> temp = new LinkedHashMap<String, Object>();
                        temp.put("name", version);
                        temp.put("policy", servicePolicies);
                        if (versionMap.containsKey(name)) {
                            ((List)versionMap.get(name)).add(temp);
                            continue;
                        }
                        LinkedList<LinkedHashMap<String, Object>> value = new LinkedList<LinkedHashMap<String, Object>>();
                        value.add(temp);
                        versionMap.put(name, value);
                    }
                    projectMap.put("services", Collections.singletonMap("service", serviceList));
                    for (Map.Entry entry : versionMap.entrySet()) {
                        HashMap<String, Object> temp = new HashMap<String, Object>();
                        temp.put("name", entry.getKey());
                        temp.put("version", entry.getValue());
                        serviceList.add(temp);
                    }
                }
                if ((products = project.getAttributes("products_entry")) != null) {
                    LinkedList<String> applications = new LinkedList<String>();
                    LinkedList<String> processes = new LinkedList<String>();
                    for (String string : products) {
                        String[] temp = string.split(":");
                        if (temp.length != 2) continue;
                        if (temp[0].equals("Application")) {
                            applications.add(RegistryUtils.getResourceName((String)RegistryUtils.getParentPath((String)temp[1])));
                            continue;
                        }
                        if (!temp[0].equals("Process")) continue;
                        processes.add(RegistryUtils.getResourceName((String)RegistryUtils.getParentPath((String)temp[1])));
                    }
                    HashMap productMap = new HashMap();
                    projectMap.put("production", productMap);
                    LinkedList applicationList = new LinkedList();
                    productMap.put("applications", Collections.singletonMap("application", applicationList));
                    for (String string : applications) {
                        LinkedHashMap<String, String> applicationMap = new LinkedHashMap<String, String>();
                        applicationMap.put("name", string);
                        applicationList.add(applicationMap);
                    }
                    LinkedList processList = new LinkedList();
                    productMap.put("processes", Collections.singletonMap("process", processList));
                    for (String process : processes) {
                        LinkedHashMap<String, String> processMap = new LinkedHashMap<String, String>();
                        processMap.put("name", process);
                        processList.add(processMap);
                    }
                }
                projectList.add(projectMap);
            }
        }
        JSONObject object = new JSONObject(projectsMap);
        return object.toString();
    }
}

