/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.gadgets.ui;

import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.wso2.carbon.governance.gadgets.stub.GovernanceException;
import org.wso2.carbon.governance.gadgets.stub.governance.gadgets.impactanalysis.beans.xsd.ImpactBean;
import org.wso2.carbon.governance.gadgets.stub.governance.gadgets.impactanalysis.beans.xsd.PolicyBean;
import org.wso2.carbon.governance.gadgets.stub.governance.gadgets.impactanalysis.beans.xsd.SchemaBean;
import org.wso2.carbon.governance.gadgets.stub.governance.gadgets.impactanalysis.beans.xsd.ServiceBean;
import org.wso2.carbon.governance.gadgets.stub.governance.gadgets.impactanalysis.beans.xsd.WSDLBean;
import org.wso2.carbon.governance.gadgets.ui.GovImpactAdminServiceClient;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.ui.CarbonUIUtil;

public class GovImpactAnalysisDataProcessor {
    private GovImpactAdminServiceClient client;
    private String serverURL;

    public GovImpactAnalysisDataProcessor(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault {
        this.client = new GovImpactAdminServiceClient(config, session, request);
        this.serverURL = CarbonUIUtil.getAdminConsoleURL((String)CarbonUIUtil.getServerConfigurationProperty((String)"WebContextRoot"));
    }

    public String getImpactAnalysisinJSON() throws RemoteException, GovernanceException {
        ImpactBean bean = this.client.getImpactAnalysis();
        return this.buildImpactJSONTree(bean.getServiceBean());
    }

    private String getResourceURL(String path) {
        return this.serverURL + "resources/resource.jsp?region=region3&item=resource_browser_menu&path=" + "/_system/governance" + path;
    }

    private Map<String, Map<String, ServiceBean>> buildServiceVersionHierarchy(ServiceBean[] serviceBeans) {
        LinkedHashMap<String, Map<String, ServiceBean>> hierarchy = new LinkedHashMap<String, Map<String, ServiceBean>>();
        if (serviceBeans == null) {
            return hierarchy;
        }
        for (ServiceBean serviceBean : serviceBeans) {
            Map<String, ServiceBean> versionMap;
            if (serviceBean == null) continue;
            String path = RegistryUtils.getParentPath((String)serviceBean.getPath());
            String version = RegistryUtils.getResourceName((String)path);
            if (!version.replace("-SNAPSHOT", "").matches("^\\d+[.]\\d+[.]\\d+$")) {
                version = "SNAPSHOT";
                serviceBean.setPath(serviceBean.getPath());
            } else {
                serviceBean.setPath(RegistryUtils.getParentPath((String)path));
            }
            if (hierarchy.containsKey(serviceBean.getQName())) {
                versionMap = (Map)hierarchy.get(serviceBean.getQName());
            } else {
                versionMap = new LinkedHashMap();
                hierarchy.put(serviceBean.getQName(), versionMap);
            }
            versionMap.put(version, serviceBean);
        }
        return hierarchy;
    }

    private String buildImpactJSONTree(ServiceBean[] serviceBeans) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ " + this.buildJSONforNoEdgeAttributes(UUID.randomUUID().toString(), "Services", null) + this.appendChildrenJSON());
        int count = 0;
        Map<String, Map<String, ServiceBean>> serviceVersionHierarchy = this.buildServiceVersionHierarchy(serviceBeans);
        for (Map.Entry<String, Map<String, ServiceBean>> e : serviceVersionHierarchy.entrySet()) {
            Map<String, ServiceBean> versionMap = e.getValue();
            ++count;
            int countInner = 0;
            for (Map.Entry<String, ServiceBean> versionEntry : versionMap.entrySet()) {
                int j;
                String servicePath;
                String key = versionEntry.getKey();
                ServiceBean serviceBean = versionEntry.getValue();
                if (++countInner == 1) {
                    builder.append("{" + this.buildJSONforNoEdgeAttributes(serviceBean.getId(), serviceBean.getQName(), this.getResourceURL(serviceBean.getPath())) + this.appendChildrenJSON() + "\n");
                }
                String uuid = UUIDGenerator.generateUUID();
                if (key.equals("SNAPSHOT")) {
                    servicePath = serviceBean.getPath();
                } else {
                    String name = serviceBean.getQName();
                    name = name.substring(0, name.lastIndexOf("-") - 1).trim();
                    servicePath = serviceBean.getPath() + "/" + key + "/" + name;
                }
                builder.append("{" + this.buildOpenJSONWithEdges(uuid, key, serviceBean.getId(), "", this.getResourceURL(servicePath)) + this.appendChildrenJSON() + "\n");
                PolicyBean[] policyBeans = serviceBean.getPolicyBeans();
                WSDLBean[] wsdlBeans = serviceBean.getWsdlBeans();
                SchemaBean[] schemaBeans = serviceBean.getSchemaBeans();
                if (policyBeans != null) {
                    for (j = 0; j < policyBeans.length; ++j) {
                        if (policyBeans[j] == null) continue;
                        builder.append("{" + this.buildJSONWithEdgeNoChildren(policyBeans[j].getId(), policyBeans[j].getQName(), uuid, "Policy", this.getResourceURL(policyBeans[j].getPath())) + "} \n");
                        if (j != policyBeans.length - 1) {
                            builder.append(",");
                        }
                        builder.append("\n");
                    }
                    builder.append(this.buildCloseJSONForNameandChildren());
                    if (wsdlBeans != null || schemaBeans != null) {
                        builder.append(", \n");
                    }
                }
                if (wsdlBeans != null) {
                    for (j = 0; j < wsdlBeans.length; ++j) {
                        if (wsdlBeans[j] == null) continue;
                        builder.append("{" + this.buildOpenJSONWithEdges(wsdlBeans[j].getId(), wsdlBeans[j].getQName(), uuid, "WSDL", this.getResourceURL(wsdlBeans[j].getPath())) + this.appendChildrenJSON() + " \n");
                        SchemaBean[] attachedSchemas = wsdlBeans[j].getAttachedSchemas();
                        if (attachedSchemas != null) {
                            for (int k = 0; k < attachedSchemas.length; ++k) {
                                if (attachedSchemas[k] == null) continue;
                                builder.append("{" + this.buildJSONWithEdgeNoChildren(attachedSchemas[k].getId(), attachedSchemas[k].getQName(), wsdlBeans[j].getId(), "Schema", this.getResourceURL(attachedSchemas[k].getPath())) + "} \n");
                                if (j != attachedSchemas.length - 1) {
                                    builder.append(",");
                                }
                                builder.append("\n");
                            }
                        }
                        builder.append("] \n");
                        builder.append("} \n");
                        if (j != wsdlBeans.length - 1) {
                            builder.append(",");
                        }
                        builder.append("\n");
                    }
                    if (schemaBeans != null) {
                        builder.append(", \n");
                    }
                }
                if (schemaBeans != null) {
                    for (j = 0; j < schemaBeans.length; ++j) {
                        if (schemaBeans[j] == null) continue;
                        builder.append("{" + this.buildJSONWithEdgeNoChildren(schemaBeans[j].getId(), schemaBeans[j].getQName(), uuid, "Schema", this.getResourceURL(schemaBeans[j].getPath())) + "} \n");
                        if (j != schemaBeans.length - 1) {
                            builder.append(",");
                        }
                        builder.append("\n");
                    }
                }
                builder.append("] \n");
                builder.append("} \n");
                if (countInner != versionMap.size()) {
                    builder.append(", ");
                }
                builder.append("\n");
            }
            builder.append("] \n");
            builder.append("} \n");
            if (count != serviceVersionHierarchy.size()) {
                builder.append(", ");
            }
            builder.append("\n");
        }
        builder.append("] \n");
        builder.append("} \n");
        return builder.toString();
    }

    private String buildJSONTree(ServiceBean[] serviceBeans) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildOpenJSONForNameandChildren("Services"));
        if (serviceBeans != null) {
            for (int i = 0; i < serviceBeans.length; ++i) {
                int j;
                if (serviceBeans[i] == null) continue;
                builder.append("{" + this.buildJSONforNoEdgeAttributes(serviceBeans[i].getId(), serviceBeans[i].getQName(), serviceBeans[i].getPath()) + this.appendChildrenJSON() + "\n");
                PolicyBean[] policyBeans = serviceBeans[i].getPolicyBeans();
                WSDLBean[] wsdlBeans = serviceBeans[i].getWsdlBeans();
                SchemaBean[] schemaBeans = serviceBeans[i].getSchemaBeans();
                if (policyBeans != null) {
                    builder.append(this.buildOpenJSONForNameandChildren("Policies"));
                    for (j = 0; j < policyBeans.length; ++j) {
                        if (policyBeans[j] == null) continue;
                        builder.append("{" + this.buildJSONwithNoChildren(policyBeans[j].getId(), policyBeans[j].getQName(), policyBeans[j].getPath()) + "} ");
                        if (j != policyBeans.length - 1) {
                            builder.append(",");
                        }
                        builder.append("\n");
                    }
                    builder.append(this.buildCloseJSONForNameandChildren());
                    if (wsdlBeans != null || schemaBeans != null) {
                        builder.append(", \n");
                    }
                }
                if (wsdlBeans != null) {
                    builder.append(this.buildOpenJSONForNameandChildren("WSDLs"));
                    for (j = 0; j < wsdlBeans.length; ++j) {
                        if (wsdlBeans[j] == null) continue;
                        builder.append("{" + this.buildJSONforNoEdgeAttributes(wsdlBeans[j].getId(), wsdlBeans[j].getQName(), wsdlBeans[j].getPath()) + this.appendChildrenJSON() + "\n");
                        SchemaBean[] attachedSchemas = wsdlBeans[j].getAttachedSchemas();
                        if (attachedSchemas != null) {
                            builder.append(this.buildOpenJSONForNameandChildren("Schemas"));
                            for (int k = 0; k < attachedSchemas.length; ++k) {
                                if (attachedSchemas[k] == null) continue;
                                builder.append("{" + this.buildJSONwithNoChildren(attachedSchemas[k].getId(), attachedSchemas[k].getQName(), attachedSchemas[k].getPath()) + "} ");
                                if (k != attachedSchemas.length - 1) {
                                    builder.append(",");
                                }
                                builder.append("\n");
                            }
                            builder.append(this.buildCloseJSONForNameandChildren());
                        }
                        builder.append("] \n");
                        builder.append("} \n");
                        if (j != wsdlBeans.length - 1) {
                            builder.append(",");
                        }
                        builder.append("\n");
                    }
                    builder.append(this.buildCloseJSONForNameandChildren());
                    if (schemaBeans != null) {
                        builder.append(", \n");
                    }
                }
                if (schemaBeans != null) {
                    builder.append(this.buildOpenJSONForNameandChildren("Schemas"));
                    for (j = 0; j < schemaBeans.length; ++j) {
                        if (schemaBeans[j] == null) continue;
                        builder.append("{" + this.buildJSONwithNoChildren(schemaBeans[j].getId(), schemaBeans[j].getQName(), schemaBeans[j].getPath()) + "} ");
                        if (j != schemaBeans.length - 1) {
                            builder.append(",");
                        }
                        builder.append("\n");
                    }
                    builder.append(this.buildCloseJSONForNameandChildren());
                }
                builder.append("] \n");
                builder.append("} \n");
                if (i != serviceBeans.length - 1) {
                    builder.append(", ");
                }
                builder.append("\n");
            }
        }
        builder.append(this.buildCloseJSONForNameandChildren());
        return builder.toString();
    }

    private String buildOpenJSONWithEdges(String id, String name, String parentId, String edgeName, String url) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildJSONNameValuePair("id", id) + "," + this.buildJSONNameValuePair("name", name) + "," + "\"data\" : { " + this.buildJSONEdge(parentId, id, edgeName) + "," + this.buildJSONNameValuePair("url", url) + "} ");
        return builder.toString();
    }

    private String buildJSONEdge(String parentId, String id, String edgeName) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"edges\" : [ { " + this.buildJSONNameValuePair("id", parentId + "---" + id) + "," + this.buildJSONNameValuePair("name", edgeName) + "} ] ");
        return builder.toString();
    }

    private String buildJSONWithEdgeNoChildren(String id, String name, String parentId, String edgeName, String url) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildOpenJSONWithEdges(id, name, parentId, edgeName, url));
        builder.append(", " + this.buildJSONNameValuePair("children", "[]"));
        return builder.toString();
    }

    @Deprecated
    private String buildCloseJSONForNameandChildren() {
        StringBuilder builder = new StringBuilder();
        builder.append("] } \n");
        return builder.toString();
    }

    @Deprecated
    private String buildOpenJSONForNameandChildren(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        builder.append(this.buildJSONforNoEdgeAttributes(UUID.randomUUID().toString(), name, "") + this.appendChildrenJSON());
        return builder.toString();
    }

    private String appendChildrenJSON() {
        return ", \"children\" : [";
    }

    @Deprecated
    private String buildJSONobject(ServiceBean[] serviceBeans) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ \n");
        for (int i = 0; i < serviceBeans.length; ++i) {
            int j;
            if (serviceBeans[i] == null) continue;
            builder.append("\"service\" : \n");
            builder.append("{" + this.buildJSONforNoEdgeAttributes(serviceBeans[i].getId(), serviceBeans[i].getQName(), serviceBeans[i].getPath()) + "\n");
            PolicyBean[] policyBeans = serviceBeans[i].getPolicyBeans();
            WSDLBean[] wsdlBeans = serviceBeans[i].getWsdlBeans();
            SchemaBean[] schemaBeans = serviceBeans[i].getSchemaBeans();
            if (wsdlBeans != null || schemaBeans != null || policyBeans != null) {
                builder.append(", \n");
            }
            if (policyBeans != null) {
                builder.append("\"policies\" : [\n");
                for (j = 0; j < policyBeans.length; ++j) {
                    if (policyBeans[j] == null) continue;
                    builder.append("{" + this.buildJSONforNoEdgeAttributes(policyBeans[j].getId(), policyBeans[j].getQName(), policyBeans[j].getPath()) + "} ");
                    if (j != policyBeans.length - 1) {
                        builder.append(",");
                    }
                    builder.append("\n");
                }
                builder.append("] \n");
                if (wsdlBeans != null || schemaBeans != null) {
                    builder.append(", \n");
                }
            }
            if (wsdlBeans != null) {
                builder.append("\"wsdls\" : [\n");
                for (j = 0; j < wsdlBeans.length; ++j) {
                    if (wsdlBeans[j] == null) continue;
                    builder.append("{" + this.buildJSONforNoEdgeAttributes(wsdlBeans[j].getId(), wsdlBeans[j].getQName(), wsdlBeans[j].getPath()) + "} ");
                    if (j != wsdlBeans.length - 1) {
                        builder.append(",");
                    }
                    builder.append("\n");
                }
                builder.append("] \n");
                if (schemaBeans != null) {
                    builder.append(", \n");
                }
            }
            if (schemaBeans != null) {
                builder.append("\"schemas\" : [\n");
                for (j = 0; j < schemaBeans.length; ++j) {
                    if (schemaBeans[j] == null) continue;
                    builder.append("{" + this.buildJSONforNoEdgeAttributes(schemaBeans[j].getId(), schemaBeans[j].getQName(), schemaBeans[j].getPath()) + "} ");
                    if (j != schemaBeans.length - 1) {
                        builder.append(",");
                    }
                    builder.append("\n");
                }
                builder.append("] \n");
            }
            builder.append("} \n");
            if (i != serviceBeans.length - 1) {
                builder.append(", ");
            }
            builder.append("\n");
        }
        builder.append("}");
        return builder.toString();
    }

    @Deprecated
    private String buildJSONforBeanAttributes(String id, String name, String path, String dataType, String parentId) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildJSONNameValuePair("id", id) + "," + this.buildJSONNameValuePair("name", name) + ",");
        builder.append(this.buildJSONNameValuePair("data", "{}"));
        return builder.toString();
    }

    private String buildJSONforNoEdgeAttributes(String id, String name, String url) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildJSONNameValuePair("id", id) + "," + this.buildJSONNameValuePair("name", name) + ",");
        if (url == null || url.equals("")) {
            builder.append(this.buildJSONNameValuePair("data", "{}"));
        } else {
            builder.append("\"data\" : { " + this.buildJSONNameValuePair("url", url) + " }");
        }
        return builder.toString();
    }

    @Deprecated
    private String buildJSONwithNoChildren(String id, String name, String path) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildJSONforNoEdgeAttributes(id, name, path));
        builder.append(", ").append(this.buildJSONNameValuePair("children", "[]"));
        return builder.toString();
    }

    private String buildJSONNameValuePair(String name, String value) {
        if (value.contentEquals("[]") || value.contentEquals("{}")) {
            return "\"" + name + "\" : " + value + " ";
        }
        return "\"" + name + "\" : \"" + value + "\" ";
    }
}

