/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.gadgetsource.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.carbon.governance.api.services.ServiceManager;
import org.wso2.carbon.governance.gadgetsource.beans.LifecycleInfoBean;
import org.wso2.carbon.governance.gadgetsource.beans.LifecycleStageInfoBean;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class Populator {
    public static LifecycleInfoBean[] populateLifecycle(Registry registry) throws RegistryException {
        ServiceManager serviceManager = new ServiceManager(registry);
        String[] servicePaths = serviceManager.getAllServicePaths();
        HashMap<String, LifecycleInfoBean> lifecycleInfoBeanMap = new HashMap<String, LifecycleInfoBean>();
        HashMap lifecycleStagesMap = new HashMap();
        for (String servicePath : servicePaths) {
            Resource serviceResource = registry.get(servicePath);
            String lifecycleName = serviceResource.getProperty("registry.Aspects");
            if (lifecycleName == null) continue;
            lifecycleName = lifecycleName.replaceAll("\\s", "");
            LifecycleInfoBean lifecycleInfoBean = (LifecycleInfoBean)lifecycleInfoBeanMap.get(lifecycleName);
            ArrayList<LifecycleStageInfoBean> lifecycleStages = (ArrayList<LifecycleStageInfoBean>)lifecycleStagesMap.get(lifecycleName);
            if (lifecycleInfoBean == null) {
                lifecycleInfoBean = new LifecycleInfoBean();
                lifecycleInfoBean.setName(lifecycleName);
                lifecycleInfoBeanMap.put(lifecycleName, lifecycleInfoBean);
                lifecycleStages = new ArrayList<LifecycleStageInfoBean>();
                lifecycleStagesMap.put(lifecycleName, lifecycleStages);
            }
            String lifecycleStageKey = "registry.lifecycle." + lifecycleName + ".state";
            String lifecycleStageValue = serviceResource.getProperty(lifecycleStageKey);
            LifecycleStageInfoBean lifecycleStageInfoBean = null;
            for (int i = 0; i < lifecycleStages.size(); ++i) {
                LifecycleStageInfoBean stageInfoBeanIt = (LifecycleStageInfoBean)lifecycleStages.get(i);
                if (!stageInfoBeanIt.getName().equals(lifecycleStageValue)) continue;
                lifecycleStageInfoBean = stageInfoBeanIt;
            }
            if (lifecycleStageInfoBean == null) {
                lifecycleStageInfoBean = new LifecycleStageInfoBean();
                lifecycleStageInfoBean.setName(lifecycleStageValue);
                lifecycleStageInfoBean.setServiceCount(1);
                lifecycleStages.add(lifecycleStageInfoBean);
            } else {
                lifecycleStageInfoBean.setServiceCount(lifecycleStageInfoBean.getServiceCount() + 1);
            }
            LifecycleStageInfoBean[] lifecycleStageInfoBeans = lifecycleStages.toArray(new LifecycleStageInfoBean[lifecycleStages.size()]);
            lifecycleInfoBean.setStages(lifecycleStageInfoBeans);
        }
        LifecycleInfoBean[] lifecycleInfoBeans = lifecycleInfoBeanMap.values().toArray(new LifecycleInfoBean[lifecycleInfoBeanMap.size()]);
        return lifecycleInfoBeans;
    }

    public static LifecycleInfoBean[] populateLifecycleDummyData() throws RegistryException {
        LifecycleInfoBean[] lifecycles = new LifecycleInfoBean[]{new LifecycleInfoBean()};
        lifecycles[0].setName("No Data Available");
        LifecycleStageInfoBean[] stages = new LifecycleStageInfoBean[]{new LifecycleStageInfoBean()};
        stages[0].setName("Life Cycle Data Not Available.");
        stages[0].setServiceCount(0);
        lifecycles[0].setStages(stages);
        return lifecycles;
    }
}

