<!--
~ Copyright (c) 2005-2010, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
~
~ WSO2 Inc. licenses this file to you under the Apache License,
~ Version 2.0 (the "License"); you may not use this file except
~ in compliance with the License.
~ You may obtain a copy of the License at
~
~ http://www.apache.org/licenses/LICENSE-2.0
~
~ Unless required by applicable law or agreed to in writing,
~ software distributed under the License is distributed on an
~ "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
~ KIND, either express or implied. See the License for the
~ specific language governing permissions and limitations
~ under the License.
-->
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib uri="http://wso2.org/projects/carbon/taglibs/carbontags.jar"
           prefix="carbon" %>

<%@ page import="org.wso2.carbon.governance.custom.lifecycles.checklist.stub.beans.xsd.LifecycleBean" %>
<%@ page
        import="org.wso2.carbon.governance.custom.lifecycles.checklist.stub.util.xsd.LifecycleActions" %>
<%@ page
        import="org.wso2.carbon.governance.custom.lifecycles.checklist.stub.util.xsd.Property" %>
<%@ page
        import="org.wso2.carbon.governance.custom.lifecycles.checklist.ui.clients.LifecycleServiceClient" %>
<%@ page import="org.wso2.carbon.registry.common.utils.RegistryUtil" %>
<%@ page import="org.wso2.carbon.registry.core.RegistryConstants" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="java.util.Collections" %>
<%@ page import="java.util.List" %>


<%
    class CheckListItem implements Comparable {
        String lifeCycleStatus;
        String name;
        String value;
        String order;
        String propertyName;
        String visible;

        public String getVisible() {
            return visible;
        }

        public void setVisible(String visible) {
            this.visible = visible;
        }

        public String getPropertyName() {
            return propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getLifeCycleStatus() {
            return lifeCycleStatus;
        }

        public void setLifeCycleStatus(String lifeCycleStatus) {
            this.lifeCycleStatus = lifeCycleStatus.replace("."," ");
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getOrder() {
            return order;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public CheckListItem(String lifeCycleStatus, String name, String value, String order) {
            this.lifeCycleStatus = lifeCycleStatus;
            this.name = name;
            this.value = value;
            this.order = order;
        }

        public CheckListItem() {

        }

        public boolean matchLifeCycleStatus(String status, boolean ignoreCase) {
            if ((lifeCycleStatus == null) || (status == null)) {
                return false;
            }

            if (ignoreCase)
                return lifeCycleStatus.equalsIgnoreCase(status);
            else
                return lifeCycleStatus.equals(status);
        }

        public boolean matchLifeCycleStatus(String status) {
            return matchLifeCycleStatus(status, true);
        }

        public int compareTo(Object anotherItem) {
            if (!(anotherItem instanceof CheckListItem))
                return 0;

            try {
                CheckListItem item = (CheckListItem) anotherItem;
                int otherItemOrder = Integer.parseInt(item.getOrder());
                int itemOrder = Integer.parseInt(order);

                return itemOrder - otherItemOrder;
            } catch (Exception e) {
                /* suppressing any parsing errors, since order is not "that" important to consider. */
            }
            return 0;
        }
    }
    String path = RegistryUtil.getPath(request);

    // lifecycle portlet is not displayed for root or items under system. 
    if (path.equals(RegistryConstants.ROOT_PATH) || path.startsWith("/system"))
        return;

    LifecycleBean bean;
    String[] roleNames;
    try {
        LifecycleServiceClient lifecycleServiceClient = new LifecycleServiceClient(config, session);

        bean = lifecycleServiceClient.getLifecycleBean(path);
    } catch (Exception e) {
        bean = null;
    }

    if (bean != null) {
        if (bean.getLink()) {
            return;
        }
        Property[] lifecycleProps = bean.getLifecycleProperties();
        roleNames =  bean.getRolesOfUser();
        if (lifecycleProps == null) {
            lifecycleProps = new Property[0];
        }

//    List<String> lifecycleProps = propertiesBean.getLifecycleProperties();
//    Properties props = propertiesBean.getProperties();
%>
<carbon:jsi18n
        resourceBundle="org.wso2.carbon.governance.custom.lifecycles.checklist.ui.i18n.JSResources"
        request="<%=request%>" namespace="org.wso2.carbon.governance.custom.lifecycles.checklist.ui"/>
<script type="text/javascript" src="../lifecycles/js/lifecycles.js"></script>
<script type="text/javascript" src="../ajax/js/prototype.js"></script>

<fmt:bundle
        basename="org.wso2.carbon.governance.custom.lifecycles.checklist.ui.i18n.Resources">

<div class="box1-head" style="height:auto;">
    <table cellspacing="0" cellpadding="0" border="0" style="width: 100%">
        <tr>

            <td valign="top">
                <h2 class="sub-headding-lifecycle"><fmt:message key="lifecycle"/></h2>
            </td>
            <td align="right" valign="top" class="expanIconCell"><a
                    onclick="showHideCommon('lifecycleIconExpanded');showHideCommon('lifecycleIconMinimized');showHideCommon('lifecycleExpanded');showHideCommon('lifecycleMinimized');">
                <% if (lifecycleProps.length == 0) { %> <img
                    src="images/icon-expanded.gif" border="0" align="top"
                    id="lifecycleIconExpanded" style="display: none;"/> <img
                    src="images/icon-minimized.gif" border="0" align="top"
                    id="lifecycleIconMinimized"/> <% } else { %> <img
                    src="images/icon-expanded.gif" border="0" align="top"
                    id="lifecycleIconExpanded"/> <img src="images/icon-minimized.gif"
                                                      border="0" align="top" id="lifecycleIconMinimized"
                                                      style="display: none;"/> <% } %></a></td>

        </tr>
    </table>
</div>

<% if (lifecycleProps.length == 0) { %>
<div class="box1-mid-fill" id="lifecycleMinimized"></div>
<div class="box1-mid" id="lifecycleExpanded" style="display: none;" >
<% } else { %>
<div class="box1-mid-fill" id="lifecycleMinimized" style="display: none;"></div>
<div class="box1-mid" id="lifecycleExpanded">
<% } %>
<div id="lifecycleSum"></div>
<!-- Life cycle add box --> <% if (bean.getLoggedIn() && !bean.getVersionView() && bean.getPutAllowed() && bean.getShowAddDelete() &&
        lifecycleProps.length == 0 && bean.getAspectsToAdd() != null && bean.getAspectsToAdd().length != 0) { %>
<div class="icon-link-ouside registryWriteOperation"><a class="icon-link registryWriteOperation"
                                                        style="background-image: url(../admin/images/add.gif);"
                                                        href="javascript:void(0)"
                                                        onclick="javascript:showHideCommon('add-lifecycle-div');if($('add-lifecycle-div').style.display!='none')$('aspect').focus();">
    <fmt:message key="add.lifecycle"/></a></div>
<div class="registryWriteOperation" id="add-lifecycle-div"
     style="display: none; padding-bottom: 10px;">
    <form>
        <table class="styledLeft">
            <thead>
            <tr>
                <th><fmt:message key="enable.lifecycle"/></th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td><input type="hidden" id="aspectResourcePath"
                           name="resourcePath" value="<%=bean.getPathWithVersion()%>"/> <select
                        id="aspect" name="aspect" style="width: 130px">
                    <%
                        String[] aspectsToAdd = bean.getAspectsToAdd();
                        if (aspectsToAdd == null) aspectsToAdd = new String[0];
                        for (int aspIndex = 0; aspIndex < aspectsToAdd.length; aspIndex++) {
                    %>
                    <option value="<%=aspectsToAdd[aspIndex]%>"><%=aspectsToAdd[aspIndex]%>
                    </option>
                    <%
                        }

                    %>
                </select></td>
            </tr>
            <tr>
                <td class="buttonRow"><input type="button" class="button"
                                             value="<fmt:message key="add"/>" onclick="addAspect();"/> <input
                        type="button" class="button" value="<fmt:message key="cancel"/>"
                        onclick="showHideCommon('add-lifecycle-div');"/></td>
            </tr>
            </tbody>
        </table>
    </form>

    <!-- Life cycle add box ends --></div>
<div id="lifecyclesSummary" class="summeryStyle"><fmt:message
        key="no.lifecycles"/></div>

<%
} else if (lifecycleProps.length == 0) {
%>
<div id="lifecyclesSummary" class="summeryStyle"><fmt:message
        key="no.lifecycles"/></div>
<%
    }
    if (lifecycleProps.length > 0) {
%> <!-- START life cycle listing box -->
<div id="aspectList">
<table class="styledLeft">
<tbody>
<tr>
    <td>
        <%

            String lifeCycleLongName = "";
            String lifeCycleState = "";
            for (Property property : lifecycleProps) {
                String propName = property.getKey();
                String[] propValues = property.getValues();
                if (propValues != null && propValues.length != 0) {
                    String value = propValues[0];
                    if (propName.equals("registry.LC.name")) {
                        lifeCycleLongName = value;
                    }
                }
            }


            for (Property property : lifecycleProps) {
                String propName = property.getKey();
                String[] propValues = property.getValues();
                if (propValues != null && propValues.length != 0) {
                    String value = propValues[0];
                    String prefix = "registry.lifecycle.";
                    String suffix = ".state";
                    if (propName.startsWith(prefix) && propName.endsWith(suffix)) {
                        lifeCycleState = value;
                        // Grab the text in between...
                        String lifecycleName = propName.substring(prefix.length(),
                                propName.length() - suffix.length());

                        if (lifeCycleLongName.equals(""))
                            lifeCycleLongName = lifecycleName;
                    }
                }
            }

            String lifecycleName = "";
            LifecycleActions[] availableActions = bean.getAvailableActions();
            if (availableActions != null && availableActions.length > 0) {
                LifecycleActions lifecycleActions = availableActions[0];
                if (lifecycleActions != null) {
                    lifecycleName = lifecycleActions.getLifecycle();
                }
            }

            ArrayList<CheckListItem> checkListItems = new ArrayList<CheckListItem>();


            List<String> permissionList = new ArrayList();

            for (Property property : lifecycleProps) {
                String prefix = "registry.custom_lifecycle.checklist.";
                String permissionSuffix = ".item.permission";
                String propName = property.getKey();
                String[] propValues = property.getValues();

                if(propName.startsWith(prefix) && propName.endsWith(permissionSuffix)){
                    for (String role : roleNames) {
                        for (String propValue : propValues) {
                            String key = propName.replace(prefix,"").replace(permissionSuffix,"");
                            if(propValue.equals(role)){
                                permissionList.add(key);
                            }else if(propValue.startsWith(prefix) && propValue.endsWith(permissionSuffix)){
                                permissionList.add(key);
                            }
                        }
                    }
                }
            }

            for (Property property : lifecycleProps) {
                String prefix = "registry.custom_lifecycle.checklist.";
                String suffix = ".item";
                CheckListItem checkListItem = new CheckListItem();

                String propName = property.getKey();
                String[] propValues = property.getValues();

                checkListItem.setVisible("false");

                if ((propName.startsWith(prefix) && propName.endsWith(suffix))) {
                    if (propValues != null && propValues.length > 2) {
                        for (String param : propValues) {
                            if ((param.startsWith("status:"))) {
                                checkListItem.setLifeCycleStatus(param.substring(7));
                            }
                            if ((param.startsWith("name:"))) {
                                checkListItem.setName(param.substring(5));
                            }
                            if ((param.startsWith("value:"))) {
                                checkListItem.setValue(param.substring(6));
                            }
                            if ((param.startsWith("order:"))) {
                                checkListItem.setOrder(param.substring(6));
                            }
                        }
                    }
                    String key = propName.replace(prefix,"").replace(suffix,"");
                    if(permissionList.contains(key)){
                        checkListItem.setVisible("true");
                    }
                }
                if (checkListItem.matchLifeCycleStatus(lifeCycleState)) {
                    checkListItems.add(checkListItem);
                }
            }
            Collections.sort(checkListItems);
            if (!bean.getVersionView()) {
        %>

        <div style="height:0px;">
            <input type="hidden" id="resPath" name="resPath" value="<%=bean.getPathWithVersion()%>"/>
            <input type="hidden" id="aspectName" name="aspectName" value="<%=lifecycleName%>"/>
            <% if (bean.getPutAllowed() && bean.getShowAddDelete()) { %>
            <a class="icon-link registryWriteOperation"
               style="float:right;background-image:url(../admin/images/delete.gif);"
               onclick="removeAspect();" title="<fmt:message key="delete"/>">
                <% } %>
            </a>
        </div>
        <% } %>
        <div>
            <table cellpadding="0" cellspacing="5" border="0">
                <tbody>
                <tr>
                    <th><fmt:message key="lifecycle.name"/>:</th>
                    <td style="border:0;padding-right:20px;"><%=lifeCycleLongName%>
                    </td>
                </tr>
                <tr>
                    <th><fmt:message key="lifecycle.state"/>:</th>
                    <td style="border:0"><%=lifeCycleState%>
                    </td>
                </tr>
                <%
                    if (checkListItems.size() > 0) {
                %>
                <tr>
                    <th><fmt:message key="checklist.header"/>:</th>
                    <td style="border:0"></td>
                </tr>
                <% } %>
                </tbody>
            </table>
        </div>

        <div>
            <table style="margin-bottom: 15px;" class="styledLeft" id="myTable">
                <tbody>

                <%

                    int index = 0;
                    for (CheckListItem item : checkListItems) {
                        if ((index % 2) == 0) { %>
                <tr class="tableEvenRow">
                            <%      } else { %>

                <tr class="tableOddRow">
                    <% } %>
                    <td>
                        <%
                            if (item.getValue().equalsIgnoreCase("true")) {
                        %> <input type="checkbox" class="registryWriteOperation" id="option<%=index%>"
                                  value="true" checked
                            <% if (!bean.getPutAllowed() || !bean.getLoggedIn() || bean.getVersionView() || "false".equals(item.getVisible())) {%>
                                  disabled="disabled" <%}%>
                                  onclick="loadCustomUI('<%=bean.getPathWithVersion()%>', '<%=lifecycleName%>', 'itemClick','<%=bean.getMediaType()%>','','')">
                        <input type="checkbox" class="registryNonWriteOperation" id="optionX<%=index%>"
                               value="true" checked disabled="disabled">
                        <b><%=item.getName()%>
                        </b><br>
                        <% } else {
                        %> <input type="checkbox" class="registryWriteOperation" id="option<%=index%>"
                                  value="true"
                            <% if (!bean.getPutAllowed() || !bean.getLoggedIn() || bean.getVersionView()|| "false".equals(item.getVisible())) {%>
                                  disabled="disabled" <%}%>
                                  onclick="loadCustomUI('<%=bean.getPathWithVersion()%>', '<%=lifecycleName%>', 'itemClick','<%=bean.getMediaType()%>','','')">
                        <input type="checkbox" class="registryNonWriteOperation" id="optionX<%=index%>"
                               value="true" disabled="disabled">
                        <b><%=item.getName()%>
                        </b><br>
                        <% } %>
                    </td>
                </tr>
                <%
                        index++;
                    }
                %>
                <input type="hidden" id="itemcount" value="<%=index%>">
                </tbody>
            </table>
        </div>
    </td>
</tr>
<%
    if (availableActions != null && availableActions.length > 0) { %>

<tr>
    <td class="buttonRow">
        <div id="lifeCycleButtons">
            <%
                LifecycleActions lifecycleActions = availableActions[0];
                if (lifecycleActions != null) {
                    String lifecycle = lifecycleActions.getLifecycle();
                    String[] actions = lifecycleActions.getActions();
                    if (actions == null) actions = new String[0];
                    for (String action : actions) {
                        if (bean.getLoggedIn() && !bean.getVersionView() && bean.getPutAllowed()) {
                            String lifecycleScript = "";
                            String lifecycleScriptCommand = "";
                            String customUILink = "";

                            for (Property property : lifecycleProps) {
                                String propName = property.getKey();
                                if(propName.equals("registry.custom_lifecycle.checklist.transition.ui."+action)){
                                    String[] propertyValues = property.getValues();

                                    if(propertyValues.length==1) {
                                        customUILink = propertyValues[0];
                                        break;
                                    }

                                }
                            }

                            for (Property property : lifecycleProps) {
                                String propName = property.getKey();
                                String prefix = "registry.custom_lifecycle.";
                                String suffix = "js.script.console." + lifeCycleState + "." + action;
                                if (propName.startsWith(prefix) && propName.endsWith(suffix)) {
                                    String propValues[] = property.getValues();
                                    for (String propValue : propValues) {
                                    }
                                    if (propValues != null && propValues.length == 2) {
                                        if (propValues[0].contains("function()")) {
                                            lifecycleScript = propValues[0];
                                            if (!customUILink.equals("")) {
                                                lifecycleScriptCommand = "'" + propValues[1] + "'";
                                            } else {
                                                lifecycleScriptCommand = "function() {" +
                                                        propValues[1] + "();}";
                                            }
                                        } else {
                                            lifecycleScript = propValues[1];
                                            if (!customUILink.equals("")) {
                                                lifecycleScriptCommand = "'" + propValues[0] + "'";
                                            } else {
                                                lifecycleScriptCommand = "function() {" +
                                                        propValues[0] + "();}";
                                            }
                                        }
                                        break;
                                    }
                                }
                            }


            %>
            <%=lifecycleScript%>
            <input class="button registryWriteOperation" type="button" id="<%=action%>"
                   value="<fmt:message key="action.lifecycle"><fmt:param value="<%=action%>"/></fmt:message>"
                   onclick="loadCustomUI('<%=bean.getPathWithVersion()%>', '<%=lifecycle%>', '<%=action%>','<%=bean.getMediaType()%>'
                           ,'<%=customUILink%>'<% if (!lifecycleScriptCommand.equals("")) {%>, <%=lifecycleScriptCommand%><%}%>)"/>
            <input class="button registryNonWriteOperation" type="button" disabled="disabled"
                   value="<fmt:message key="action.lifecycle"><fmt:param value="<%=action%>"/></fmt:message>"/>
            <% }
            }
            } %>
        </div>
    </td>
</tr>
<%
    } %>
</tbody>
</table>
</div>
<!-- END lifecycle listing box -->
<% } %>
<div id="customUIDiv" style="display:block">

</div>
</div>
</fmt:bundle>
<% }

%>

