/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.base.CarbonContextHolderBase;
import org.wso2.carbon.base.UnloadTenantTask;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.endpoints.dataobjects.Endpoint;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.policies.dataobjects.Policy;
import org.wso2.carbon.governance.api.schema.dataobjects.Schema;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.wsdls.dataobjects.Wsdl;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.utils.component.xml.config.ManagementPermission;

public class GovernanceUtils {
    private static final Log log = LogFactory.getLog(GovernanceUtils.class);
    private static RegistryService registryService;
    private static final Map<Integer, List<GovernanceArtifactConfiguration>> artifactConfigurations;
    private static Map<Integer, Map<String, Boolean>> lifecycleAspects;
    private static final Object ASPECT_MAP_LOCK;
    private static final ThreadLocal<Registry> tenantGovernanceSystemRegistry;

    public static void setRegistryService(RegistryService registryService) {
        GovernanceUtils.registryService = registryService;
    }

    private static void registerArtifactConfigurations(int tenantId, List<GovernanceArtifactConfiguration> configurations) {
        artifactConfigurations.put(tenantId, configurations);
        CarbonContextHolderBase.registerUnloadTenantTask((UnloadTenantTask)new UnloadTenantTask(){

            public void register(int tenantId, Object registration) {
            }

            public void cleanup(int tenantId) {
                if (artifactConfigurations.get(tenantId) != null) {
                    artifactConfigurations.remove(tenantId);
                }
                if (lifecycleAspects.get(tenantId) != null) {
                    lifecycleAspects.remove(tenantId);
                }
            }
        });
    }

    public static String[] findGovernanceArtifacts(String mediaType, Registry registry) throws RegistryException {
        String[] paths = GovernanceUtils.getResultPaths(registry, mediaType);
        if (paths == null) {
            paths = new String[]{};
        }
        Arrays.sort(paths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int result = RegistryUtils.getResourceName((String)o1).compareToIgnoreCase(RegistryUtils.getResourceName((String)o2));
                if (result == 0) {
                    return o1.compareToIgnoreCase(o2);
                }
                return result;
            }
        });
        return paths;
    }

    public static GovernanceArtifactConfiguration findGovernanceArtifactConfiguration(String key, Registry registry) throws RegistryException {
        List<GovernanceArtifactConfiguration> governanceArtifactConfigurations = GovernanceUtils.findGovernanceArtifactConfigurations(registry);
        for (GovernanceArtifactConfiguration configuration : governanceArtifactConfigurations) {
            if (!key.equals(configuration.getKey())) continue;
            return configuration;
        }
        return null;
    }

    public static String[] getResultPaths(Registry registry, String mediaType) throws GovernanceException {
        String[] result;
        String sql = "SELECT DISTINCT REG_PATH_ID, REG_NAME FROM REG_RESOURCE WHERE REG_MEDIA_TYPE=?";
        try {
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("1", mediaType);
            parameter.put("query", sql);
            result = (String[])registry.executeQuery(null, parameter).getContent();
        }
        catch (RegistryException e) {
            String msg = "Error in getting the result for media type: " + mediaType + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        return GovernanceUtils.removeMountPaths(result, registry);
    }

    private static String[] removeSymbolicLinks(String[] paths, Registry governanceRegistry) {
        if (paths == null) {
            return new String[0];
        }
        LinkedList<String> fixedPaths = new LinkedList<String>();
        for (String path : paths) {
            try {
                if (governanceRegistry.get(path).getProperty("registry.link") != null && governanceRegistry.get(path).getProperty("registry.realpath") == null || path.contains("/repository/components/org.wso2.carbon.registry/mount")) continue;
                fixedPaths.add(path);
            }
            catch (RegistryException ignored) {
                // empty catch block
            }
        }
        return fixedPaths.toArray(new String[fixedPaths.size()]);
    }

    private static String[] removeMountPaths(String[] paths, Registry governanceRegistry) {
        if (paths == null) {
            return new String[0];
        }
        LinkedList<String> fixedPaths = new LinkedList<String>();
        for (String path : paths) {
            if (path.contains("/repository/components/org.wso2.carbon.registry/mount")) continue;
            fixedPaths.add(path);
        }
        return fixedPaths.toArray(new String[fixedPaths.size()]);
    }

    public static void loadGovernanceArtifacts(UserRegistry registry) throws RegistryException {
        GovernanceUtils.registerArtifactConfigurations(registry.getTenantId(), Collections.unmodifiableList(GovernanceUtils.findGovernanceArtifactConfigurations((Registry)registry)));
    }

    public static GovernanceArtifactConfiguration getGovernanceArtifactConfiguration(String elementString) {
        GovernanceArtifactConfiguration configuration = null;
        try {
            OMElement configElement = AXIOMUtil.stringToOM((String)elementString);
            if (configElement != null) {
                OMElement uiPermissions;
                OMElement uiConfigurations;
                OMElement associationDefinitions;
                OMElement contentDefinition;
                OMElement pathExpressionElement;
                OMElement artifactElementNamespaceElement;
                OMElement artifactNamespaceAttributeElement;
                configuration = new GovernanceArtifactConfiguration();
                OMElement artifactNameAttributeElement = configElement.getFirstChildWithName(new QName("nameAttribute"));
                if (artifactNameAttributeElement != null) {
                    configuration.setArtifactNameAttribute(artifactNameAttributeElement.getText());
                }
                if ((artifactNamespaceAttributeElement = configElement.getFirstChildWithName(new QName("namespaceAttribute"))) != null) {
                    configuration.setArtifactNamespaceAttribute(artifactNamespaceAttributeElement.getText());
                } else if (Boolean.toString(false).equals(configElement.getAttributeValue(new QName("hasNamespace")))) {
                    configuration.setArtifactNamespaceAttribute(null);
                }
                OMElement artifactElementRootElement = configElement.getFirstChildWithName(new QName("elementRoot"));
                if (artifactElementRootElement != null) {
                    configuration.setArtifactElementRoot(artifactElementRootElement.getText());
                }
                if ((artifactElementNamespaceElement = configElement.getFirstChildWithName(new QName("elementNamespace"))) != null) {
                    configuration.setArtifactElementNamespace(artifactElementNamespaceElement.getText());
                }
                configuration.setKey(configElement.getAttributeValue(new QName("shortName")));
                configuration.setSingularLabel(configElement.getAttributeValue(new QName("singularLabel")));
                configuration.setPluralLabel(configElement.getAttributeValue(new QName("pluralLabel")));
                configuration.setMediaType(configElement.getAttributeValue(new QName("type")));
                String iconSetString = configElement.getAttributeValue(new QName("iconSet"));
                if (iconSetString != null) {
                    configuration.setIconSet(Integer.parseInt(iconSetString));
                }
                if ((pathExpressionElement = configElement.getFirstChildWithName(new QName("storagePath"))) != null) {
                    configuration.setPathExpression(pathExpressionElement.getText());
                }
                if ((contentDefinition = configElement.getFirstChildWithName(new QName("content"))) != null) {
                    configuration.setContentDefinition(contentDefinition);
                }
                if ((associationDefinitions = configElement.getFirstChildWithName(new QName("relationships"))) != null) {
                    OMElement associationElement;
                    LinkedList<Association> associations = new LinkedList<Association>();
                    Iterator associationElements = associationDefinitions.getChildrenWithName(new QName("association"));
                    while (associationElements.hasNext()) {
                        associationElement = (OMElement)associationElements.next();
                        String type = associationElement.getAttributeValue(new QName("type"));
                        String source = associationElement.getAttributeValue(new QName("source"));
                        String target = associationElement.getAttributeValue(new QName("target"));
                        associations.add(new Association(source, target, type));
                    }
                    associationElements = associationDefinitions.getChildrenWithName(new QName("dependency"));
                    while (associationElements.hasNext()) {
                        associationElement = (OMElement)associationElements.next();
                        String source = associationElement.getAttributeValue(new QName("source"));
                        String target = associationElement.getAttributeValue(new QName("target"));
                        associations.add(new Association(source, target, "depends"));
                    }
                    configuration.setRelationshipDefinitions(associations.toArray(new Association[associations.size()]));
                }
                if ((uiConfigurations = configElement.getFirstChildWithName(new QName("ui"))) != null) {
                    configuration.setUIConfigurations(uiConfigurations);
                    OMElement uiListConfigurations = uiConfigurations.getFirstChildWithName(new QName("list"));
                    if (uiListConfigurations != null) {
                        configuration.setUIListConfigurations(uiListConfigurations);
                    }
                }
                if ((uiPermissions = configElement.getFirstChildWithName(new QName("permissions"))) != null) {
                    Iterator permissionElements = uiPermissions.getChildrenWithName(new QName("permission"));
                    LinkedList<ManagementPermission> managementPermissions = new LinkedList<ManagementPermission>();
                    while (permissionElements.hasNext()) {
                        String id;
                        OMElement permissionElement = (OMElement)permissionElements.next();
                        OMElement nameElement = permissionElement.getFirstChildWithName(new QName("name"));
                        String name = nameElement != null ? nameElement.getText() : null;
                        OMElement idElement = permissionElement.getFirstChildWithName(new QName("id"));
                        String string = id = idElement != null ? idElement.getText() : null;
                        if (name == null || id == null) continue;
                        managementPermissions.add(new ManagementPermission(name, id));
                    }
                    configuration.setUIPermissions(managementPermissions.toArray(new ManagementPermission[managementPermissions.size()]));
                } else {
                    LinkedList<ManagementPermission> managementPermissions = new LinkedList<ManagementPermission>();
                    String idPrefix = "/permission/admin/manage/resources/govern/" + configuration.getKey();
                    managementPermissions.add(new ManagementPermission(configuration.getPluralLabel(), idPrefix));
                    managementPermissions.add(new ManagementPermission("Add", idPrefix + "/add"));
                    managementPermissions.add(new ManagementPermission("List", idPrefix + "/list"));
                    managementPermissions.add(new ManagementPermission(configuration.getPluralLabel(), "/permission/admin/configure/governance/" + configuration.getKey() + "-ui"));
                    configuration.setUIPermissions(managementPermissions.toArray(new ManagementPermission[managementPermissions.size()]));
                }
            }
        }
        catch (XMLStreamException ignored) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return configuration;
    }

    public static List<GovernanceArtifactConfiguration> findGovernanceArtifactConfigurations(Registry registry) throws RegistryException {
        String[] artifactConfigurations = GovernanceUtils.findGovernanceArtifacts("application/vnd.wso2.registry-ext-type+xml", registry);
        LinkedList<GovernanceArtifactConfiguration> configurations = new LinkedList<GovernanceArtifactConfiguration>();
        for (String artifactConfiguration : artifactConfigurations) {
            Resource resource = registry.get(artifactConfiguration);
            Object content = resource.getContent();
            String elementString = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
            configurations.add(GovernanceUtils.getGovernanceArtifactConfiguration(elementString));
        }
        return configurations;
    }

    public static void setTenantGovernanceSystemRegistry(int tenantId) throws RegistryException {
        if (registryService != null) {
            tenantGovernanceSystemRegistry.set((Registry)registryService.getGovernanceSystemRegistry(tenantId));
        }
    }

    public static void unsetTenantGovernanceSystemRegistry() throws RegistryException {
        tenantGovernanceSystemRegistry.remove();
    }

    public static Registry getGovernanceSystemRegistry(Registry registry) throws RegistryException {
        if (tenantGovernanceSystemRegistry.get() != null) {
            return tenantGovernanceSystemRegistry.get();
        }
        if (registryService == null) {
            return null;
        }
        if (!(registry instanceof UserRegistry)) {
            return null;
        }
        UserRegistry userRegistry = (UserRegistry)registry;
        return registryService.getGovernanceSystemRegistry(userRegistry.getTenantId());
    }

    public static Registry getGovernanceUserRegistry(Registry registry, String username) throws RegistryException {
        if (RegistryContext.getBaseInstance() == null) {
            RegistryContext.getBaseInstance(null, (boolean)false);
        }
        return new UserRegistry(username, -1234, registry, null, "/_system/governance");
    }

    public static void removeArtifact(Registry registry, String artifactId) throws GovernanceException {
        try {
            String path = GovernanceUtils.getArtifactPath(registry, artifactId);
            if (registry.resourceExists(path)) {
                registry.delete(path);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in deleting the the artifact id:" + artifactId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    public static String getArtifactPath(Registry registry, String artifactId) throws GovernanceException {
        try {
            String sql = "SELECT REG_PATH_ID, REG_NAME FROM REG_RESOURCE WHERE REG_UUID = ?";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("1", artifactId);
            parameter.put("query", sql);
            String[] result = (String[])registry.executeQuery(null, parameter).getContent();
            if (result != null && result.length == 1) {
                return result[0];
            }
            return null;
        }
        catch (RegistryException e) {
            String msg = "Error in getting the path from the registry. Execute query failed with message : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    public static String getAttributeValue(OMElement element, String name, String namespace) {
        String[] parts = name.split("_");
        OMElement attributeElement = element;
        for (String part : parts) {
            if ((attributeElement = attributeElement.getFirstChildWithName(new QName(namespace, part))) != null) continue;
            return "";
        }
        return attributeElement.getText();
    }

    public static String[] getAllArtifactIds(Registry registry) throws GovernanceException {
        try {
            Registry governanceSystemRegistry = GovernanceUtils.getGovernanceSystemRegistry(registry);
            if (governanceSystemRegistry == null) {
                governanceSystemRegistry = registry;
            }
            if (!governanceSystemRegistry.resourceExists("/repository/components/org.wso2.carbon.governance/artifacts")) {
                String msg = "The artifact index doesn't exist. artifact index path: /repository/components/org.wso2.carbon.governance/artifacts.";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg);
                }
                return null;
            }
            Resource resource = governanceSystemRegistry.get("/repository/components/org.wso2.carbon.governance/artifacts");
            LinkedList<String> keys = new LinkedList<String>();
            for (Object key : resource.getProperties().keySet()) {
                keys.add((String)key);
            }
            return keys.toArray(new String[keys.size()]);
        }
        catch (RegistryException e) {
            String msg = "Error in retrieving artifact ids from: /repository/components/org.wso2.carbon.governance/artifacts.";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    public static GovernanceArtifact[] getAllArtifacts(Registry registry) throws GovernanceException {
        LinkedList<GovernanceArtifact> artifacts = new LinkedList<GovernanceArtifact>();
        for (String artifactId : GovernanceUtils.getAllArtifactIds(registry)) {
            GovernanceArtifact artifact = GovernanceUtils.retrieveGovernanceArtifactById(registry, artifactId);
            if (artifact == null) continue;
            artifacts.add(artifact);
        }
        return artifacts.toArray(new GovernanceArtifact[artifacts.size()]);
    }

    public static GovernanceArtifact retrieveGovernanceArtifactById(Registry registry, String artifactId) throws GovernanceException {
        String artifactPath = GovernanceUtils.getArtifactPath(registry, artifactId);
        if (artifactPath == null) {
            String msg = "Governance artifact is not found for id: " + artifactId + ".";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            return null;
        }
        return GovernanceUtils.retrieveGovernanceArtifactByPath(registry, artifactPath);
    }

    public static GovernanceArtifact retrieveGovernanceArtifactByPath(Registry registry, String artifactPath) throws GovernanceException {
        try {
            if (!registry.resourceExists(artifactPath)) {
                if (log.isDebugEnabled()) {
                    String msg = "The artifact path doesn't exists at " + artifactPath + ".";
                    log.debug((Object)msg);
                }
                return null;
            }
            Resource artifactResource = registry.get(artifactPath);
            String artifactId = artifactResource.getUUID();
            String mediaType = artifactResource.getMediaType();
            if ("application/vnd.wso2-service+xml".equals(mediaType)) {
                byte[] contentBytes = (byte[])artifactResource.getContent();
                if (contentBytes == null) {
                    throw new GovernanceException("Unable to read payload of governance artifact at path: " + artifactPath);
                }
                OMElement contentElement = GovernanceUtils.buildOMElement(contentBytes);
                Service service = new Service(artifactId, contentElement);
                service.associateRegistry(registry);
                return service;
            }
            if ("application/wsdl+xml".equals(mediaType)) {
                return new Wsdl(artifactId, registry);
            }
            if ("application/x-xsd+xml".equals(mediaType)) {
                return new Schema(artifactId, registry);
            }
            if ("application/policy+xml".equals(mediaType)) {
                return new Policy(artifactId, registry);
            }
            if ("application/vnd.wso2.endpoint".equals(mediaType)) {
                return new Endpoint(artifactId, registry);
            }
            if (mediaType != null && mediaType.matches("application/vnd\\.[a-zA-Z0-9.-]+\\+xml")) {
                List<GovernanceArtifactConfiguration> configurations;
                if (registry instanceof UserRegistry && (configurations = artifactConfigurations.get(((UserRegistry)registry).getTenantId())) != null) {
                    for (GovernanceArtifactConfiguration configuration : configurations) {
                        if (!mediaType.equals(configuration.getMediaType())) continue;
                        byte[] contentBytes = (byte[])artifactResource.getContent();
                        if (contentBytes == null) {
                            throw new GovernanceException("Unable to read payload of governance artifact at path: " + artifactPath);
                        }
                        OMElement contentElement = GovernanceUtils.buildOMElement(contentBytes);
                        GenericArtifact artifact = new GenericArtifact(artifactId, contentElement, configuration.getArtifactNameAttribute(), configuration.getArtifactNamespaceAttribute(), configuration.getArtifactElementNamespace());
                        artifact.associateRegistry(registry);
                        return artifact;
                    }
                }
                return GovernanceArtifact.create(registry, artifactId);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in retrieving governance artifact by path. path: " + artifactPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        return null;
    }

    public static OMElement buildOMElement(byte[] content) throws RegistryException {
        XMLStreamReader parser;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(RegistryUtils.decodeBytes((byte[])content)));
        }
        catch (XMLStreamException e) {
            String msg = "Error in initializing the parser to build the OMElement.";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    public static String serializeOMElement(OMElement element) throws GovernanceException {
        try {
            return element.toStringWithConsume();
        }
        catch (XMLStreamException e) {
            String msg = "Error in serializing the OMElement.";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    public static String getPathFromPathExpression(String pathExpression, GovernanceArtifact artifact, String storagePath) throws GovernanceException {
        return GovernanceUtils.getPathFromPathExpression(pathExpression.replace("@{storagePath}", storagePath), artifact);
    }

    public static String getPathFromPathExpression(String pathExpression, GovernanceArtifact artifact) throws GovernanceException {
        String output = GovernanceUtils.replaceNameAndNamespace(pathExpression, artifact);
        String[] elements = output.split("@");
        for (int i = 1; i < elements.length; ++i) {
            String key;
            String artifactAttribute;
            if (elements[i].indexOf("}") <= 0 || elements[i].indexOf("{") != 0 || (artifactAttribute = artifact.getAttribute(key = elements[i].split("}")[0].substring(1))) == null) continue;
            output = output.replace("@{" + key + "}", artifactAttribute);
        }
        return output;
    }

    public static String[] getPathsFromPathExpression(String pathExpression, GovernanceArtifact artifact) throws GovernanceException {
        String expression = GovernanceUtils.replaceNameAndNamespace(pathExpression, artifact);
        String[] elements = expression.split("@");
        for (int i = 1; i < elements.length; ++i) {
            String key;
            String artifactAttribute;
            if (elements[i].indexOf(":") > 0 || elements[i].indexOf("}") <= 0 || elements[i].indexOf("{") != 0 || (artifactAttribute = artifact.getAttribute(key = elements[i].split("}")[0].substring(1))) == null) continue;
            expression = expression.replace("@{" + key + "}", artifactAttribute);
        }
        List<String> output = GovernanceUtils.fixExpressionForMultiplePaths(artifact, expression);
        return output.toArray(new String[output.size()]);
    }

    private static List<String> fixExpressionForMultiplePaths(GovernanceArtifact artifact, String expression) throws GovernanceException {
        if (expression.indexOf("@") < 0) {
            return Collections.singletonList(expression);
        }
        LinkedList<String> output = new LinkedList<String>();
        String[] elements = expression.split("@");
        for (int i = 1; i < elements.length; ++i) {
            if (elements[i].indexOf("}") <= 0 || elements[i].indexOf("{") != 0) continue;
            String key = elements[i].split("}")[0].substring(1).split(":")[0];
            String[] artifactAttributes = artifact.getAttributes(key);
            if (artifactAttributes == null) break;
            for (String artifactAttribute : artifactAttributes) {
                String[] parts = artifactAttribute.split(":");
                output.addAll(GovernanceUtils.fixExpressionForMultiplePaths(artifact, expression.replace("@{" + key + ":key}", parts[0]).replace("@{" + key + ":value}", parts[1])));
            }
            break;
        }
        return output;
    }

    private static String replaceNameAndNamespace(String pathExpression, GovernanceArtifact artifact) {
        String output = pathExpression;
        QName qName = artifact.getQName();
        if (qName != null) {
            output = output.replace("@{name}", qName.getLocalPart());
            String replacement = CommonUtil.derivePathFragmentFromNamespace((String)qName.getNamespaceURI());
            if (replacement.startsWith("/")) {
                replacement = replacement.substring(1);
            }
            if (replacement.endsWith("/")) {
                replacement = replacement.substring(0, replacement.length() - 1);
            }
            output = output.replace("@{namespace}", replacement);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAvailableAspects() throws RegistryException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        UserRegistry systemRegistry = registryService.getConfigSystemRegistry(tenantId);
        String[] aspectsToAdd = systemRegistry.getAvailableAspects();
        if (aspectsToAdd == null) {
            return new String[0];
        }
        LinkedList<String> lifecycleAspectsToAdd = new LinkedList<String>();
        boolean isTransactionStarted = false;
        String tempResourcePath = "/governance/lcm/" + UUIDGenerator.generateUUID();
        for (String aspectToAdd : aspectsToAdd) {
            Boolean isLifecycleAspect;
            Map<String, Boolean> aspectsMap;
            if (systemRegistry.getRegistryContext().isReadOnly()) {
                lifecycleAspectsToAdd.add(aspectToAdd);
                continue;
            }
            if (!lifecycleAspects.containsKey(tenantId)) {
                Object object = ASPECT_MAP_LOCK;
                synchronized (object) {
                    if (!lifecycleAspects.containsKey(tenantId)) {
                        aspectsMap = new HashMap<String, Boolean>();
                        lifecycleAspects.put(tenantId, aspectsMap);
                    } else {
                        aspectsMap = lifecycleAspects.get(tenantId);
                    }
                }
            } else {
                aspectsMap = lifecycleAspects.get(tenantId);
            }
            if ((isLifecycleAspect = aspectsMap.get(aspectToAdd)) == null) {
                if (!isTransactionStarted) {
                    systemRegistry.beginTransaction();
                    isTransactionStarted = true;
                }
                systemRegistry.put(tempResourcePath, systemRegistry.newResource());
                systemRegistry.associateAspect(tempResourcePath, aspectToAdd);
                Resource r = systemRegistry.get(tempResourcePath);
                Properties props = r.getProperties();
                Set<Object> keys = props.keySet();
                for (Object key : keys) {
                    String propKey = (String)key;
                    if (!propKey.startsWith("registry.lifecycle.") && !propKey.startsWith("registry.custom_lifecycle.checklist.")) continue;
                    isLifecycleAspect = Boolean.TRUE;
                    break;
                }
                if (isLifecycleAspect == null) {
                    isLifecycleAspect = Boolean.FALSE;
                }
                aspectsMap.put(aspectToAdd, isLifecycleAspect);
            }
            if (!isLifecycleAspect.booleanValue()) continue;
            lifecycleAspectsToAdd.add(aspectToAdd);
        }
        if (isTransactionStarted) {
            systemRegistry.delete(tempResourcePath);
            systemRegistry.rollbackTransaction();
        }
        return lifecycleAspectsToAdd.toArray(new String[lifecycleAspectsToAdd.size()]);
    }

    public static String derivePathFromQName(QName qName) {
        String serviceName = qName.getLocalPart();
        String serviceNamespace = qName.getNamespaceURI();
        return (serviceNamespace == null ? "" : CommonUtil.derivePathFragmentFromNamespace((String)serviceNamespace)) + serviceName;
    }

    public static String getNameFromUrl(String url) {
        int slashIndex = url.lastIndexOf(47);
        if (slashIndex == -1) {
            return url;
        }
        if (slashIndex == url.length() - 1) {
            return url.substring(0, url.length() - 1);
        }
        return url.substring(slashIndex + 1);
    }

    public static List<OMElement> evaluateXPathToElements(String expression, OMElement root) throws JaxenException {
        String[] wsdlPrefixes = new String[]{"wsdl", "http://schemas.xmlsoap.org/wsdl/", "wsdl2", "http://www.w3.org/ns/wsdl", "xsd", "http://www.w3.org/2001/XMLSchema", "soap", "http://schemas.xmlsoap.org/wsdl/soap/", "soap12", "http://schemas.xmlsoap.org/wsdl/soap12/", "http", "http://schemas.xmlsoap.org/wsdl/http/"};
        AXIOMXPath xpathExpression = new AXIOMXPath(expression);
        for (int j = 0; j < wsdlPrefixes.length; ++j) {
            xpathExpression.addNamespace(wsdlPrefixes[j++], wsdlPrefixes[j]);
        }
        return xpathExpression.selectNodes((Object)root);
    }

    public static void associateAspect(String path, String aspect, Registry registry) throws RegistryException {
        try {
            registry.associateAspect(path, aspect);
        }
        catch (RegistryException e) {
            String msg = "Failed to associate aspect with the resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public static void removeAspect(String path, String aspect, Registry registry) throws RegistryException {
        try {
            Resource resource = registry.get(path);
            Properties props = resource.getProperties();
            Iterator<Object> iKeys = props.keySet().iterator();
            ArrayList<String> propertiesToRemove = new ArrayList<String>();
            while (iKeys.hasNext()) {
                String propKey = (String)iKeys.next();
                if (!propKey.startsWith("registry.custom_lifecycle.checklist.") && !propKey.startsWith("registry.LC.name") && !propKey.startsWith("registry.lifecycle.") && !propKey.startsWith("registry.Aspects")) continue;
                propertiesToRemove.add(propKey);
            }
            for (String propertyName : propertiesToRemove) {
                resource.removeProperty(propertyName);
            }
            registry.put(path, resource);
        }
        catch (RegistryException e) {
            String msg = "Failed to remove aspect " + aspect + " on resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    static {
        artifactConfigurations = new HashMap<Integer, List<GovernanceArtifactConfiguration>>();
        lifecycleAspects = new HashMap<Integer, Map<String, Boolean>>();
        ASPECT_MAP_LOCK = new Object();
        tenantGovernanceSystemRegistry = new ThreadLocal();
    }
}

