/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.services;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.governance.api.common.GovernanceArtifactManager;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.services.ServiceFilter;
import org.wso2.carbon.governance.api.services.dataobjects.Service;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class ServiceManager {
    private GovernanceArtifactManager manager;
    private Registry registry;

    public ServiceManager(Registry registry) {
        this(registry, "application/vnd.wso2-service+xml");
    }

    protected ServiceManager(Registry registry, String mediaType) {
        this.manager = new GovernanceArtifactManager(registry, mediaType, "overview_name", "overview_namespace", "serviceMetaData", "http://www.wso2.org/governance/metadata", "/@{name}", new Association[0]);
        this.registry = registry;
    }

    public Service newService(QName qName) throws GovernanceException {
        Service service = new Service(this.manager.newGovernanceArtifact()){};
        service.setQName(qName);
        return service;
    }

    public Service newService(OMElement content) throws GovernanceException {
        Service service = new Service(this.manager.newGovernanceArtifact(content)){};
        String serviceName = CommonUtil.getServiceName((OMElement)content);
        String serviceNamespace = CommonUtil.getServiceNamespace((OMElement)content);
        if (serviceName == null || serviceName.equals("")) {
            throw new GovernanceException("Unable to compute QName from given XML payload, please ensure that the content passed in matches the configuration.");
        }
        service.setQName(new QName(serviceNamespace, serviceName));
        return service;
    }

    public void addService(Service service) throws GovernanceException {
        this.manager.addGovernanceArtifact(service);
    }

    public void updateService(Service service) throws GovernanceException {
        this.manager.updateGovernanceArtifact(service);
    }

    public Service getService(String serviceId) throws GovernanceException {
        GovernanceArtifact governanceArtifact = this.manager.getGovernanceArtifact(serviceId);
        if (governanceArtifact == null) {
            return null;
        }
        return new Service(governanceArtifact){};
    }

    public void removeService(String serviceId) throws GovernanceException {
        this.manager.removeGovernanceArtifact(serviceId);
    }

    public Service[] findServices(ServiceFilter criteria) throws GovernanceException {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Service service : this.getAllServices()) {
            if (service == null || !criteria.matches(service)) continue;
            services.add(service);
        }
        return services.toArray(new Service[services.size()]);
    }

    public String[] getAllServicePaths() throws GovernanceException {
        return GovernanceUtils.getResultPaths(this.registry, "application/vnd.wso2-service+xml");
    }

    public Service[] getAllServices() throws GovernanceException {
        return this.getServices(this.manager.getAllGovernanceArtifacts());
    }

    private Service[] getServices(GovernanceArtifact[] governanceArtifacts) {
        ArrayList<4> services = new ArrayList<4>(governanceArtifacts.length);
        for (GovernanceArtifact governanceArtifact : governanceArtifacts) {
            services.add(new Service(governanceArtifact){});
        }
        return services.toArray(new Service[services.size()]);
    }

    public String[] getAllServiceIds() throws GovernanceException {
        return this.manager.getAllGovernanceArtifactIds();
    }
}

