/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.schema.dataobjects;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class Schema
extends GovernanceArtifact {
    private static final Log log = LogFactory.getLog(Schema.class);
    private static final String SCHEMA_TARGET_NAMESPACE_ATTRIBUTE = "targetNamespace";
    private QName qname;
    private OMElement schemaElement;
    private String url;

    public Schema(String id, Registry registry) throws GovernanceException {
        super(id);
        this.associateRegistry(registry);
        this.loadSchemaDetails();
    }

    public Schema(String id, String url) {
        super(id);
        this.url = url;
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    public OMElement getSchemaElement() {
        return this.schemaElement;
    }

    public void setSchemaElement(OMElement schemaElement) {
        this.schemaElement = schemaElement;
    }

    public String getUrl() {
        return this.url;
    }

    public void loadSchemaDetails() throws GovernanceException {
        Set<Object> keySet;
        Resource resource;
        this.checkRegistryResourceAssociation();
        Registry registry = this.getAssociatedRegistry();
        String path = this.getPath();
        String id = this.getId();
        try {
            resource = registry.get(path);
            byte[] content = (byte[])resource.getContent();
            this.schemaElement = GovernanceUtils.buildOMElement(content);
        }
        catch (RegistryException e) {
            String msg = "Error in getting the content for the artifact. artifact id: " + id + ", " + "path: " + path + ".";
            log.error((Object)msg);
            throw new GovernanceException(msg, e);
        }
        String fileName = RegistryUtils.getResourceName((String)path);
        String namespaceURI = this.schemaElement.getAttributeValue(new QName(SCHEMA_TARGET_NAMESPACE_ATTRIBUTE));
        this.qname = new QName(namespaceURI, fileName);
        Properties properties = resource.getProperties();
        if (properties != null && (keySet = properties.keySet()) != null) {
            for (Object keyObj : keySet) {
                String key = (String)keyObj;
                List values = (List)properties.get(key);
                if (values == null) continue;
                for (Object valueObj : values) {
                    String value = (String)valueObj;
                    this.addAttribute(key, value);
                }
            }
        }
    }
}

