/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.schema;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.schema.SchemaFilter;
import org.wso2.carbon.governance.api.schema.dataobjects.Schema;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class SchemaManager {
    private static final Log log = LogFactory.getLog(SchemaManager.class);
    private Registry registry;

    public SchemaManager(Registry registry) {
        this.registry = registry;
    }

    public Schema newSchema(String url) throws GovernanceException {
        String schemaId = UUID.randomUUID().toString();
        Schema schema = new Schema(schemaId, url);
        schema.associateRegistry(this.registry);
        return schema;
    }

    public Schema newSchema(byte[] content) throws RegistryException {
        return this.newSchema(content, null);
    }

    public Schema newSchema(byte[] content, String name) throws RegistryException {
        String schemaId = UUID.randomUUID().toString();
        Schema schema = new Schema(schemaId, name != null ? "name://" + name : null);
        schema.associateRegistry(this.registry);
        schema.setSchemaElement(GovernanceUtils.buildOMElement(content));
        return schema;
    }

    public void addSchema(Schema schema) throws GovernanceException {
        boolean succeeded = false;
        try {
            this.registry.beginTransaction();
            String url = schema.getUrl();
            Resource schemaResource = this.registry.newResource();
            schemaResource.setMediaType("application/x-xsd+xml");
            this.setContent(schema, schemaResource);
            String tmpPath = schema.getQName() != null ? "/" + schema.getQName().getLocalPart() : (url != null && !url.startsWith("name://") ? RegistryUtils.getResourceName((String)new URL(url).getFile().replace("~", "")) : (url != null ? url.substring("name://".length()) : schema.getId() + ".xsd"));
            Resource resource = url == null || url.startsWith("name://") ? this.registry.get(this.registry.put("/" + tmpPath, schemaResource)) : this.registry.get(this.registry.importResource(tmpPath, url, schemaResource));
            schema.setId(resource.getUUID());
            schema.updatePath();
            schema.loadSchemaDetails();
            succeeded = true;
        }
        catch (RegistryException e) {
            String msg = "Error in adding the Schema. schema id: " + schema.getId() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        catch (MalformedURLException e) {
            String msg = "Malformed schema url provided. url: " + schema.getUrl() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        finally {
            if (succeeded) {
                try {
                    this.registry.commitTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in committing transactions. Add schema failed: schema id: " + schema.getId() + ", path: " + schema.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            } else {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in rolling back transactions. Add schema failed: schema id: " + schema.getId() + ", path: " + schema.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    public void updateSchema(Schema schema) throws GovernanceException {
        if (schema.getSchemaElement() == null) {
            String msg = "Updates are only accepted if the schemeElement is available. So no updates will be done. schema id: " + schema.getId() + ", schema path: " + schema.getPath() + ".";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        boolean succeeded = false;
        try {
            this.registry.beginTransaction();
            Schema oldSchema = this.getSchema(schema.getId());
            if (oldSchema == null) {
                this.addSchema(schema);
                return;
            }
            Resource schemaResource = this.registry.newResource();
            schemaResource.setMediaType("application/x-xsd+xml");
            this.setContent(schema, schemaResource);
            schemaResource.setUUID(schema.getId());
            this.registry.put(oldSchema.getPath(), schemaResource);
            schema.setId(schemaResource.getUUID());
            schema.updatePath();
            schema.loadSchemaDetails();
            succeeded = true;
        }
        catch (RegistryException e) {
            String msg = "Error in updating the schema, schema id: " + schema.getId() + ", schema path: " + schema.getPath() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        finally {
            if (succeeded) {
                try {
                    this.registry.commitTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in committing transactions. Update schema failed: schema id: " + schema.getId() + ", path: " + schema.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            } else {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in rolling back transactions. Update schema failed: schema id: " + schema.getId() + ", path: " + schema.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    public Schema getSchema(String schemaId) throws GovernanceException {
        GovernanceArtifact artifact = GovernanceUtils.retrieveGovernanceArtifactById(this.registry, schemaId);
        if (artifact != null && !(artifact instanceof Schema)) {
            String msg = "The artifact request is not a Schema. id: " + schemaId + ".";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        return (Schema)artifact;
    }

    public void removeSchema(String schemaId) throws GovernanceException {
        GovernanceUtils.removeArtifact(this.registry, schemaId);
    }

    protected void setContent(Schema schema, Resource schemaResource) throws GovernanceException {
        String[] attributeKeys;
        if (schema.getSchemaElement() != null) {
            OMElement contentElement = schema.getSchemaElement().cloneOMElement();
            try {
                for (String importType : new String[]{"import", "include", "redefine"}) {
                    List<OMElement> schemaImports = GovernanceUtils.evaluateXPathToElements("//xsd:" + importType, contentElement);
                    for (OMElement schemaImport : schemaImports) {
                        String path;
                        OMAttribute location = schemaImport.getAttribute(new QName("schemaLocation"));
                        if (location == null || (path = location.getAttributeValue()).indexOf(";version:") <= 0) continue;
                        location.setAttributeValue(path.substring(0, path.lastIndexOf(";version:")));
                    }
                }
            }
            catch (JaxenException ignore) {
                // empty catch block
            }
            String schemaContent = contentElement.toString();
            try {
                schemaResource.setContent((Object)schemaContent);
            }
            catch (RegistryException e) {
                String msg = "Error in setting the content from schema, schema id: " + schema.getId() + ", schema path: " + schema.getPath() + ".";
                log.error((Object)msg, (Throwable)e);
                throw new GovernanceException(msg, e);
            }
        }
        if ((attributeKeys = schema.getAttributeKeys()) != null) {
            Properties properties = new Properties();
            for (String attributeKey : attributeKeys) {
                String[] attributeValues = schema.getAttributes(attributeKey);
                if (attributeValues == null) continue;
                properties.put(attributeKey, new ArrayList<String>(Arrays.asList(attributeValues)));
            }
            schemaResource.setProperties(properties);
        }
        schemaResource.setUUID(schema.getId());
    }

    public Schema[] findSchemas(SchemaFilter criteria) throws GovernanceException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (Schema schema : this.getAllSchemas()) {
            if (schema == null || !criteria.matches(schema)) continue;
            schemas.add(schema);
        }
        return schemas.toArray(new Schema[schemas.size()]);
    }

    public Schema[] getAllSchemas() throws GovernanceException {
        List<String> schemaPaths = Arrays.asList(GovernanceUtils.getResultPaths(this.registry, "application/x-xsd+xml"));
        Collections.sort(schemaPaths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int result = RegistryUtils.getResourceName((String)o1).compareToIgnoreCase(RegistryUtils.getResourceName((String)o2));
                if (result != 0) {
                    return result;
                }
                return o1.compareToIgnoreCase(o2);
            }
        });
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (String schemaPath : schemaPaths) {
            GovernanceArtifact artifact = GovernanceUtils.retrieveGovernanceArtifactByPath(this.registry, schemaPath);
            schemas.add((Schema)artifact);
        }
        return schemas.toArray(new Schema[schemas.size()]);
    }
}

