/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.generic;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.governance.api.common.GovernanceArtifactManager;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactFilter;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class GenericArtifactManager {
    private String artifactNameAttribute;
    private String artifactNamespaceAttribute;
    private String artifactElementNamespace;
    private GovernanceArtifactManager manager;

    public GenericArtifactManager(Registry registry, String mediaType, String artifactNameAttribute, String artifactNamespaceAttribute, String artifactElementRoot, String artifactElementNamespace, String pathExpression, Association[] relationshipDefinitions) {
        this.manager = new GovernanceArtifactManager(registry, mediaType, artifactNameAttribute, artifactNamespaceAttribute, artifactElementRoot, artifactElementNamespace, pathExpression, relationshipDefinitions);
        this.artifactNameAttribute = artifactNameAttribute;
        this.artifactNamespaceAttribute = artifactNamespaceAttribute;
        this.artifactElementNamespace = artifactElementNamespace;
    }

    public GenericArtifactManager(Registry registry, String key) throws RegistryException {
        try {
            GovernanceArtifactConfiguration configuration = GovernanceUtils.findGovernanceArtifactConfiguration(key, registry);
            this.artifactNameAttribute = configuration.getArtifactNameAttribute();
            this.artifactNamespaceAttribute = configuration.getArtifactNamespaceAttribute();
            this.artifactElementNamespace = configuration.getArtifactElementNamespace();
            this.manager = new GovernanceArtifactManager(registry, configuration.getMediaType(), this.artifactNameAttribute, this.artifactNamespaceAttribute, configuration.getArtifactElementRoot(), this.artifactElementNamespace, configuration.getPathExpression(), configuration.getRelationshipDefinitions());
        }
        catch (RegistryException e) {
            throw new GovernanceException("Unable to obtain governance artifact configuration", e);
        }
    }

    public GenericArtifact newGovernanceArtifact(QName qName) throws GovernanceException {
        GenericArtifact genericArtifact = new GenericArtifact(this.manager.newGovernanceArtifact()){};
        genericArtifact.setQName(qName);
        return genericArtifact;
    }

    public GenericArtifact newGovernanceArtifact(OMElement content) throws GovernanceException {
        String namespace;
        GenericArtifact genericArtifact = new GenericArtifact(this.manager.newGovernanceArtifact(content)){};
        String name = GovernanceUtils.getAttributeValue(content, this.artifactNameAttribute, this.artifactElementNamespace);
        String string = namespace = this.artifactNamespaceAttribute != null ? GovernanceUtils.getAttributeValue(content, this.artifactNamespaceAttribute, this.artifactElementNamespace) : null;
        if (name == null || name.equals("")) {
            throw new GovernanceException("Unable to compute QName from given XML payload, please ensure that the content passed in matches the configuration.");
        }
        genericArtifact.setQName(new QName(namespace, name));
        return genericArtifact;
    }

    public void addGenericArtifact(GenericArtifact artifact) throws GovernanceException {
        this.manager.addGovernanceArtifact(artifact);
    }

    public void updateGenericArtifact(GenericArtifact artifact) throws GovernanceException {
        this.manager.updateGovernanceArtifact(artifact);
    }

    public GenericArtifact getGenericArtifact(String artifactId) throws GovernanceException {
        GovernanceArtifact governanceArtifact = this.manager.getGovernanceArtifact(artifactId);
        if (governanceArtifact == null) {
            return null;
        }
        return new GenericArtifact(governanceArtifact){};
    }

    public void removeGenericArtifact(String artifactId) throws GovernanceException {
        this.manager.removeGovernanceArtifact(artifactId);
    }

    public GenericArtifact[] findGenericArtifacts(GenericArtifactFilter criteria) throws GovernanceException {
        ArrayList<GenericArtifact> artifacts = new ArrayList<GenericArtifact>();
        for (GenericArtifact artifact : this.getAllGenericArtifacts()) {
            if (artifact == null || !criteria.matches(artifact)) continue;
            artifacts.add(artifact);
        }
        return artifacts.toArray(new GenericArtifact[artifacts.size()]);
    }

    public GenericArtifact[] getAllGenericArtifacts() throws GovernanceException {
        return this.getGenericArtifacts(this.manager.getAllGovernanceArtifacts());
    }

    private GenericArtifact[] getGenericArtifacts(GovernanceArtifact[] governanceArtifacts) {
        ArrayList<4> artifacts = new ArrayList<4>(governanceArtifacts.length);
        for (GovernanceArtifact governanceArtifact : governanceArtifacts) {
            artifacts.add(new GenericArtifact(governanceArtifact){});
        }
        return artifacts.toArray(new GenericArtifact[artifacts.size()]);
    }

    public String[] getAllGenericArtifactIds() throws GovernanceException {
        return this.manager.getAllGovernanceArtifactIds();
    }
}

