/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.endpoints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.endpoints.dataobjects.Endpoint;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class EndpointManager {
    private static final Log log = LogFactory.getLog(EndpointManager.class);
    private Registry registry;

    public EndpointManager(Registry registry) {
        this.registry = registry;
    }

    public Endpoint newEndpoint(String url) throws GovernanceException {
        String endpointId = UUID.randomUUID().toString();
        Endpoint endpoint = new Endpoint(url, endpointId);
        endpoint.associateRegistry(this.registry);
        return endpoint;
    }

    public void addEndpoint(Endpoint endpoint) throws GovernanceException {
        boolean succeeded = false;
        try {
            this.registry.beginTransaction();
            Resource endpointResource = this.registry.newResource();
            endpointResource.setMediaType("application/vnd.wso2.endpoint");
            this.setContent(endpoint, endpointResource);
            String tmpPath = "/" + GovernanceUtils.getNameFromUrl(endpoint.getUrl());
            endpointResource.setUUID(endpoint.getId());
            Resource resource = this.registry.get(this.registry.put(tmpPath, endpointResource));
            endpoint.setId(resource.getUUID());
            endpoint.updatePath();
            succeeded = true;
        }
        catch (RegistryException e) {
            String msg = "Add endpoint failed: endpoint id: " + endpoint.getId() + ", path: " + endpoint.getPath() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        finally {
            if (succeeded) {
                try {
                    this.registry.commitTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in committing transactions. Add endpoint failed: endpoint id: " + endpoint.getId() + ", path: " + endpoint.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            } else {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in rolling back transactions. Add endpoint failed: endpoint id: " + endpoint.getId() + ", path: " + endpoint.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    public void updateEndpoint(Endpoint endpoint) throws GovernanceException {
        if (endpoint.getUrl() == null) {
            String msg = "Updates are only accepted if the url is available. So no updates will be done. endpoint id: " + endpoint.getId() + ", endpoint path: " + endpoint.getPath() + ".";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        boolean succeeded = false;
        try {
            this.registry.beginTransaction();
            Endpoint oldEndpoint = this.getEndpoint(endpoint.getId());
            if (oldEndpoint != null) {
                String oldPath = oldEndpoint.getPath();
                this.registry.delete(oldPath);
            }
            this.addEndpoint(endpoint);
            succeeded = true;
        }
        catch (RegistryException e) {
            String msg = "Error in updating the endpoint, endpoint id: " + endpoint.getId() + ", endpoint path: " + endpoint.getPath() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        finally {
            if (succeeded) {
                try {
                    this.registry.commitTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in committing transactions. Update endpoint failed: endpoint id: " + endpoint.getId() + ", path: " + endpoint.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            } else {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    String msg = "Error in rolling back transactions. Update endpoint failed: endpoint id: " + endpoint.getId() + ", path: " + endpoint.getPath() + ".";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    public Endpoint getEndpoint(String endpointId) throws GovernanceException {
        GovernanceArtifact artifact = GovernanceUtils.retrieveGovernanceArtifactById(this.registry, endpointId);
        if (artifact != null && !(artifact instanceof Endpoint)) {
            String msg = "The artifact request is not an endpoint. id: " + endpointId + ".";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        return (Endpoint)artifact;
    }

    public void removeEndpoint(String endpointId) throws GovernanceException {
        GovernanceUtils.removeArtifact(this.registry, endpointId);
    }

    public void setContent(Endpoint endpoint, Resource endpointResource) throws GovernanceException {
        String url = endpoint.getUrl();
        try {
            endpointResource.setContent((Object)url);
        }
        catch (RegistryException e) {
            String msg = "Error in setting the resource content for endpoint. path: " + endpoint.getPath() + ", " + "id: " + endpoint.getId() + ".";
            log.error((Object)msg);
            throw new GovernanceException(msg, e);
        }
        String[] attributeKeys = endpoint.getAttributeKeys();
        if (attributeKeys != null) {
            Properties properties = new Properties();
            for (String attributeKey : attributeKeys) {
                String[] attributeValues = endpoint.getAttributes(attributeKey);
                if (attributeValues == null) continue;
                properties.put(attributeKey, new ArrayList<String>(Arrays.asList(attributeValues)));
            }
            endpointResource.setProperties(properties);
        }
        endpointResource.setUUID(endpoint.getId());
    }

    public Endpoint getEndpointByUrl(String url) throws GovernanceException {
        Resource r;
        String path = CommonUtil.getEndpointPathFromUrl((String)url);
        try {
            if (!this.registry.resourceExists(path)) {
                return null;
            }
            r = this.registry.get(path);
        }
        catch (RegistryException e) {
            String msg = "Error in retrieving the endpoint resource. url:" + url + ", path:" + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        String artifactId = r.getUUID();
        if (artifactId != null) {
            return this.getEndpoint(artifactId);
        }
        return null;
    }
}

