/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.api.common.dataobjects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public abstract class GovernanceArtifact {
    private static final Log log = LogFactory.getLog(GovernanceArtifact.class);
    private String id;
    private String path;
    private Registry registry;
    protected Map<String, List<String>> attributes = new HashMap<String, List<String>>();

    public GovernanceArtifact(String id) {
        this.id = id;
    }

    public GovernanceArtifact() {
    }

    protected GovernanceArtifact(GovernanceArtifact artifact) {
        this.attributes = artifact.attributes;
        try {
            this.associateRegistry(artifact.getAssociatedRegistry());
        }
        catch (GovernanceException governanceException) {
            // empty catch block
        }
        this.setId(artifact.getId());
    }

    public GovernanceArtifact(String id, OMElement contentElement) throws GovernanceException {
        this(id);
        this.serializeToAttributes(contentElement, null);
    }

    private void serializeToAttributes(OMElement contentElement, String parentAttributeName) throws GovernanceException {
        Iterator childIt = contentElement.getChildren();
        while (childIt.hasNext()) {
            OMText childText;
            Object childObj = childIt.next();
            if (childObj instanceof OMElement) {
                OMElement childElement = (OMElement)childObj;
                String elementName = childElement.getLocalName();
                String attributeName = (parentAttributeName == null ? "" : parentAttributeName + "_") + elementName;
                this.serializeToAttributes(childElement, attributeName);
                continue;
            }
            if (!(childObj instanceof OMText) || (childText = (OMText)childObj).getNextOMSibling() != null || childText.getPreviousOMSibling() != null) continue;
            String textValue = childText.getText();
            this.addAttribute(parentAttributeName, textValue);
        }
    }

    public static GovernanceArtifact create(final Registry registry, String artifactId) throws GovernanceException {
        return new GovernanceArtifact(artifactId){
            {
                super(x0);
                this.associateRegistry(registry);
            }

            @Override
            public QName getQName() {
                return null;
            }
        };
    }

    public static GovernanceArtifact create(final Registry registry, String artifactId, OMElement content) throws GovernanceException {
        return new GovernanceArtifact(artifactId, content){
            {
                super(x0, x1);
                this.associateRegistry(registry);
            }

            @Override
            public QName getQName() {
                return null;
            }
        };
    }

    public abstract QName getQName();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPath() throws GovernanceException {
        if (this.path == null) {
            this.path = GovernanceUtils.getArtifactPath(this.registry, this.id);
        }
        return this.path;
    }

    public String getLifecycleName() throws GovernanceException {
        String path = this.getPath();
        if (path != null) {
            try {
                if (!this.registry.resourceExists(path)) {
                    String msg = "The artifact is not added to the registry. Please add the artifact before reading lifecycle information.";
                    log.error((Object)msg);
                    throw new GovernanceException(msg);
                }
                return this.registry.get(path).getProperty("registry.LC.name");
            }
            catch (RegistryException e) {
                String msg = "Error in obtaining lifecycle name for the artifact. id: " + this.id + ", path: " + path + ".";
                log.error((Object)msg, (Throwable)e);
                throw new GovernanceException(msg, e);
            }
        }
        return null;
    }

    public void attachLifecycle(String name) throws GovernanceException {
        String lifecycleName = this.getLifecycleName();
        try {
            if (name == null) {
                GovernanceUtils.removeAspect(this.path, lifecycleName, this.registry);
                return;
            }
            if (!name.equals(lifecycleName)) {
                if (lifecycleName != null) {
                    GovernanceUtils.removeAspect(this.path, lifecycleName, this.registry);
                }
                this.registry.associateAspect(this.path, name);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in associating lifecycle for the artifact. id: " + this.id + ", path: " + this.path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    public String getLifecycleState() throws GovernanceException {
        String path = this.getPath();
        if (path != null) {
            try {
                if (!this.registry.resourceExists(path)) {
                    String msg = "The artifact is not added to the registry. Please add the artifact before reading lifecycle information.";
                    log.error((Object)msg);
                    throw new GovernanceException(msg);
                }
                Resource resource = this.registry.get(path);
                for (Object object : resource.getProperties().keySet()) {
                    String property = (String)object;
                    if (!property.startsWith("registry.lifecycle.") || !property.endsWith(".state")) continue;
                    return resource.getProperty(property);
                }
            }
            catch (RegistryException e) {
                String msg = "Error in obtaining lifecycle state for the artifact. id: " + this.id + ", path: " + path + ".";
                log.error((Object)msg, (Throwable)e);
                throw new GovernanceException(msg, e);
            }
        }
        return null;
    }

    public void updatePath() throws GovernanceException {
        this.path = GovernanceUtils.getArtifactPath(this.registry, this.id);
    }

    public void updatePath(String artifactId) throws GovernanceException {
        this.path = GovernanceUtils.getArtifactPath(this.registry, artifactId);
    }

    public void createVersion() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        try {
            if (!this.registry.resourceExists(this.path)) {
                String msg = "The artifact is not added to the registry. Please add the artifact before creating versions.";
                log.error((Object)msg);
                throw new GovernanceException(msg);
            }
            this.registry.createVersion(this.path);
        }
        catch (RegistryException e) {
            String msg = "Error in creating a version for the artifact. id: " + this.id + ", path: " + this.path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    public void associateRegistry(Registry registry) throws GovernanceException {
        this.registry = registry;
    }

    public void addAttribute(String key, String value) throws GovernanceException {
        List<String> values = this.attributes.get(key);
        if (values == null) {
            values = new ArrayList<String>();
            this.attributes.put(key, values);
        }
        values.add(value);
    }

    public void setAttributes(String key, String[] newValues) throws GovernanceException {
        ArrayList<String> values = new ArrayList<String>();
        values.addAll(Arrays.asList(newValues));
        this.attributes.put(key, values);
    }

    public void setAttribute(String key, String newValue) throws GovernanceException {
        ArrayList<String> values = new ArrayList<String>();
        values.add(newValue);
        this.attributes.put(key, values);
    }

    public String getAttribute(String key) throws GovernanceException {
        List<String> values = this.attributes.get(key);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    public String[] getAttributeKeys() throws GovernanceException {
        Set<String> attributeKeys = this.attributes.keySet();
        if (attributeKeys == null) {
            return null;
        }
        return attributeKeys.toArray(new String[attributeKeys.size()]);
    }

    public String[] getAttributes(String key) throws GovernanceException {
        List<String> values = this.attributes.get(key);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public void removeAttribute(String key) throws GovernanceException {
        this.attributes.remove(key);
    }

    public GovernanceArtifact[] getDependencies() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        String path = this.getPath();
        ArrayList<GovernanceArtifact> governanceArtifacts = new ArrayList<GovernanceArtifact>();
        try {
            Association[] associations;
            for (Association association : associations = this.registry.getAssociations(path, "depends")) {
                String destinationPath = association.getDestinationPath();
                GovernanceArtifact governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(this.registry, destinationPath);
                governanceArtifacts.add(governanceArtifact);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in getting dependencies from the artifact. id: " + this.id + ", path: " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        return governanceArtifacts.toArray(new GovernanceArtifact[governanceArtifacts.size()]);
    }

    public GovernanceArtifact[] getDependents() throws GovernanceException {
        this.checkRegistryResourceAssociation();
        String path = this.getPath();
        ArrayList<GovernanceArtifact> governanceArtifacts = new ArrayList<GovernanceArtifact>();
        try {
            Association[] associations;
            for (Association association : associations = this.registry.getAssociations(path, "usedBy")) {
                String destinationPath = association.getDestinationPath();
                GovernanceArtifact governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath(this.registry, destinationPath);
                governanceArtifacts.add(governanceArtifact);
            }
        }
        catch (RegistryException e) {
            String msg = "Error in getting dependents from the artifact. id: " + this.id + ", path: " + path + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
        return governanceArtifacts.toArray(new GovernanceArtifact[governanceArtifacts.size()]);
    }

    protected void attach(GovernanceArtifact attachedToArtifact) throws GovernanceException {
        this.checkRegistryResourceAssociation();
        String path = this.getPath();
        String attachedToArtifactPath = attachedToArtifact.getPath();
        if (attachedToArtifactPath == null) {
            String msg = "'Attached to artifact' is not associated with a registry path.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        try {
            this.registry.addAssociation(path, attachedToArtifactPath, "depends");
            this.registry.addAssociation(attachedToArtifactPath, path, "usedBy");
        }
        catch (RegistryException e) {
            String msg = "Error in attaching the artifact. source id: " + this.id + ", path: " + path + ", target id: " + attachedToArtifact.getId() + ", path:" + attachedToArtifactPath + ", attachment type: " + attachedToArtifact.getClass().getName() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    protected void detach(String artifactId) throws GovernanceException {
        this.checkRegistryResourceAssociation();
        String path = this.getPath();
        String artifactPath = GovernanceUtils.getArtifactPath(this.registry, artifactId);
        if (artifactPath == null) {
            String msg = "Attached to artifact is not associated with a registry path.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        try {
            this.registry.removeAssociation(path, artifactPath, "depends");
            this.registry.removeAssociation(artifactPath, path, "usedBy");
        }
        catch (RegistryException e) {
            String msg = "Error in detaching the artifact. source id: " + this.id + ", path: " + path + ", target id: " + artifactId + ", target path:" + artifactPath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new GovernanceException(msg, e);
        }
    }

    protected void checkRegistryResourceAssociation() throws GovernanceException {
        String path = this.getPath();
        if (this.registry == null) {
            String msg = "A registry is not associated with the artifact.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        if (path == null) {
            String msg = "A path is not associated with the artifact.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
        if (this.id == null) {
            String msg = "An id is not associated with the artifact.";
            log.error((Object)msg);
            throw new GovernanceException(msg);
        }
    }

    protected Registry getAssociatedRegistry() {
        return this.registry;
    }
}

