/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.google.analytics.ui.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.stratos.common.util.CommonUtil;

public class GoogleAnalyticsServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(GoogleAnalyticsServlet.class);
    private static String GOOGLE_ANALYTICS_URL = "GoogleAnalyticsURL";
    private static String googleAnalyticsURL = "googleAnalyticUrl";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String url = null;
        try {
            url = CommonUtil.loadStratosConfiguration().getGoogleAnalyticsURL();
            if (url != null && !url.equals("")) {
                String inputLine;
                URL googleAnalyticUrl = new URL(url);
                URLConnection connection = googleAnalyticUrl.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                response.setContentType("text/javascript");
                PrintWriter out = response.getWriter();
                while ((inputLine = in.readLine()) != null) {
                    out.write(inputLine);
                }
                in.close();
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            String msg = "Failed to get content from the url." + url + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            response.setStatus(500);
        }
    }
}

