/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.wsdl2form;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.wsdl2form.SchemaURIResolver;
import org.wso2.carbon.wsdl2form.XSLTURIResolver;

public class Util {
    private static Log log = LogFactory.getLog(Util.class);
    public static final String WSDL2SIG_XSL_LOCATION = "xslt/wsdl2sig.xslt";
    public static final String JSSTUB_XSL_LOCATION = "xslt/jsstub.xslt";
    public static final String MOCKIT_XSL_LOCATION = "xslt/mockit.xslt";
    public static final String TRYIT_XSL_LOCATION = "xslt/tryit.xslt";
    public static final String VIEWIT_XSL_LOCATION = "xslt/viewit.xslt";
    public static String TRYIT_SG_NAME = "TryItMockServiceGroup";
    public static String LAST_TOUCH_TIME = "_LAST_TOUCH_TIME_";
    public static final long PERIOD = 1200000L;

    public static DOMSource getSigStream(AxisService service, ByteArrayOutputStream wsdlOutStream, Map paramMap) throws TransformerFactoryConfigurationError, TransformerException, ParserConfigurationException {
        StreamSource wsdlSource = new StreamSource(new ByteArrayInputStream(wsdlOutStream.toByteArray()));
        InputStream sigStream = Util.class.getClassLoader().getResourceAsStream(WSDL2SIG_XSL_LOCATION);
        StreamSource wsdl2sigXSLTSource = new StreamSource(sigStream);
        DocumentBuilder docB = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document docSig = docB.newDocument();
        DOMResult resultSig = new DOMResult(docSig);
        Util.transform(wsdlSource, wsdl2sigXSLTSource, resultSig, paramMap, new SchemaURIResolver(service));
        return new DOMSource(docSig);
    }

    public static DOMSource getSigStream(AxisService axisService, Map paramMap) throws TransformerFactoryConfigurationError, TransformerException, AxisFault, ParserConfigurationException {
        ByteArrayOutputStream wsdlOutStream = new ByteArrayOutputStream();
        axisService.printWSDL2((OutputStream)wsdlOutStream);
        return Util.getSigStream(axisService, wsdlOutStream, paramMap);
    }

    public static void transform(Source xmlIn, Source xslIn, Result result, Map paramMap) throws TransformerException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(xslIn);
            if (paramMap != null) {
                Set set = paramMap.keySet();
                for (Object aSet : set) {
                    if (aSet == null) continue;
                    String key = (String)aSet;
                    String value = (String)paramMap.get(key);
                    transformer.setParameter(key, value);
                }
            }
            transformer.transform(xmlIn, result);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static void transform(Source xmlIn, Source xslIn, Result result, Map paramMap, URIResolver uriResolver) throws TransformerException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver(uriResolver);
            Transformer transformer = transformerFactory.newTransformer(xslIn);
            if (paramMap != null) {
                Set set = paramMap.keySet();
                for (Object aSet : set) {
                    String key = (String)aSet;
                    String value = (String)paramMap.get(key);
                    transformer.setParameter(key, value);
                }
            }
            transformer.transform(xmlIn, result);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static void generateTryit(Source xmlIn, Result result, Map paramMap) throws TransformerException {
        InputStream tryItXSLTStream = Util.class.getClassLoader().getResourceAsStream(TRYIT_XSL_LOCATION);
        StreamSource tryItXSLSource = new StreamSource(tryItXSLTStream);
        Util.transform(xmlIn, tryItXSLSource, result, paramMap, new XSLTURIResolver());
    }

    public static void generateViewit(Source xmlIn, Result result, Map paramMap) throws TransformerException {
        InputStream viewItXSLTStream = Util.class.getClassLoader().getResourceAsStream(VIEWIT_XSL_LOCATION);
        StreamSource viewItXSLSource = new StreamSource(viewItXSLTStream);
        Util.transform(xmlIn, viewItXSLSource, result, paramMap);
    }

    public static void generateMockit(Source xmlIn, Result result, Map paramMap) throws TransformerException {
        InputStream tryItXSLTStream = Util.class.getClassLoader().getResourceAsStream(MOCKIT_XSL_LOCATION);
        StreamSource tryItXSLSource = new StreamSource(tryItXSLTStream);
        Util.transform(xmlIn, tryItXSLSource, result, paramMap);
    }

    public static void generateStub(Source xmlIn, Result result, Map paramMap) throws TransformerException {
        InputStream stubXSLTStream = Util.class.getClassLoader().getResourceAsStream(JSSTUB_XSL_LOCATION);
        StreamSource stubXSLSource = new StreamSource(stubXSLTStream);
        Util.transform(xmlIn, stubXSLSource, result, paramMap, new XSLTURIResolver());
    }

    public static String writeWSDLToFileSystem(String url) throws AxisFault {
        return Util.writeWSDLToFileSystemHelpler(url).getAbsolutePath();
    }

    public static InputStream writeWSDLToStream(String url) throws IOException {
        return new FileInputStream(Util.writeWSDLToFileSystemHelpler(url));
    }

    public static FileInfo getOutputFileLocation(String suffix) throws CarbonException {
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
        String extraFileLocation = MessageContext.getCurrentMessageContext().getConfigurationContext().getProperty("WORK_DIR") + File.separator + "extra" + File.separator + uuid + File.separator;
        File dirs = new File(extraFileLocation);
        if (!dirs.exists() && !dirs.mkdirs()) {
            throw new CarbonException("Unable to create directory " + dirs.getName());
        }
        File outFile = new File(extraFileLocation, uuid + suffix);
        return new FileInfo(uuid, outFile);
    }

    public static File writeWSDLToFileSystemHelpler(String url) throws AxisFault {
        InputStream inStrm = null;
        BufferedInputStream bIn = null;
        FileOutputStream out = null;
        HttpURLConnection uconn = null;
        try {
            int len;
            URL wsdlURL = new URL(url);
            URLConnection connection = wsdlURL.openConnection();
            if (!(connection instanceof HttpURLConnection)) {
                String msg = "Unable to process given URL. Only HTTP protocol is currently supported.";
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
            uconn = (HttpURLConnection)connection;
            uconn.setRequestMethod("GET");
            uconn.setAllowUserInteraction(false);
            uconn.setDefaultUseCaches(false);
            uconn.setDoInput(true);
            uconn.setDoOutput(false);
            uconn.setInstanceFollowRedirects(true);
            uconn.setUseCaches(false);
            uconn.connect();
            inStrm = uconn.getInputStream();
            bIn = new BufferedInputStream(inStrm);
            File outFile = Util.getOutputFileLocation(".xml").getFile();
            out = new FileOutputStream(outFile);
            byte[] buf = new byte[1024];
            while ((len = bIn.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            File file = outFile;
            return file;
        }
        catch (IllegalArgumentException e) {
            String msg = "URL provided is invalid. Please use a valid URL";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        catch (MalformedURLException e) {
            String msg = "URL provided is invalid. Please use a valid URL";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        catch (FileNotFoundException e) {
            String msg = "File provided is invalid. Please use a valid file.";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        catch (IOException e) {
            String msg = "Error in connection while retrieving the WSDL. Please check the connection and the url provided.";
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        catch (CarbonException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        finally {
            if (uconn != null) {
                uconn.disconnect();
            }
            if (bIn != null) {
                try {
                    bIn.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing I/O streams", (Throwable)e);
                }
            }
            if (inStrm != null) {
                try {
                    inStrm.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing I/O streams", (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing I/O streams", (Throwable)e);
                }
            }
        }
    }

    public static class FileInfo {
        private String uuid;
        private File file;

        public FileInfo(String uuid, File file) {
            this.uuid = uuid;
            this.file = file;
        }

        public String getUuid() {
            return this.uuid;
        }

        public File getFile() {
            return this.file;
        }
    }
}

